/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.InvalidEventTypeException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EventManager {
    private static EventManager _instance = new EventManager();
    private Hashtable _requests;

    public static EventManager getDefault() {
        return _instance;
    }

    public EventRequest getEventRequest(Event event) {
        EventRequest interestedRequest = null;
        Byte kind = new Byte(event.getEventKind());
        Hashtable requests = (Hashtable)this._requests.get(kind);
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        boolean match = false;
        Iterator rIter = requests.values().iterator();
        while (rIter.hasNext()) {
            EventRequest request = (EventRequest)rIter.next();
            if (!request.matches(event)) continue;
            interestedRequest = request;
        }
        return interestedRequest;
    }

    public void requestEvent(EventRequest request) throws InvalidEventTypeException {
        Byte kind = new Byte(request.getEventKind());
        Hashtable requests = (Hashtable)this._requests.get(kind);
        if (requests == null) {
            throw new InvalidEventTypeException(request.getEventKind());
        }
        VMVirtualMachine.registerEvent(request);
        requests.put(new Integer(request.getId()), request);
    }

    public void deleteRequest(byte kind, int id) {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        Integer iid = new Integer(id);
        EventRequest request = (EventRequest)requests.get(iid);
        if (request != null) {
            VMVirtualMachine.unregisterEvent(request);
            requests.remove(iid);
        }
    }

    public void clearRequests(byte kind) {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        VMVirtualMachine.clearEvents(kind);
        requests.clear();
    }

    public EventRequest getRequest(byte kind, int id) {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        return (EventRequest)requests.get(new Integer(id));
    }

    public Collection getRequests(byte kind) {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        return requests.values();
    }

    private final /* synthetic */ void this() {
        this._requests = null;
    }

    private EventManager() {
        this.this();
        this._requests = new Hashtable();
        this._requests.put(new Byte(1), new Hashtable());
        this._requests.put(new Byte(2), new Hashtable());
        this._requests.put(new Byte(3), new Hashtable());
        this._requests.put(new Byte(4), new Hashtable());
        this._requests.put(new Byte(5), new Hashtable());
        this._requests.put(new Byte(6), new Hashtable());
        this._requests.put(new Byte(7), new Hashtable());
        this._requests.put(new Byte(8), new Hashtable());
        this._requests.put(new Byte(9), new Hashtable());
        this._requests.put(new Byte(10), new Hashtable());
        this._requests.put(new Byte(20), new Hashtable());
        this._requests.put(new Byte(21), new Hashtable());
        this._requests.put(new Byte(40), new Hashtable());
        this._requests.put(new Byte(41), new Hashtable());
        this._requests.put(new Byte(90), new Hashtable());
        this._requests.put(new Byte(99), new Hashtable());
        try {
            this.requestEvent(new EventRequest(0, 90, 0));
            this.requestEvent(new EventRequest(0, 99, 0));
        }
        catch (InvalidEventTypeException invalidEventTypeException) {
            // empty catch block
        }
    }
}

