/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected MouseInputAdapter borderListener;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected PropertyChangeListener propertyChangeListener;
    private VetoableChangeListener internalFrameVetoableChangeListener;
    private transient BasicInternalFrameListener internalFrameListener;
    protected JComponent eastPane;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected KeyStroke openMenuKey;
    protected BasicInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    protected LayoutManager internalFrameLayout;
    private transient JDesktopPane desktopPane;

    public static ComponentUI createUI(JComponent b) {
        return new BasicInternalFrameUI((JInternalFrame)b);
    }

    public void installUI(JComponent c) {
        if (c instanceof JInternalFrame) {
            this.frame = (JInternalFrame)c;
            this.internalFrameLayout = this.createLayoutManager();
            this.frame.setLayout(this.internalFrameLayout);
            ((JComponent)this.frame.getRootPane().getGlassPane()).setOpaque(false);
            this.frame.getRootPane().getGlassPane().setVisible(true);
            this.installDefaults();
            this.installListeners();
            this.installComponents();
            this.installKeyboardActions();
            this.frame.setOpaque(true);
            this.frame.invalidate();
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.frame.setLayout(null);
        ((JComponent)this.frame.getRootPane().getGlassPane()).setOpaque(true);
        this.frame.getRootPane().getGlassPane().setVisible(false);
        this.frame = null;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        this.frame.setVisible(false);
    }

    protected void installKeyboardActions() {
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.createInternalFrameListener();
        this.borderListener = this.createBorderListener(this.frame);
        this.componentListener = this.createComponentListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.internalFrameVetoableChangeListener = new InternalFramePropertyChangeListener();
        this.frame.addMouseListener(this.borderListener);
        this.frame.addMouseMotionListener(this.borderListener);
        this.frame.addInternalFrameListener(this.internalFrameListener);
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.frame.addVetoableChangeListener(this.internalFrameVetoableChangeListener);
        this.frame.getRootPane().getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
    }

    protected void uninstallDefaults() {
        this.frame.setBorder(null);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        if (this.desktopPane != null) {
            this.desktopPane.removeComponentListener(this.componentListener);
        }
        this.frame.getRootPane().getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.frame.removeInternalFrameListener(this.internalFrameListener);
        this.frame.removeMouseMotionListener(this.borderListener);
        this.frame.removeMouseListener(this.borderListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.borderListener = null;
        this.internalFrameListener = null;
        this.glassPaneDispatcher = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent x) {
        return this.internalFrameLayout.preferredLayoutSize(x);
    }

    public Dimension getMinimumSize(JComponent x) {
        return this.internalFrameLayout.minimumLayoutSize(x);
    }

    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this.frame.remove(currentPane);
        }
        if (newPane != null) {
            this.installMouseHandlers(newPane);
            this.frame.add(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c) {
        c.removeMouseListener(this.borderListener);
        c.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent c) {
        c.addMouseListener(this.borderListener);
        c.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new BasicInternalFrameTitlePane(w);
        return this.titlePane;
    }

    protected JComponent createWestPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createSouthPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame w) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame w) {
        return new BorderListener();
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener();
    }

    protected final boolean isKeyBindingRegistered() {
        return false;
    }

    protected final void setKeyBindingRegistered(boolean b) {
    }

    public final boolean isKeyBindingActive() {
        return false;
    }

    protected final void setKeyBindingActive(boolean b) {
    }

    protected void setupMenuOpenKey() {
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent c) {
        this.replacePane(this.northPane, c);
        this.northPane = c;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent c) {
        this.replacePane(this.southPane, c);
        this.southPane = c;
    }

    public void setEastPane(JComponent c) {
        this.replacePane(this.eastPane, c);
        this.eastPane = c;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setWestPane(JComponent c) {
        this.replacePane(this.westPane, c);
        this.westPane = c;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    protected DesktopManager getDesktopManager() {
        DesktopManager value = null;
        JDesktopPane pane = this.frame.getDesktopPane();
        if (pane != null) {
            value = this.frame.getDesktopPane().getDesktopManager();
        }
        if (value == null) {
            value = this.createDesktopManager();
        }
        return value;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame f) {
        this.getDesktopManager().closeFrame(f);
    }

    protected void maximizeFrame(JInternalFrame f) {
        this.getDesktopManager().maximizeFrame(f);
    }

    protected void minimizeFrame(JInternalFrame f) {
        this.getDesktopManager().minimizeFrame(f);
    }

    protected void iconifyFrame(JInternalFrame f) {
        this.getDesktopManager().iconifyFrame(f);
    }

    protected void deiconifyFrame(JInternalFrame f) {
        this.getDesktopManager().deiconifyFrame(f);
    }

    protected void activateFrame(JInternalFrame f) {
        this.getDesktopManager().activateFrame(f);
    }

    protected void deactivateFrame(JInternalFrame f) {
        this.getDesktopManager().deactivateFrame(f);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher();
    }

    public BasicInternalFrameUI(JInternalFrame b) {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (e.getPropertyName().equals("closed")) {
                if (BasicInternalFrameUI.this.frame.getDefaultCloseOperation() == 1) {
                    BasicInternalFrameUI.this.frame.setVisible(false);
                    BasicInternalFrameUI.this.frame.getDesktopPane().repaint();
                    throw new PropertyVetoException("close operation is HIDE_ON_CLOSE\n", e);
                }
                if (BasicInternalFrameUI.this.frame.getDefaultCloseOperation() == 2) {
                    BasicInternalFrameUI.this.closeFrame(BasicInternalFrameUI.this.frame);
                } else {
                    throw new PropertyVetoException("close operation is DO_NOTHING_ON_CLOSE\n", e);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("maximum")) {
                if (BasicInternalFrameUI.this.frame.isMaximum()) {
                    BasicInternalFrameUI.this.maximizeFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.minimizeFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (evt.getPropertyName().equals("icon")) {
                if (BasicInternalFrameUI.this.frame.isIcon()) {
                    BasicInternalFrameUI.this.iconifyFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.deiconifyFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (evt.getPropertyName().equals("selected")) {
                if (BasicInternalFrameUI.this.frame.isSelected()) {
                    BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.deactivateFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (evt.getPropertyName().equals("rootPane") || evt.getPropertyName().equals("glassPane")) {
                Component old = (Component)evt.getOldValue();
                old.removeMouseListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                old.removeMouseMotionListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                Component newPane = (Component)evt.getNewValue();
                newPane.addMouseListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                newPane.addMouseMotionListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                BasicInternalFrameUI.this.frame.revalidate();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class InternalFrameLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void layoutContainer(Container c) {
            Dimension dims = BasicInternalFrameUI.this.frame.getSize();
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            dims.width -= insets.left + insets.right;
            dims.height -= insets.top + insets.bottom;
            BasicInternalFrameUI.this.frame.getRootPane().getGlassPane().setBounds(0, 0, dims.width, dims.height);
            int nh = 0;
            int sh = 0;
            int ew = 0;
            int ww = 0;
            if (BasicInternalFrameUI.this.northPane != null) {
                Dimension nDims = BasicInternalFrameUI.this.northPane.getPreferredSize();
                nh = Math.min(nDims.height, dims.height);
                BasicInternalFrameUI.this.northPane.setBounds(insets.left, insets.top, dims.width, nh);
            }
            if (BasicInternalFrameUI.this.southPane != null) {
                Dimension sDims = BasicInternalFrameUI.this.southPane.getPreferredSize();
                sh = Math.min(sDims.height, dims.height - nh);
                BasicInternalFrameUI.this.southPane.setBounds(insets.left, insets.top + dims.height - sh, dims.width, sh);
            }
            int remHeight = dims.height - sh - nh;
            if (BasicInternalFrameUI.this.westPane != null) {
                Dimension wDims = BasicInternalFrameUI.this.westPane.getPreferredSize();
                ww = Math.min(dims.width, wDims.width);
                BasicInternalFrameUI.this.westPane.setBounds(insets.left, insets.top + nh, ww, remHeight);
            }
            if (BasicInternalFrameUI.this.eastPane != null) {
                Dimension eDims = BasicInternalFrameUI.this.eastPane.getPreferredSize();
                ew = Math.min(eDims.width, dims.width - ww);
                BasicInternalFrameUI.this.eastPane.setBounds(insets.left + dims.width - ew, insets.top + nh, ew, remHeight);
            }
            int remWidth = dims.width - ww - ew;
            BasicInternalFrameUI.this.frame.getRootPane().setBounds(insets.left + ww, insets.top + nh, remWidth, remHeight);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.getSize(c, true);
        }

        public Dimension maximumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.getSize(c, false);
        }

        private final Dimension getSize(Container c, boolean min) {
            Dimension dims;
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            Dimension contentDims = BasicInternalFrameUI.this.frame.getContentPane().getPreferredSize();
            if (min) {
                contentDims.height = 0;
                contentDims.width = 0;
            }
            int nWidth = 0;
            int nHeight = 0;
            int sWidth = 0;
            int sHeight = 0;
            int eWidth = 0;
            int eHeight = 0;
            int wWidth = 0;
            int wHeight = 0;
            if (BasicInternalFrameUI.this.northPane != null && (dims = BasicInternalFrameUI.this.northPane.getPreferredSize()) != null) {
                nWidth = dims.width;
                nHeight = dims.height;
            }
            if (BasicInternalFrameUI.this.southPane != null && (dims = BasicInternalFrameUI.this.southPane.getPreferredSize()) != null) {
                sWidth = dims.width;
                sHeight = dims.height;
            }
            if (BasicInternalFrameUI.this.eastPane != null && (dims = BasicInternalFrameUI.this.eastPane.getPreferredSize()) != null) {
                sWidth = dims.width;
                sHeight = dims.height;
            }
            if (BasicInternalFrameUI.this.westPane != null && (dims = BasicInternalFrameUI.this.westPane.getPreferredSize()) != null) {
                wWidth = dims.width;
                wHeight = dims.height;
            }
            int width = Math.max(sWidth, nWidth);
            width = Math.max(width, contentDims.width + eWidth + wWidth);
            int height = Math.max(eHeight, wHeight);
            height = Math.max(height, contentDims.height);
            height += nHeight + sHeight;
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        protected final int RESIZE_NONE = 0;
        private transient int xOffset;
        private transient int yOffset;
        private transient int direction;
        private transient Rectangle cacheRect;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (BasicInternalFrameUI.this.frame.isMaximum()) {
                return;
            }
            DesktopManager dm = BasicInternalFrameUI.this.getDesktopManager();
            Rectangle b = BasicInternalFrameUI.this.frame.getBounds();
            Dimension min = BasicInternalFrameUI.this.frame.getMinimumSize();
            if (min == null) {
                min = new Dimension(0, 0);
            }
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            int x = e.getX();
            int y = e.getY();
            if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                switch (this.direction) {
                    case 1: {
                        this.cacheRect.setBounds(b.x, Math.min(b.y + y, b.y + b.height - min.height), b.width, b.height - y);
                        break;
                    }
                    case 2: {
                        this.cacheRect.setBounds(b.x, Math.min(b.y + y, b.y + b.height - min.height), x, b.height - y);
                        break;
                    }
                    case 3: {
                        this.cacheRect.setBounds(b.x, b.y, x, b.height);
                        break;
                    }
                    case 4: {
                        this.cacheRect.setBounds(b.x, b.y, x, y);
                        break;
                    }
                    case 5: {
                        this.cacheRect.setBounds(b.x, b.y, b.width, y);
                        break;
                    }
                    case 6: {
                        this.cacheRect.setBounds(Math.min(b.x + x, b.x + b.width - min.width), b.y, b.width - x, y);
                        break;
                    }
                    case 7: {
                        this.cacheRect.setBounds(Math.min(b.x + x, b.x + b.width - min.width), b.y, b.width - x, b.height);
                        break;
                    }
                    case 8: {
                        this.cacheRect.setBounds(Math.min(b.x + x, b.x + b.width - min.width), Math.min(b.y + y, b.y + b.height - min.height), b.width - x, b.height - y);
                        break;
                    }
                }
                dm.resizeFrame(BasicInternalFrameUI.this.frame, this.cacheRect.x, this.cacheRect.y, Math.max(min.width, this.cacheRect.width), Math.max(min.height, this.cacheRect.height));
            } else if (e.getSource() == BasicInternalFrameUI.this.titlePane) {
                Rectangle fBounds = BasicInternalFrameUI.this.frame.getBounds();
                dm.dragFrame(BasicInternalFrameUI.this.frame, e.getX() - this.xOffset + b.x, e.getY() - this.yOffset + b.y);
            }
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
            DesktopManager dm = BasicInternalFrameUI.this.getDesktopManager();
            int x = e.getX();
            int y = e.getY();
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                this.direction = this.sectionOfClick(x, y);
                dm.beginResizingFrame(BasicInternalFrameUI.this.frame, this.direction);
            } else if (e.getSource() == BasicInternalFrameUI.this.titlePane) {
                Rectangle tBounds = BasicInternalFrameUI.this.titlePane.getBounds();
                this.xOffset = e.getX() - tBounds.x + insets.left;
                this.yOffset = e.getY() - tBounds.y + insets.top;
                dm.beginDraggingFrame(BasicInternalFrameUI.this.frame);
            }
        }

        public void mouseReleased(MouseEvent e) {
            DesktopManager dm = BasicInternalFrameUI.this.getDesktopManager();
            this.xOffset = 0;
            this.yOffset = 0;
            if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                dm.endResizingFrame(BasicInternalFrameUI.this.frame);
            } else if (e.getSource() == BasicInternalFrameUI.this.titlePane) {
                dm.endDraggingFrame(BasicInternalFrameUI.this.frame);
            }
        }

        private final int sectionOfClick(int x, int y) {
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            Rectangle b = BasicInternalFrameUI.this.frame.getBounds();
            if (x < insets.left && y < insets.top) {
                return 8;
            }
            if (x > b.width - insets.right && y < insets.top) {
                return 2;
            }
            if (x > b.width - insets.right && y > b.height - insets.bottom) {
                return 4;
            }
            if (x < insets.left && y > b.height - insets.bottom) {
                return 6;
            }
            if (y < insets.top) {
                return 1;
            }
            if (x < insets.left) {
                return 7;
            }
            if (y > b.height - insets.bottom) {
                return 5;
            }
            if (x > b.width - insets.right) {
                return 3;
            }
            return -1;
        }

        private final /* synthetic */ void this() {
            this.xOffset = 0;
            this.yOffset = 0;
            this.direction = -1;
            this.cacheRect = new Rectangle();
        }

        protected BorderListener() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        public void internalFrameActivated(InternalFrameEvent e) {
        }

        public void internalFrameClosed(InternalFrameEvent e) {
        }

        public void internalFrameClosing(InternalFrameEvent e) {
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        public void internalFrameIconified(InternalFrameEvent e) {
        }

        public void internalFrameOpened(InternalFrameEvent e) {
        }

        protected BasicInternalFrameListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ComponentHandler
    implements ComponentListener {
        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            if (BasicInternalFrameUI.this.frame.isMaximum()) {
                JDesktopPane pane = (JDesktopPane)e.getSource();
                Insets insets = pane.getInsets();
                Rectangle bounds = pane.getBounds();
                BasicInternalFrameUI.this.frame.setBounds(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
                BasicInternalFrameUI.this.frame.revalidate();
                BasicInternalFrameUI.this.frame.repaint();
            }
        }

        public void componentShown(ComponentEvent e) {
        }

        protected ComponentHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private transient Component mouseEventTarget;
        private transient Component pressedComponent;
        private transient Component lastComponentEntered;
        private transient Component tempComponent;
        private transient int pressCount;

        public void mouseEntered(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
            this.handleEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e);
        }

        private final void acquireComponentForMouseEvent(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            Container parent = BasicInternalFrameUI.this.frame.getContentPane();
            if (parent == null) {
                return;
            }
            Component candidate = null;
            Point p = me.getPoint();
            while (candidate == null && parent != null) {
                candidate = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
                if (candidate != null) continue;
                p = SwingUtilities.convertPoint(parent, p.x, p.y, parent.getParent());
                parent = parent.getParent();
            }
            if (candidate == BasicInternalFrameUI.this.frame.getContentPane()) {
                candidate = null;
            }
            if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != candidate) {
                Point tp = SwingUtilities.convertPoint(BasicInternalFrameUI.this.frame.getContentPane(), x, y, this.lastComponentEntered);
                MouseEvent exited = new MouseEvent(this.lastComponentEntered, 505, me.getWhen(), me.getModifiersEx(), tp.x, tp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                this.tempComponent = this.lastComponentEntered;
                this.lastComponentEntered = null;
                this.tempComponent.dispatchEvent(exited);
            }
            if (candidate != null) {
                this.mouseEventTarget = candidate;
                if (candidate.isLightweight() && candidate.isShowing() && candidate != BasicInternalFrameUI.this.frame.getContentPane() && candidate != this.lastComponentEntered) {
                    this.lastComponentEntered = this.mouseEventTarget;
                    Point cp = SwingUtilities.convertPoint(BasicInternalFrameUI.this.frame.getContentPane(), x, y, this.lastComponentEntered);
                    MouseEvent entered = new MouseEvent(this.lastComponentEntered, 504, me.getWhen(), me.getModifiersEx(), cp.x, cp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                    this.lastComponentEntered.dispatchEvent(entered);
                }
            }
            if (me.getID() == 502 || me.getID() == 501 && this.pressCount > 0 || me.getID() == 506) {
                this.mouseEventTarget = this.pressedComponent;
            } else if (me.getID() == 500) {
                if (candidate != this.pressedComponent) {
                    this.mouseEventTarget = null;
                } else if (this.pressCount == 0) {
                    this.pressedComponent = null;
                }
            }
        }

        private final void handleEvent(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                this.acquireComponentForMouseEvent(me);
                if (this.mouseEventTarget == null) {
                    return;
                }
                if (this.mouseEventTarget.equals(BasicInternalFrameUI.this.frame.getGlassPane())) {
                    return;
                }
                if (this.mouseEventTarget.isShowing() && e.getID() != 504 && e.getID() != 505) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(BasicInternalFrameUI.this.frame.getGlassPane(), me, this.mouseEventTarget);
                    this.mouseEventTarget.dispatchEvent(newEvt);
                    switch (e.getID()) {
                        case 501: {
                            if (this.pressCount++ != 0) break;
                            this.pressedComponent = this.mouseEventTarget;
                            break;
                        }
                        case 502: {
                            if (--this.pressCount != 0 || this.mouseEventTarget == this.pressedComponent) break;
                            this.pressedComponent = null;
                            break;
                        }
                    }
                }
            }
        }

        protected GlassPaneDispatcher() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final int bSize = 5;
        private static final int offset = 10;

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            Color saved = g.getColor();
            Rectangle b = BasicInternalFrameUI.this.frame.getBounds();
            Color d = c.getBackground();
            g.setColor(d);
            g.fillRect(0, 0, 5, b.height);
            g.fillRect(0, 0, b.width, 5);
            g.fillRect(0, b.height - 5, b.width, 5);
            g.fillRect(b.width - 5, 0, 5, b.height);
            boolean x1 = false;
            int x2 = 5;
            int x3 = b.width - 5;
            int x4 = b.width;
            boolean y1 = false;
            int y2 = 5;
            int y3 = b.height - 5;
            int y4 = b.height;
            g.setColor(Color.GRAY);
            g.fillRect(0, 0, 5, y4);
            g.fillRect(0, 0, x4, 5);
            g.fillRect(0, y3, b.width, 5);
            g.fillRect(x3, 0, 5, b.height);
            g.fill3DRect(0, 10, 5, b.height - 20, false);
            g.fill3DRect(10, 0, b.width - 20, 5, false);
            g.fill3DRect(10, b.height - 5, b.width - 20, 5, false);
            g.fill3DRect(b.width - 5, 10, 5, b.height - 20, false);
            g.translate(-x, -y);
            g.setColor(saved);
        }

        private InternalFrameBorder() {
        }
    }
}

