/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.channels.FileChannelImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private FileChannelImpl ch;

    protected void finalize() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FileDescriptor getFD() throws IOException {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.fd == null) {
                this.fd = new FileDescriptor(this.ch);
            }
            return this.fd;
        }
    }

    public void write(int b) throws IOException {
        this.ch.write(b);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ch.write(buf, offset, len);
    }

    public void close() throws IOException {
        this.ch.close();
    }

    public synchronized FileChannel getChannel() {
        return this.ch;
    }

    public FileOutputStream(String path, boolean append) throws SecurityException, FileNotFoundException {
        this(new File(path), append);
    }

    public FileOutputStream(String path) throws SecurityException, FileNotFoundException {
        this(path, false);
    }

    public FileOutputStream(File file) throws SecurityException, FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(file.getPath());
        }
        this.ch = FileChannelImpl.create(file, append ? 6 : 2);
    }

    public FileOutputStream(FileDescriptor fdObj) throws SecurityException {
        if (!fdObj.valid()) {
            throw new SecurityException("Invalid FileDescriptor");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(fdObj);
        }
        this.fd = fdObj;
        this.ch = (FileChannelImpl)fdObj.channel;
    }

    FileOutputStream(FileChannelImpl ch) {
        this.ch = ch;
    }
}

