/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.ElementHandler;
import java.beans.ExceptionListener;
import org.xml.sax.Attributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
abstract class AbstractElementHandler
implements ElementHandler {
    private Context context;
    private ElementHandler parent;
    private boolean hasFailed;
    private StringBuffer buffer;
    private boolean allowsSubelements;

    public final void start(Attributes attributes, ExceptionListener exceptionListener) {
        try {
            this.context = this.startElement(attributes, exceptionListener);
        }
        catch (AssemblyException pe) {
            Throwable t = pe.getCause();
            if (!(t instanceof Exception)) {
                throw new InternalError("Unexpected Throwable type in AssemblerException. Please file a bug report.");
            }
            exceptionListener.exceptionThrown((Exception)t);
            this.notifyContextFailed();
            return;
        }
    }

    protected abstract Context startElement(Attributes var1, ExceptionListener var2) throws AssemblyException;

    public final void end(ExceptionListener exceptionListener) {
        if (!this.hasFailed) {
            try {
                this.endElement(this.buffer.toString());
                if (this.context.isStatement()) {
                    this.parent.notifyStatement(exceptionListener);
                    if (this.parent.hasFailed()) {
                        return;
                    }
                }
                this.putObject(this.context.getId(), this.context.endContext(this.parent.getContext()));
                if (!this.context.isStatement()) {
                    this.parent.getContext().addParameterObject(this.context.getResult());
                }
            }
            catch (AssemblyException pe) {
                Throwable t = pe.getCause();
                if (!(t instanceof Exception)) {
                    throw (InternalError)new InternalError("Severe problem while decoding XML data.").initCause(t);
                }
                exceptionListener.exceptionThrown((Exception)t);
                this.notifyContextFailed();
            }
        }
    }

    public void notifyStatement(ExceptionListener exceptionListener) {
        try {
            if (this.context.isStatement()) {
                this.parent.notifyStatement(exceptionListener);
            }
            this.context.notifyStatement(this.parent.getContext());
        }
        catch (AssemblyException ae) {
            Throwable t = ae.getCause();
            if (!(t instanceof Exception)) {
                throw (InternalError)new InternalError("Severe problem while decoding XML data.").initCause(t);
            }
            exceptionListener.exceptionThrown((Exception)t);
            this.notifyContextFailed();
        }
    }

    public final void notifyContextFailed() {
        this.hasFailed = true;
        if (this.parent.getContext().subContextFailed()) {
            this.parent.notifyContextFailed();
        }
    }

    public final boolean hasFailed() {
        return this.hasFailed;
    }

    protected void endElement(String characters) throws AssemblyException {
    }

    public final void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    public void putObject(String objectId, Object o) {
        if (objectId != null) {
            this.parent.putObject(objectId, o);
        }
    }

    public Object getObject(String objectId) throws AssemblyException {
        return objectId == null ? null : this.parent.getObject(objectId);
    }

    public Class instantiateClass(String className) throws ClassNotFoundException {
        return this.parent.instantiateClass(className);
    }

    public final boolean isSubelementAllowed(String subElementName) {
        boolean bl = false;
        if (this.allowsSubelements && !subElementName.equals("java")) {
            bl = true;
        }
        return bl;
    }

    public final Context getContext() {
        return this.context;
    }

    public final ElementHandler getParent() {
        return this.parent;
    }

    private final /* synthetic */ void this() {
        this.buffer = new StringBuffer();
    }

    protected AbstractElementHandler(ElementHandler parentHandler, boolean allowsSubs) {
        this.this();
        this.parent = parentHandler;
        this.allowsSubelements = allowsSubs;
    }
}

