/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    Class propertyType;
    Method getMethod;
    Method setMethod;
    Class propertyEditorClass;
    boolean bound;
    boolean constrained;

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.getMethod;
    }

    public void setReadMethod(Method readMethod) throws IntrospectionException {
        this.propertyType = this.checkMethods(readMethod, this.setMethod);
        this.getMethod = readMethod;
    }

    public Method getWriteMethod() {
        return this.setMethod;
    }

    public void setWriteMethod(Method writeMethod) throws IntrospectionException {
        this.propertyType = this.checkMethods(this.getMethod, writeMethod);
        this.setMethod = writeMethod;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setPropertyEditorClass(Class propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    private final void findMethods(Class beanClass, String getMethodName1, String getMethodName2, String setMethodName) throws IntrospectionException {
        block14: {
            try {
                if (getMethodName1 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName1, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (this.getMethod == null && getMethodName2 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName2, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (setMethodName == null) break block14;
                if (this.getMethod != null) {
                    Class propertyType = this.getMethod.getReturnType();
                    if (propertyType == Void.TYPE) {
                        String msg = "The property's read method has return type 'void'";
                        throw new IntrospectionException(msg);
                    }
                    Class[] setArgs = new Class[]{propertyType};
                    try {
                        this.setMethod = beanClass.getMethod(setMethodName, setArgs);
                    }
                    catch (NoSuchMethodException e) {}
                    break block14;
                }
                if (getMethodName1 != null || getMethodName2 != null) break block14;
                Method[] methods = beanClass.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(setMethodName) && methods[i].getParameterTypes().length == 1 && methods[i].getReturnType() == Void.TYPE) {
                        this.setMethod = methods[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (SecurityException e) {
                String msg = "SecurityException thrown on attempt to access methods.";
                throw new IntrospectionException(msg);
            }
        }
    }

    private final Class checkMethods(Method readMethod, Method writeMethod) throws IntrospectionException {
        Class newPropertyType = this.propertyType;
        if (readMethod != null) {
            if (readMethod.getParameterTypes().length > 0) {
                throw new IntrospectionException("read method has unexpected parameters");
            }
            newPropertyType = readMethod.getReturnType();
            if (newPropertyType == Void.TYPE) {
                throw new IntrospectionException("read method return type is void");
            }
        }
        if (writeMethod != null) {
            if (writeMethod.getParameterTypes().length != 1) {
                String msg = "write method does not have exactly one parameter";
                throw new IntrospectionException(msg);
            }
            if (readMethod == null) {
                newPropertyType = writeMethod.getParameterTypes()[0];
            } else if (newPropertyType != null && !newPropertyType.isAssignableFrom(writeMethod.getParameterTypes()[0])) {
                throw new IntrospectionException("read and write method are not compatible");
            }
        }
        return newPropertyType;
    }

    public int hashCode() {
        int n = 0;
        if (this.propertyType != null) {
            n = this.propertyType.hashCode();
        }
        int n2 = 0;
        if (this.propertyEditorClass != null) {
            n2 = this.propertyEditorClass.hashCode();
        }
        int n3 = n | n2 | (this.bound ? Boolean.TRUE : Boolean.FALSE).hashCode() | (this.constrained ? Boolean.TRUE : Boolean.FALSE).hashCode();
        int n4 = 0;
        if (this.getMethod != null) {
            n4 = this.getMethod.hashCode();
        }
        int n5 = n3 | n4;
        int n6 = 0;
        if (this.setMethod != null) {
            n6 = this.setMethod.hashCode();
        }
        return n5 | n6;
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyDescriptor) {
            boolean bl;
            boolean sameReadMethod;
            boolean bl2;
            boolean sameFlags;
            boolean bl3;
            boolean samePropertyType;
            boolean bl4;
            PropertyDescriptor that = (PropertyDescriptor)o;
            if (this.propertyType == null) {
                bl4 = false;
                if (that.propertyType == null) {
                    bl4 = true;
                }
            } else {
                bl4 = samePropertyType = this.propertyType.equals(that.propertyType);
            }
            if (this.propertyEditorClass == null) {
                bl3 = false;
                if (that.propertyEditorClass == null) {
                    bl3 = true;
                }
            } else {
                bl3 = this.propertyEditorClass.equals(that.propertyEditorClass);
            }
            boolean samePropertyEditorClass = bl3;
            boolean bl5 = false;
            if (this.bound == that.bound && this.constrained == that.constrained) {
                bl5 = sameFlags = true;
            }
            if (this.getMethod == null) {
                bl2 = false;
                if (that.getMethod == null) {
                    bl2 = true;
                }
            } else {
                bl2 = sameReadMethod = this.getMethod.equals(that.getMethod);
            }
            if (this.setMethod == null) {
                bl = false;
                if (that.setMethod == null) {
                    bl = true;
                }
            } else {
                bl = this.setMethod.equals(that.setMethod);
            }
            boolean sameWriteMethod = bl;
            boolean bl6 = false;
            if (samePropertyType && sameFlags && sameReadMethod && sameWriteMethod && samePropertyEditorClass) {
                bl6 = true;
            }
            return bl6;
        }
        return false;
    }

    PropertyDescriptor(String name) {
        this.setName(name);
    }

    public PropertyDescriptor(String name, Class beanClass) throws IntrospectionException {
        this.setName(name);
        if (name.length() == 0) {
            throw new IntrospectionException("empty property name");
        }
        String caps = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.findMethods(beanClass, "is" + caps, "get" + caps, "set" + caps);
        if (this.getMethod == null) {
            throw new IntrospectionException("Cannot find a is" + caps + " or get" + caps + " method");
        }
        if (this.setMethod == null) {
            throw new IntrospectionException("Cannot find a " + caps + " method");
        }
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public PropertyDescriptor(String name, Class beanClass, String getMethodName, String setMethodName) throws IntrospectionException {
        this.setName(name);
        this.findMethods(beanClass, getMethodName, null, setMethodName);
        if (this.getMethod == null && getMethodName != null) {
            throw new IntrospectionException("Cannot find a getter method called " + getMethodName);
        }
        if (this.setMethod == null && setMethodName != null) {
            throw new IntrospectionException("Cannot find a setter method called " + setMethodName);
        }
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public PropertyDescriptor(String name, Method readMethod, Method writeMethod) throws IntrospectionException {
        this.setName(name);
        this.getMethod = readMethod;
        this.setMethod = writeMethod;
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }
}

