'\"
'\" Generated from file 'rtcore\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "fileutil::magic::rt" n 2\&.0 tcllib "file utilities"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
fileutil::magic::rt \- Runtime core for file type recognition engines written in pure Tcl
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBfileutil::magic::rt ?2\&.0?\fR
.sp
\fB::fileutil::magic::rt::>\fR
.sp
\fB::fileutil::magic::rt::<\fR
.sp
\fB::fileutil::magic::rt::new\fR \fIchan\fR \fInamed\fR \fIanalyze\fR
.sp
\fB::fileutil::magic::rt::file_start\fR \fIname\fR
.sp
\fB::fileutil::magic::rt::emit\fR \fImsg\fR
.sp
\fB::fileutil::magic::rt::O\fR \fIwhere\fR
.sp
\fB::fileutil::magic::rt::R\fR \fIwhere\fR
.sp
\fB::fileutil::magic::rt::Nv\fR \fItype\fR \fIoffset\fR \fIcompinvert\fR \fIcomp\fR \fIexpected\fR
.sp
\fB::fileutil::magic::rt::N\fR \fItype\fR \fIoffset\fR \fItestinvert\fR \fIcompinvert\fR \fImod\fR \fImand\fR \fIcomp\fR \fIexpected\fR
.sp
\fB::fileutil::magic::rt::S\fR \fItype\fR \fIoffset\fR \fItestinvert\fR \fImod\fR \fImand\fR \fIcomp\fR \fIval\fR
.sp
\fB::fileutil::magic::rt::L\fR \fInewlevel\fR
.sp
\fB::fileutil::magic::rt::I\fR \fIoffset\fR \fIit\fR \fIioi\fR \fIioo\fR \fIiir\fR \fIio\fR
.sp
\fB::fileutil::magic::rt::R\fR \fIoffset\fR
.sp
\fB::fileutil::magic::rt::U\fR \fIfileindex\fR \fIname\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides the runtime core for file type recognition
engines written in pure Tcl and is thus used by all other packages in
this module such as \fBfileutil::magic::filetype\fR and the two compiler
packages \fBfileutil::magic::cgen\fR and
\fBfileutil::magic::cfront\fR\&.
.SH COMMANDS
.TP
\fB::fileutil::magic::rt::>\fR
Increment the level and perform related housekeeping
.TP
\fB::fileutil::magic::rt::<\fR
Decrement the level and perform related housekeeping
.TP
\fB::fileutil::magic::rt::new\fR \fIchan\fR \fInamed\fR \fIanalyze\fR
Create a new command which returns one description of the file each time it is
called, and a code of \fIbreak\fR when there are no more descriptions\&.
\fIchan\fR is the channel containing the data to describe\&.  The channel
configuration is then managed as needed\&.
\fInamed\fR is a dictionary of named tests, as generated by
\fBfileutil::magic::cfront::compile\fR\&.
\fItest\fR is a command prefix for a routine composed of the list of commands
as returned by \fBfileutil::magic::cfront::compile\fR\&.
.TP
\fB::fileutil::magic::rt::file_start\fR \fIname\fR
This command marks the start of a magic file when debugging\&. It
returns the empty string as its result\&.
.TP
\fB::fileutil::magic::rt::emit\fR \fImsg\fR
This command adds the text \fImsg\fR to the result buffer\&. The
message may contain the following special character sequences\&. They
will be replaced with buffered values before the message is added to
the result\&. The command returns the empty string as its result\&.
.RS
.TP
\fB\\b\fR
This sequence is removed
.TP
\fB%s\fR
Replaced with the last buffered string value\&.
.TP
\fB%ld\fR
Replaced with the last buffered numeric value\&.
.TP
\fB%d\fR
See above\&.
.TP
\fB${x:\&.\&.\&.?\&.\&.\&.}\fR
Substitute one string if the file is executable, and
another string otherwise\&.
.RE
.TP
\fB::fileutil::magic::rt::O\fR \fIwhere\fR
Produce an offset from \fIwhere\fR, relative to the cursor one level up\&.
Produce an offset from \fIwhere\fR, relative to the offset one level up\&.
.TP
\fB::fileutil::magic::rt::Nv\fR \fItype\fR \fIoffset\fR \fIcompinvert\fR \fIcomp\fR \fIexpected\fR
A limited form of \fB::fileutile::magic::rt::N\fR that only checks for
equality and can't be told to invert the test\&.
.TP
\fB::fileutil::magic::rt::N\fR \fItype\fR \fIoffset\fR \fItestinvert\fR \fIcompinvert\fR \fImod\fR \fImand\fR \fIcomp\fR \fIexpected\fR
Fetch the numeric value with \fItype\fR from the absolute location
\fIoffset\fR, compare it with \fIexpected\fR using \fIcomp\fR as the comparision
operator,  and returns the result\&.
.sp
The argument \fIcomp\fR must be one of Tcl's comparison
operators\&.
.CS


	<comp> <fetched-and-masked-value> <comp> <expected>

.CE
.sp
The special comparison operator \fBx\fR signals that no comparison
should be done, or, in other words, that the fetched value will always
match \fIval\fR\&.
.TP
\fB::fileutil::magic::rt::S\fR \fItype\fR \fIoffset\fR \fItestinvert\fR \fImod\fR \fImand\fR \fIcomp\fR \fIval\fR
Like \fB::fileutil::magic::rt::N\fR except that it fetches and compares string
types , not numeric data\&.
.TP
\fB::fileutil::magic::rt::L\fR \fInewlevel\fR
Sets the current level in the calling context to
\fInewlevel\fR\&. The command returns the empty string as its result\&.
.TP
\fB::fileutil::magic::rt::I\fR \fIoffset\fR \fIit\fR \fIioi\fR \fIioo\fR \fIiir\fR \fIio\fR
Calculates an offset based on an initial offset and the provided modifiers\&.
.TP
\fB::fileutil::magic::rt::R\fR \fIoffset\fR
Given an initial offset, calculates an offset relative to the cursor at the
next level up\&. The cursor is the position in the data one character after the
data extracted from the file one level up\&.
.sp
.TP
\fB::fileutil::magic::rt::U\fR \fIfileindex\fR \fIname\fR
Add a level and use a named test script\&.
.PP
.SH "NUMERIC TYPES"
.TP
\fBbyte\fR
8-bit integer
.TP
\fBshort\fR
16-bit integer, stored in native endianess
.TP
\fBbeshort\fR
see above, stored in big endian
.TP
\fBleshort\fR
see above, stored in small/little endian
.TP
\fBlong\fR
32-bit integer, stored in native endianess
.TP
\fBbelong\fR
see above, stored in big endian
.TP
\fBlelong\fR
see above, stored in small/little endian
.PP
All of the types above exit in an unsigned form as well\&. The type
names are the same, with the character "u" added as prefix\&.
.TP
\fBdate\fR
32-bit integer timestamp, stored in native endianess
.TP
\fBbedate\fR
see above, stored in big endian
.TP
\fBledate\fR
see above, stored in small/little endian
.TP
\fBldate\fR
32-bit integer timestamp, stored in native endianess
.TP
\fBbeldate\fR
see above, stored in big endian
.TP
\fBleldate\fR
see above, stored in small/little endian
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIfileutil :: magic\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
file(1), fileutil, magic(5)
.SH KEYWORDS
file recognition, file type, file utilities, mime, type
.SH CATEGORY
Programming tools
