# @title Upgrading
# Upgrading

Ramaze strives to be backwards compatible between each release. However, some
releases may contain changes that are *not* backwards compatible. This document
describes the steps required to upgrade between these releases.

## Upgrading to Ramaze 2012.12.08

Ramaze 2012.12.08 is **not** backwards compatible with previous releases due
to changes made in Innate 2012.12.

### Middleware

In previous versions one could add Rack middleware using `Ramaze.middleware!`.
This method has been renamed to `Ramaze.middleware` (without the `!`) and its
use has been changed. Instead of calling `run Ramaze.middleware` one now has to
use `run Ramaze.core`.

An example of the old way of defining middleware:

    Ramaze.middleware! :dev do |m|
      m.use Rack::Lint
      m.run Ramaze.middleware
    end

The new way of defining middleware:

    Ramaze.middleware :dev do
      use Rack::Lint
      run Ramaze.core
    end

### Commands

Various executable commands such as `ramaze start` and `ramaze console` have
been removed in favour of the use of Rake tasks. For existing projects that do
not have these Rake tasks you'll have to import them manually, new projects
will have these tasks automatically. These tasks are located [here][rake
tasks].

These commands were removed as they contained a lot of old and rotting code
without any tests. Some of them, such as `ramaze start` weren't very useful
either as most people will use the commands for their webservers (e.g. Thin)
instead. The use of Rake tasks also makes it possible for people to customize
these to their liking.

### Snippets

Ramaze ships with various snippets that extend various core Ruby classes. In
Ramaze 2012.12.08 a lot of these snippets have been removed. A list of all the
removed snippets can be found [here][removed snippets].

### Loggers

The following logging classes are no longer available:

* Ramaze::Logger::Growl
* Ramaze::Logger::Analogger
* Ramaze::Logger::Knotify
* Ramaze::Logger::Xosd

### Helpers

The following helpers have been removed:

* Ramaze::Helper::Disqus
* Ramaze::Helper::Ultraviolet

### Core classes

The following core classes have been removed:

* Ramaze::AppGraph
* Ramaze::Plugin
* Ramaze::MiddlewareCompiler (alias of Innate::MiddlewareCompiler)

### Prototypes

The prototype generated by `ramaze create` has been changed. It contains a set
of Rake tasks, a README, a Gemfile and some other small changes compared to the
previous prototype. Existing projects are not affected.

[rake tasks]: https://github.com/Ramaze/ramaze/blob/master/lib/proto/task/ramaze.rake
[removed snippets]: https://github.com/Ramaze/ramaze/commit/7e966dcdec50d490eb828f7673f101b1a6b087b3
