<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ChromeUXReport;

class QueryRequest extends \Google\Collection
{
  protected $collection_key = 'metrics';
  public $effectiveConnectionType;
  public $formFactor;
  public $metrics;
  public $origin;
  public $url;

  public function setEffectiveConnectionType($effectiveConnectionType)
  {
    $this->effectiveConnectionType = $effectiveConnectionType;
  }
  public function getEffectiveConnectionType()
  {
    return $this->effectiveConnectionType;
  }
  public function setFormFactor($formFactor)
  {
    $this->formFactor = $formFactor;
  }
  public function getFormFactor()
  {
    return $this->formFactor;
  }
  public function setMetrics($metrics)
  {
    $this->metrics = $metrics;
  }
  public function getMetrics()
  {
    return $this->metrics;
  }
  public function setOrigin($origin)
  {
    $this->origin = $origin;
  }
  public function getOrigin()
  {
    return $this->origin;
  }
  public function setUrl($url)
  {
    $this->url = $url;
  }
  public function getUrl()
  {
    return $this->url;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(QueryRequest::class, 'Google_Service_ChromeUXReport_QueryRequest');
