/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{InfoBox}from"@typo3/install/renderable/info-box.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";import RegularEvent from"@typo3/core/event/regular-event.js";import SecurityUtility from"@typo3/core/security-utility.js";var Identifiers;!function(e){e.analyzeTrigger=".t3js-databaseAnalyzer-analyze",e.executeTrigger=".t3js-databaseAnalyzer-execute",e.outputContainer=".t3js-databaseAnalyzer-output",e.notificationContainer=".t3js-databaseAnalyzer-notification",e.suggestionBlock="#t3js-databaseAnalyzer-suggestion-block",e.suggestionBlockCheckbox=".t3js-databaseAnalyzer-suggestion-block-checkbox",e.suggestionBlockLegend=".t3js-databaseAnalyzer-suggestion-block-legend",e.suggestionBlockLabel=".t3js-databaseAnalyzer-suggestion-block-label",e.suggestionList=".t3js-databaseAnalyzer-suggestion-list",e.suggestionLineTemplate="#t3js-databaseAnalyzer-suggestion-line-template",e.suggestionLineCheckbox=".t3js-databaseAnalyzer-suggestion-line-checkbox",e.suggestionLineLabel=".t3js-databaseAnalyzer-suggestion-line-label",e.suggestionLineStatement=".t3js-databaseAnalyzer-suggestion-line-statement",e.suggestionLineCurrent=".t3js-databaseAnalyzer-suggestion-line-current",e.suggestionLineCurrentValue=".t3js-databaseAnalyzer-suggestion-line-current-value",e.suggestionLineCount=".t3js-databaseAnalyzer-suggestion-line-count",e.suggestionLineCountValue=".t3js-databaseAnalyzer-suggestion-line-count-value"}(Identifiers||(Identifiers={}));class DatabaseAnalyzer extends AbstractInteractableModule{initialize(e){super.initialize(e),this.loadModuleFrameAgnostic("@typo3/install/renderable/info-box.js").then((()=>{this.getData()})),new RegularEvent("click",((e,t)=>{t.closest("fieldset").querySelectorAll('input[type="checkbox"]').forEach((e=>{e.checked=t.checked}))})).delegateTo(e,Identifiers.suggestionBlockCheckbox),new RegularEvent("click",(e=>{e.preventDefault(),this.clearNotifications(),this.analyze()})).delegateTo(e,Identifiers.analyzeTrigger),new RegularEvent("click",(e=>{e.preventDefault(),this.clearNotifications(),this.execute()})).delegateTo(e,Identifiers.executeTrigger)}getData(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("databaseAnalyzer")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();!0===s.success?(e.innerHTML=s.html,Modal.setButtons(s.buttons),this.analyze()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)}))}analyze(){this.setModalButtonsState(!1);const e=this.getModalBody(),t=e.querySelector(Identifiers.outputContainer),s=this.renderProgressBar(t,{label:"Analyzing current database schema..."});new RegularEvent("change",(()=>{const e=t.querySelectorAll(":checked").length>0;this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.executeTrigger),e)})).delegateTo(t,'input[type="checkbox"]'),new AjaxRequest(Router.getUrl("databaseAnalyzerAnalyze")).get({cache:"no-cache"}).then((async a=>{const n=await a.resolve();!0===n.success?(Array.isArray(n.status)&&(s.remove(),n.status.forEach((e=>{t.append(InfoBox.create(e.severity,e.title,e.message))}))),Array.isArray(n.suggestions)&&(n.suggestions.forEach((s=>{const a=e.querySelector(Identifiers.suggestionBlock).content.cloneNode(!0),n=s.key;a.querySelector(Identifiers.suggestionBlockLegend).innerText=s.label,a.querySelector(Identifiers.suggestionBlockCheckbox).setAttribute("id","t3-install-"+n+"-checkbox"),s.enabled&&a.querySelector(Identifiers.suggestionBlockCheckbox).setAttribute("checked","checked"),a.querySelector(Identifiers.suggestionBlockLabel).setAttribute("for","t3-install-"+n+"-checkbox"),s.children.forEach((t=>{const n=e.querySelector(Identifiers.suggestionLineTemplate).content.cloneNode(!0),i=t.hash,r=n.querySelector(Identifiers.suggestionLineCheckbox);r.setAttribute("id","t3-install-db-"+i),r.setAttribute("data-hash",i),s.enabled&&r.setAttribute("checked","checked"),n.querySelector(Identifiers.suggestionLineLabel).setAttribute("for","t3-install-db-"+i),n.querySelector(Identifiers.suggestionLineStatement).innerText=t.statement,void 0!==t.current&&(n.querySelector(Identifiers.suggestionLineCurrentValue).innerText=t.current,n.querySelector(Identifiers.suggestionLineCurrent).style.display="inline"),void 0!==t.rowCount&&(n.querySelector(Identifiers.suggestionLineCountValue).innerText=t.rowCount,n.querySelector(Identifiers.suggestionLineCount).style.display="inline"),a.querySelector(Identifiers.suggestionList).append(n)})),t.append(a)})),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.analyzeTrigger),!0),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.executeTrigger),t.querySelectorAll(":checked").length>0)),0===n.suggestions.length&&0===n.status.length&&t.append(InfoBox.create(Severity.ok,"Database schema is up to date. Good job!"))):(Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log."),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.analyzeTrigger),!0),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.executeTrigger),!1))}),(t=>{Router.handleAjaxError(t,e),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.analyzeTrigger),!0),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.executeTrigger),!1)}))}execute(){this.setModalButtonsState(!1);const e=this.getModalBody(),t=this.getModuleContent().dataset.databaseAnalyzerExecuteToken,s=e.querySelector(Identifiers.outputContainer),a=e.querySelector(Identifiers.notificationContainer),n=[];s.querySelectorAll(".t3js-databaseAnalyzer-suggestion-line input:checked").forEach((e=>{n.push(e.dataset.hash)})),this.renderProgressBar(s,{label:"Executing database updates..."}),new AjaxRequest(Router.getUrl()).post({install:{action:"databaseAnalyzerExecute",token:t,hashes:n}}).then((async e=>{const t=await e.resolve();if(Array.isArray(t.status)){let e="";t.status.forEach((t=>{if(t.severity===Severity.error){const s=new SecurityUtility;e+="<li>"+s.encodeHtml(t.message)+"</li>"}else Notification.showMessage(t.title,t.message,t.severity)})),""!==e&&(a.innerHTML=`<div class="alert alert-danger">\n                <div class="alert-inner">\n                  <div class="alert-icon">\n                      <span class="icon-emphasized">\n                          <typo3-backend-icon identifier="actions-close" size="small"></typo3-backend-icon>\n                      </span>\n                  </div>\n                  <div class="alert-content">\n                      <div class="alert-title">Database update failed</div>\n                      <div class="alert-message">\n                        <ul>${e}</ul>\n                      </div>\n                  </div>\n                </div>\n              </div>`)}this.analyze()}),(t=>{Router.handleAjaxError(t,e)})).finally((()=>{this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.analyzeTrigger),!0),this.setModalButtonState(this.getModalFooter().querySelector(Identifiers.executeTrigger),!1)}))}clearNotifications(){this.currentModal.querySelector(Identifiers.notificationContainer).replaceChildren("")}}export default new DatabaseAnalyzer;