/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{BroadcastMessage}from"@typo3/backend/broadcast-message.js";import BroadcastService from"@typo3/backend/broadcast-service.js";var Identifier;!function(e){e.colorSchemeSwitch="typo3-backend-color-scheme-switch"}(Identifier||(Identifier={}));class UserSettingsManager{constructor(){document.addEventListener("typo3:color-scheme:update",(e=>this.onColorSchemeUpdate(e.detail))),document.addEventListener("typo3:theme:update",(e=>this.onThemeUpdate(e.detail))),document.addEventListener("typo3:title-format:update",(e=>this.onTitleFormatUpdate(e.detail))),document.addEventListener("typo3:backend-language:update",(e=>this.onBackendLanguageFormatUpdate(e.detail))),document.addEventListener("typo3:color-scheme:broadcast",(e=>this.activateColorScheme(e.detail.payload.colorScheme))),document.addEventListener("typo3:theme:broadcast",(e=>this.activateTheme(e.detail.payload.theme))),document.addEventListener("typo3:title-format:broadcast",(e=>this.activateTitleFormat(e.detail.payload.format))),document.addEventListener("typo3:backend-language:broadcast",(e=>this.updateBackendLanguage(e.detail.payload.language,e.detail.payload.direction)))}onColorSchemeUpdate(e){const{colorScheme:t}=e;this.activateColorScheme(t),BroadcastService.post(new BroadcastMessage("color-scheme","broadcast",{colorScheme:t}))}onThemeUpdate(e){const{theme:t}=e;this.activateTheme(t),BroadcastService.post(new BroadcastMessage("theme","broadcast",{theme:t}))}onTitleFormatUpdate(e){const{format:t}=e;this.activateTitleFormat(t),BroadcastService.post(new BroadcastMessage("title-format","broadcast",{format:t}))}onBackendLanguageFormatUpdate(e){const{language:t,direction:a}=e;this.updateBackendLanguage(t,a),BroadcastService.post(new BroadcastMessage("language-update","broadcast",{language:t,direction:a}))}activateColorScheme(e){const t=document.querySelector(Identifier.colorSchemeSwitch);t&&(t.activeColorScheme=e),this.setStyleChangingDocumentAttribute("data-color-scheme",e)}activateTheme(e){this.setStyleChangingDocumentAttribute("data-theme",e)}activateTitleFormat(e){"sitenameFirst"===e?document.querySelector("typo3-backend-module-router")?.setAttribute("sitename-first",""):document.querySelector("typo3-backend-module-router")?.removeAttribute("sitename-first")}updateBackendLanguage(e,t){const a=document.documentElement,o=window.frames.list_frame?.document.documentElement;a.setAttribute("lang",e),o?.setAttribute("lang",e),null!==t?(a.setAttribute("dir",t),o?.setAttribute("dir",t)):(a.removeAttribute("dir"),o?.removeAttribute("dir"))}async setStyleChangingDocumentAttribute(e,t){const a=document.documentElement,o=window.frames.list_frame?.document.documentElement,i=()=>{a.classList.add("t3js-disable-transitions"),o?.classList.add("t3js-disable-transitions"),a.setAttribute(e,t),o?.setAttribute(e,t)},n=()=>{a.classList.remove("t3js-disable-transitions"),o?.classList.remove("t3js-disable-transitions")};if(window.matchMedia("(prefers-reduced-motion: reduce)").matches||!("startViewTransition"in document)||"function"!=typeof document.startViewTransition)return i(),await new Promise((e=>requestAnimationFrame(e))),o&&await new Promise((e=>window.frames.list_frame.requestAnimationFrame(e))),void n();await document.startViewTransition(i).finished,n()}}export default new UserSettingsManager;