/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.VRectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;

public class ZSegment
extends VRectangle {
    public ZSegment() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vw = 10L;
        this.vh = 10L;
        this.computeSize();
        this.ar = (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public ZSegment(long x, long y, int z, long w, long h, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.computeSize();
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public boolean visibleInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.vw <= eb && this.vx + this.vw >= wb && this.vy - this.vh <= nb && this.vy + this.vh >= sb;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Line2D.ptSegDist(this.pc[camIndex].cx, this.pc[camIndex].cy, this.pc[camIndex].cx + this.pc[camIndex].cw, this.pc[camIndex].cy + this.pc[camIndex].ch, jpx, jpy) <= (double)dpr;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        if ((float)(d.width / 2) + (float)(this.vx - c.posx - this.vw) * this.coef < 0.0f) {
            this.pc[i].cx = 0;
            this.pc[i].cw = Math.round((float)(d.width / 2) + (float)(this.vw + this.vx - c.posx) * this.coef);
            if (this.pc[i].cw < 0 || this.pc[i].cw > d.width - this.pc[i].cx) {
                this.pc[i].cw = d.width - this.pc[i].cx;
            }
        } else {
            this.pc[i].cx = Math.round((float)(d.width / 2) + (float)(this.vx - c.posx - this.vw) * this.coef);
            this.pc[i].cw = Math.round((float)(2L * this.vw) * this.coef);
            if (this.pc[i].cw < 0 || this.pc[i].cw > d.width - this.pc[i].cx) {
                this.pc[i].cw = d.width - this.pc[i].cx;
            }
        }
        if ((float)(d.height / 2) - (float)(this.vy - c.posy + this.vh) * this.coef < 0.0f) {
            this.pc[i].cy = 0;
            this.pc[i].ch = Math.round((float)(d.height / 2) - (float)(this.vy - c.posy - this.vh) * this.coef);
            if (this.pc[i].ch < 0 || this.pc[i].ch > d.height - this.pc[i].cy) {
                this.pc[i].ch = d.height - this.pc[i].cy;
            }
        } else {
            this.pc[i].cy = Math.round((float)(d.height / 2) - (float)(this.vy - c.posy + this.vh) * this.coef);
            this.pc[i].ch = Math.round((float)(2L * this.vh) * this.coef);
            if (this.pc[i].ch < 0 || this.pc[i].ch > d.height - this.pc[i].cy) {
                this.pc[i].ch = d.height - this.pc[i].cy;
            }
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        if ((float)(lensWidth / 2) + (float)(this.vx - lensx - this.vw) * this.coef < 0.0f) {
            this.pc[i].lcx = 0;
            this.pc[i].lcw = Math.round((float)(lensWidth / 2) + (float)(this.vw + this.vx - lensx) * this.coef);
            if (this.pc[i].lcw < 0 || this.pc[i].lcw > lensWidth - this.pc[i].lcx) {
                this.pc[i].lcw = lensWidth - this.pc[i].lcx;
            }
        } else {
            this.pc[i].lcx = Math.round((float)(lensWidth / 2) + (float)(this.vx - lensx - this.vw) * this.coef);
            this.pc[i].lcw = Math.round((float)(2L * this.vw) * this.coef);
            if (this.pc[i].lcw < 0 || this.pc[i].lcw > lensWidth - this.pc[i].lcx) {
                this.pc[i].lcw = lensWidth - this.pc[i].lcx;
            }
        }
        if ((float)(lensHeight / 2) - (float)(this.vy - lensy + this.vh) * this.coef < 0.0f) {
            this.pc[i].lcy = 0;
            this.pc[i].lch = Math.round((float)(lensHeight / 2) - (float)(this.vy - lensy - this.vh) * this.coef);
            if (this.pc[i].lch < 0 || this.pc[i].lch > lensHeight - this.pc[i].lcy) {
                this.pc[i].lch = lensHeight - this.pc[i].lcy;
            }
        } else {
            this.pc[i].lcy = Math.round((float)(lensHeight / 2) - (float)(this.vy - lensy + this.vh) * this.coef);
            this.pc[i].lch = Math.round((float)(2L * this.vh) * this.coef);
            if (this.pc[i].lch < 0 || this.pc[i].lch > lensHeight - this.pc[i].lcy) {
                this.pc[i].lch = lensHeight - this.pc[i].lcy;
            }
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            g.setColor(this.color);
            g.drawRect(dx + this.pc[i].cx, dy + this.pc[i].cy, this.pc[i].cw, this.pc[i].ch);
        } else if (this.pc[i].cw <= 1 ^ this.pc[i].ch <= 1) {
            g.setColor(this.color);
            if (this.pc[i].cw <= 1) {
                g.drawRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 0, this.pc[i].ch);
            } else if (this.pc[i].ch <= 1) {
                g.drawRect(dx + this.pc[i].cx, dy + this.pc[i].cy, this.pc[i].cw, 0);
            }
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].lch > 1) {
            g.setColor(this.color);
            g.drawRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, this.pc[i].lcw, this.pc[i].lch);
        } else if (this.pc[i].lcw <= 1 ^ this.pc[i].lch <= 1) {
            g.setColor(this.color);
            if (this.pc[i].lcw <= 1) {
                g.drawRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 0, this.pc[i].lch);
            } else if (this.pc[i].lch <= 1) {
                g.drawRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, this.pc[i].lcw, 0);
            }
        }
    }

    public Object clone() {
        ZSegment res = new ZSegment(this.vx, this.vy, 0, this.vw, this.vh, this.color);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

