/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.compile.AbstractOptions;
import org.gradle.api.tasks.compile.DebugOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ReplacedAccessor;
import org.gradle.internal.instrumentation.api.annotations.ReplacedDeprecation;
import org.gradle.internal.instrumentation.api.annotations.ReplacesEagerProperty;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.internal.CollectionUtils;

public abstract class CompileOptions
extends AbstractOptions {
    private static final long serialVersionUID = 0L;
    private boolean failOnError = true;
    private boolean verbose;
    private boolean listFiles;
    private boolean deprecation;
    private boolean warnings = true;
    private String encoding;
    private boolean debug = true;
    private DebugOptions debugOptions;
    private boolean fork;
    private ForkOptions forkOptions;
    private FileCollection bootstrapClasspath;
    private String extensionDirs;
    private List<String> compilerArgs = new ArrayList<String>();
    private final List<CommandLineArgumentProvider> compilerArgumentProviders = new ArrayList<CommandLineArgumentProvider>();
    private boolean incremental = true;
    private FileCollection sourcepath;
    private FileCollection annotationProcessorPath;
    private final Property<Boolean> incrementalAfterFailure;
    private final Property<String> javaModuleVersion;
    private final Property<String> javaModuleMainClass;
    private final Property<Integer> release;
    private final DirectoryProperty generatedSourceOutputDirectory;
    private final DirectoryProperty headerOutputDirectory;

    @Inject
    public CompileOptions(ObjectFactory objectFactory) {
        this.javaModuleVersion = objectFactory.property(String.class);
        this.javaModuleMainClass = objectFactory.property(String.class);
        this.generatedSourceOutputDirectory = objectFactory.directoryProperty();
        this.headerOutputDirectory = objectFactory.directoryProperty();
        this.release = objectFactory.property(Integer.class);
        this.incrementalAfterFailure = objectFactory.property(Boolean.class);
        this.forkOptions = (ForkOptions)objectFactory.newInstance(ForkOptions.class, new Object[0]);
        this.debugOptions = new DebugOptions();
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isWarnings() {
        return this.warnings;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Nested
    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(ForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    @Nullable
    @Optional
    @CompileClasspath
    @ToBeReplacedByLazyProperty
    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(@Nullable FileCollection bootstrapClasspath) {
        this.bootstrapClasspath = bootstrapClasspath;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getExtensionDirs() {
        return this.extensionDirs;
    }

    public void setExtensionDirs(@Nullable String extensionDirs) {
        this.extensionDirs = extensionDirs;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public List<String> getAllCompilerArgs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)CollectionUtils.stringize(this.getCompilerArgs()));
        for (CommandLineArgumentProvider compilerArgumentProvider : this.getCompilerArgumentProviders()) {
            builder.addAll(compilerArgumentProvider.asArguments());
        }
        return builder.build();
    }

    @Nested
    @ToBeReplacedByLazyProperty(comment="Should this be lazy?")
    public List<CommandLineArgumentProvider> getCompilerArgumentProviders() {
        return this.compilerArgumentProviders;
    }

    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public CompileOptions fork(Map<String, Object> forkArgs) {
        this.fork = true;
        this.forkOptions.define(forkArgs);
        return this;
    }

    public CompileOptions debug(Map<String, Object> debugArgs) {
        this.debug = true;
        this.debugOptions.define(debugArgs);
        return this;
    }

    public CompileOptions setIncremental(boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean isIncremental() {
        return this.incremental;
    }

    @Input
    @Optional
    @Incubating
    public Property<Boolean> getIncrementalAfterFailure() {
        return this.incrementalAfterFailure;
    }

    @Optional
    @Nullable
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @ToBeReplacedByLazyProperty
    public FileCollection getSourcepath() {
        return this.sourcepath;
    }

    public void setSourcepath(@Nullable FileCollection sourcepath) {
        this.sourcepath = sourcepath;
    }

    @Nullable
    @Optional
    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    public void setAnnotationProcessorPath(@Nullable FileCollection annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Input
    @Optional
    public Property<Integer> getRelease() {
        return this.release;
    }

    @Optional
    @Input
    public Property<String> getJavaModuleVersion() {
        return this.javaModuleVersion;
    }

    @Optional
    @Input
    public Property<String> getJavaModuleMainClass() {
        return this.javaModuleMainClass;
    }

    @Optional
    @OutputDirectory
    @ReplacesEagerProperty(replacedAccessors={@ReplacedAccessor(value=ReplacedAccessor.AccessorType.GETTER, name="getAnnotationProcessorGeneratedSourcesDirectory"), @ReplacedAccessor(value=ReplacedAccessor.AccessorType.SETTER, name="setAnnotationProcessorGeneratedSourcesDirectory")}, binaryCompatibility=ReplacesEagerProperty.BinaryCompatibility.ACCESSORS_KEPT, deprecation=@ReplacedDeprecation(removedIn=ReplacedDeprecation.RemovedIn.GRADLE9, withDslReference=true))
    public DirectoryProperty getGeneratedSourceOutputDirectory() {
        return this.generatedSourceOutputDirectory;
    }

    @Nullable
    @Deprecated
    @ReplacedBy(value="generatedSourceOutputDirectory")
    public File getAnnotationProcessorGeneratedSourcesDirectory() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(CompileOptions.class, (String)"annotationProcessorGeneratedSourcesDirectory").replaceWith((Object)"generatedSourceOutputDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        return (File)this.generatedSourceOutputDirectory.getAsFile().getOrNull();
    }

    @Deprecated
    public void setAnnotationProcessorGeneratedSourcesDirectory(@Nullable File file) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(CompileOptions.class, (String)"annotationProcessorGeneratedSourcesDirectory").replaceWith((Object)"generatedSourceOutputDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        this.generatedSourceOutputDirectory.set(file);
    }

    @Deprecated
    public void setAnnotationProcessorGeneratedSourcesDirectory(Provider<File> file) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(CompileOptions.class, (String)"annotationProcessorGeneratedSourcesDirectory").replaceWith((Object)"generatedSourceOutputDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        this.generatedSourceOutputDirectory.fileProvider(file);
    }

    @Optional
    @OutputDirectory
    public DirectoryProperty getHeaderOutputDirectory() {
        return this.headerOutputDirectory;
    }
}

