#!/usr/bin/python
#
# Update the file builds.dat in the HTML directory, which contains
# the full a list of build dates in RCS format.
#
# This is intended to facilitate mirroring of the build and test results.

from bracket import *
from utils import write_file, adjacent_pairs

def update_build_list():
    write_file(os.path.join(config['htmldir'], 'builds.dat'),
               "".join([str(ts2rcs(ts)) + "\n" for ts in existing_build_dates_at_commits()]))

use_current_repository()
update_build_list()
