#!/usr/bin/python
#
# Test the versions after and before each event in the hints file,
# newest hint first.
#
# Copyright (c) 2013, 2019 Andreas Gustafsson.  All rights reserved.
# Please refer to the file COPYRIGHT for detailed copyright information.
#

from __future__ import print_function

import os
from bracket import *

hints_newest_first = list(reversed(hints()))

use_repository_for(hints_newest_first[0])

done = set()

for ts in hints_newest_first:
    print("this is take-hints.py pid %d" % os.getpid())
    print("taking hint: ", ts, "=", ts2rcs(ts))
    try:
        hint_cno = ts2cno(ts)
        print("commit number", hint_cno)
    except NoCommitExactlyAtTimestamp:
        print("no commit at this timestamp, skipping")
        continue

    # Test the versions immediately after and before the event
    for cno_offset in (0, -1):
        c = hint_cno + cno_offset
        ts = cno2ts(c)
        print("  pid", os.getpid(), "cno", hint_cno, "offset", cno_offset, "->", "cno", c, "ts", ts, "=", ts2rcs(ts))
        if ts in done:
            print("    already done")
        else:
            print("    not yet done")
        done.add(ts)
        try:
           build_and_test(ts, test_in_background = True)
        except KeyboardInterrupt:
            raise
        except Exception as e:
            print(e)
        # see schedule.py for explanation
        sys.exc_clear()
