/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTreeModel
implements Serializable,
TreeModel {
    static final long serialVersionUID = -2621068368932566998L;
    protected TreeNode root;
    protected EventListenerList listenerList;
    protected boolean asksAllowsChildren;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    private final void writeObject(ObjectOutputStream obj) throws IOException {
    }

    private final void readObject(ObjectInputStream value0) throws IOException, ClassNotFoundException {
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setAsksAllowsChildren(boolean value) {
        this.asksAllowsChildren = value;
    }

    public void setRoot(TreeNode root) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int i = 0;
        while (i < this.getChildCount(parent)) {
            if (this.getChild(parent, i).equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getChild(Object node2, int idx) {
        if (node2 instanceof TreeNode) {
            return ((TreeNode)node2).getChildAt(idx);
        }
        return null;
    }

    public int getChildCount(Object node2) {
        if (node2 instanceof TreeNode) {
            return ((TreeNode)node2).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node2) {
        if (node2 instanceof TreeNode) {
            return ((TreeNode)node2).isLeaf();
        }
        return true;
    }

    public void reload() {
    }

    public void reload(TreeNode node2) {
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        Object node2 = path.getLastPathComponent();
        if (node2 instanceof MutableTreeNode) {
            ((MutableTreeNode)node2).setUserObject(newValue);
            int[] ci = null;
            Object[] c = null;
            Object[] parentPath = path.getPath();
            if (path.getPathCount() > 1) {
                TreeNode parent = ((TreeNode)node2).getParent();
                ci = new int[]{this.getIndexOfChild(parent, node2)};
                node2 = newValue;
                path = path.getParentPath().pathByAddingChild(node2);
                c = new Object[]{node2};
                parentPath = path.getParentPath().getPath();
            }
            this.fireTreeNodesChanged(this, parentPath, ci, c);
        }
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        newChild.setParent(parent);
        parent.insert(newChild, index);
        int[] childIndices = new int[]{index};
        this.nodesWereInserted(parent, childIndices);
    }

    public void removeNodeFromParent(MutableTreeNode node2) {
        TreeNode parent = node2.getParent();
        Object[] children = new Object[]{node2};
        int[] childIndices = new int[]{this.getIndexOfChild(parent, node2)};
        node2.removeFromParent();
        this.nodesWereRemoved(parent, childIndices, children);
    }

    public void nodeChanged(TreeNode node2) {
        TreeNode parent = node2.getParent();
        int[] childIndices = new int[]{this.getIndexOfChild(parent, node2)};
        Object[] children = new Object[]{node2};
        this.fireTreeNodesChanged(this, this.getPathToRoot(node2), childIndices, children);
    }

    public void nodesWereInserted(TreeNode parent, int[] childIndices) {
        Object[] children = new Object[childIndices.length];
        int i = 0;
        while (i < children.length) {
            children[i] = this.getChild(parent, childIndices[i]);
            ++i;
        }
        this.fireTreeNodesInserted(this, this.getPathToRoot(parent), childIndices, children);
    }

    public void nodesWereRemoved(TreeNode parent, int[] childIndices, Object[] removedChildren) {
        this.fireTreeNodesRemoved(this, this.getPathToRoot(parent), childIndices, removedChildren);
    }

    public void nodesChanged(TreeNode node2, int[] childIndices) {
        Object[] children = new Object[childIndices.length];
        int i = 0;
        while (i < children.length) {
            children[i] = this.getChild(node2, childIndices[i]);
            ++i;
        }
        this.fireTreeNodesChanged(this, this.getPathToRoot(node2), childIndices, children);
    }

    public void nodeStructureChanged(TreeNode node2) {
    }

    public TreeNode[] getPathToRoot(TreeNode node2) {
        return this.getPathToRoot(node2, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode node2, int depth) {
        if (node2 == null) {
            if (depth == 0) {
                return null;
            }
            return new TreeNode[depth];
        }
        TreeNode[] path = this.getPathToRoot(node2.getParent(), depth + 1);
        path[path.length - depth - 1] = node2;
        return path;
    }

    public void addTreeModelListener(TreeModelListener listener) {
        Class clazz = class$javax$swing$event$TreeModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeModelListener = DefaultTreeModel.class("[Ljavax.swing.event.TreeModelListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        Class clazz = class$javax$swing$event$TreeModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeModelListener = DefaultTreeModel.class("[Ljavax.swing.event.TreeModelListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        Class clazz = class$javax$swing$event$TreeModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeModelListener = DefaultTreeModel.class("[Ljavax.swing.event.TreeModelListener;", false);
        }
        return (TreeModelListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].treeNodesChanged(event);
            --i;
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].treeNodesInserted(event);
            --i;
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].treeNodesRemoved(event);
            --i;
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].treeStructureChanged(event);
            --i;
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.root = null;
        this.listenerList = new EventListenerList();
    }

    public DefaultTreeModel(TreeNode root) {
        this.this();
        if (root == null) {
            root = new DefaultMutableTreeNode();
        }
        this.setRoot(root);
    }

    public DefaultTreeModel(TreeNode root, boolean asksAllowsChildren) {
        this.this();
        this.setRoot(root);
        this.asksAllowsChildren = asksAllowsChildren;
    }
}

