/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqssl;

import java.awt.FlowLayout;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.wiztools.restclient.bean.KeyStoreType;

public class StoreTypePanel
extends JPanel {
    private final JRadioButton jrb_jks = new JRadioButton(KeyStoreType.JKS.name());
    private final JRadioButton jrb_pkcs12 = new JRadioButton(KeyStoreType.PKCS12.name());
    private final JRadioButton jrb_pem = new JRadioButton(KeyStoreType.PEM.name());

    public StoreTypePanel() {
        this.setLayout(new FlowLayout(0));
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.jrb_jks);
        grp.add(this.jrb_pkcs12);
        grp.add(this.jrb_pem);
        this.jrb_jks.setSelected(true);
        this.add(this.jrb_jks);
        this.add(this.jrb_pkcs12);
        this.add(this.jrb_pem);
    }

    public KeyStoreType getSelectedKeyStoreType() {
        if (this.jrb_jks.isSelected()) {
            return KeyStoreType.JKS;
        }
        if (this.jrb_pkcs12.isSelected()) {
            return KeyStoreType.PKCS12;
        }
        if (this.jrb_pem.isSelected()) {
            return KeyStoreType.PEM;
        }
        return KeyStoreType.PEM;
    }

    public void setSelectedKeyStoreType(KeyStoreType type) {
        switch (type) {
            case JKS: {
                this.jrb_jks.setSelected(true);
                break;
            }
            case PKCS12: {
                this.jrb_pkcs12.setSelected(true);
                break;
            }
            case PEM: {
                this.jrb_pem.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown keystore-type: " + (Object)((Object)type));
            }
        }
    }

    public void addItemListener(ItemListener listener, KeyStoreType ... types) {
        block5: for (KeyStoreType type : types) {
            switch (type) {
                case JKS: {
                    this.jrb_jks.addItemListener(listener);
                    continue block5;
                }
                case PKCS12: {
                    this.jrb_pkcs12.addItemListener(listener);
                    continue block5;
                }
                case PEM: {
                    this.jrb_pem.addItemListener(listener);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown keystore-type: " + (Object)((Object)type));
                }
            }
        }
    }
}

