/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.HeaderBoxUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.HeaderBox;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;

public class BasicHeaderBoxUI
extends HeaderBoxUI {
    private static HeaderBoxUI _headerBoxUI;
    protected ThemePainter _painter;

    public static ComponentUI createUI(JComponent c) {
        if (_headerBoxUI == null) {
            _headerBoxUI = new BasicHeaderBoxUI();
        }
        return _headerBoxUI;
    }

    public void installUI(JComponent c) {
        HeaderBox p = (HeaderBox)c;
        super.installUI(p);
        this.installDefaults(p);
        this.installListeners(p);
    }

    public void uninstallUI(JComponent c) {
        HeaderBox p = (HeaderBox)c;
        this.uninstallDefaults(p);
        this.uninstallListeners(p);
        super.uninstallUI(c);
    }

    protected void installListeners(JComponent c) {
        RolloverMouseInputAdapter l = this.createHeaderBoxMouseListener();
        c.addMouseListener(l);
    }

    private RolloverMouseInputAdapter getMouseListener(HeaderBox b) {
        MouseMotionListener[] listeners = b.getMouseMotionListeners();
        if (listeners != null) {
            for (MouseMotionListener listener : listeners) {
                if (!(listener instanceof RolloverMouseInputAdapter)) continue;
                return (RolloverMouseInputAdapter)listener;
            }
        }
        return null;
    }

    private RolloverMouseInputAdapter createHeaderBoxMouseListener() {
        return new RolloverMouseInputAdapter();
    }

    protected void uninstallListeners(JComponent c) {
        HeaderBox b = (HeaderBox)c;
        RolloverMouseInputAdapter listener = this.getMouseListener(b);
        if (listener != null) {
            b.removeMouseListener(listener);
        }
    }

    protected void installDefaults(HeaderBox p) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColorsAndFont(p, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(p, "Panel.border");
    }

    public void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
        this.paintBackground(g2, c);
        this.paintBorder(g2, c);
    }

    protected void paintBorder(Graphics g2, JComponent c) {
    }

    protected void paintBackground(Graphics g2, JComponent c) {
        HeaderBox headerBox = (HeaderBox)c;
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        if (headerBox.getModel().isPressed()) {
            this._painter.paintHeaderBoxBackground(c, g2, rect, 0, 1);
        } else if (headerBox.getModel().isSelected()) {
            this._painter.paintHeaderBoxBackground(c, g2, rect, 0, 3);
        } else if (headerBox.getModel().isRollover()) {
            this._painter.paintHeaderBoxBackground(c, g2, rect, 0, 2);
        } else {
            this._painter.paintHeaderBoxBackground(c, g2, rect, 0, 0);
        }
    }

    protected void uninstallDefaults(HeaderBox p) {
        LookAndFeel.uninstallBorder(p);
        this._painter = null;
    }

    protected class RolloverMouseInputAdapter
    extends MouseInputAdapter {
        private long lastPressedTimestamp = -1L;
        private boolean shouldDiscardRelease = false;

        protected RolloverMouseInputAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            AbstractButton b;
            if (SwingUtilities.isLeftMouseButton(e) && (b = (AbstractButton)e.getSource()).contains(e.getX(), e.getY())) {
                long multiClickThreshold = b.getMultiClickThreshhold();
                long lastTime = this.lastPressedTimestamp;
                long currentTime = this.lastPressedTimestamp = e.getWhen();
                if (lastTime != -1L && currentTime - lastTime < multiClickThreshold) {
                    this.shouldDiscardRelease = true;
                    return;
                }
                ButtonModel model = b.getModel();
                if (!model.isEnabled()) {
                    return;
                }
                if (!model.isArmed()) {
                    model.setArmed(true);
                }
                model.setPressed(true);
                if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                    b.requestFocus();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                    return;
                }
                AbstractButton b = (AbstractButton)e.getSource();
                ButtonModel model = b.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(e)) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }
    }
}

