/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{html}from"lit";import{unsafeHTML}from"lit/directives/unsafe-html.js";import{styleMap}from"lit/directives/style-map.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import RegularEvent from"@typo3/core/event/regular-event.js";import FormEngineValidation from"@typo3/backend/form-engine-validation.js";import Cropper from"cropperjs";import{default as Modal}from"@typo3/backend/modal.js";import"@typo3/backend/element/spinner-element.js";import{renderNodes}from"@typo3/core/lit-helper.js";import{Offset}from"@typo3/backend/element/draggable-resizable-element.js";class ImageManipulation{constructor(){this.initialized=!1,this.triggerListener=null,this.cropImageSelector="#t3js-crop-image",this.coverAreaSelector=".t3js-cropper-cover-area",this.cropInfoSelector=".t3js-cropper-info-crop",this.focusAreaSelector="#t3js-cropper-focus-area",this.defaultFocusArea={height:1/3,width:1/3,x:0,y:0},this.defaultOpts={autoCrop:!0,autoCropArea:.7,dragMode:"crop",guides:!0,responsive:!0,viewMode:1,zoomable:!1,checkCrossOrigin:!1},this.cropBuiltHandler=()=>{this.initialized=!0;const t=this.cropper.getImageData(),e=this.currentModal.querySelector(this.cropImageSelector);this.currentModal.querySelector(".cropper-canvas img")?.classList.remove("cropper-hide"),this.imageOriginalSizeFactor=parseInt(e.dataset.originalWidth,10)/t.naturalWidth,this.cropVariantTriggers.forEach((e=>{const r=e.dataset.cropVariantId,a=this.convertRelativeToAbsoluteCropArea(this.data[r].cropArea,t),i=Object.assign({},this.data[r],{cropArea:a});this.updatePreviewThumbnail(i,e),this.currentModal.querySelector(`[data-crop-variant-container="${i.id}"]`)?.querySelector(`[data-bs-option="${i.selectedRatio}"]`)?.classList.add("active")})),this.currentCropVariant.cropArea=this.convertRelativeToAbsoluteCropArea(this.currentCropVariant.cropArea,t),this.cropBox=this.currentModal.querySelector(".cropper-crop-box"),this.setCropArea(this.currentCropVariant.cropArea),this.currentCropVariant.coverAreas&&this.initCoverAreas(this.cropBox,this.currentCropVariant.coverAreas),this.currentCropVariant.focusArea&&(ImageManipulation.isEmptyObject(this.currentCropVariant.focusArea)&&(this.currentCropVariant.focusArea=Object.assign({},this.defaultFocusArea)),this.focusAreaEl?.remove(),this.initFocusArea(this.cropBox)),this.currentCropVariant.selectedRatio&&this.currentModal.querySelector(`[data-bs-option='${this.currentCropVariant.selectedRatio}']`)?.classList.add("active")},this.cropMoveHandler=t=>{if(!this.initialized)return;let e=Math.floor(t.detail.width),r=Math.floor(t.detail.height);(e<15||r<15)&&(e=Math.max(15,r),r=Math.max(15,e),this.cropper.setData({width:e,height:r})),this.currentCropVariant.cropArea=Object.assign({},this.currentCropVariant.cropArea,{width:Math.floor(e),height:Math.floor(r),x:Math.floor(t.detail.x),y:Math.floor(t.detail.y)}),this.focusAreaEl&&this.currentCropVariant?.focusArea&&(this.focusAreaEl.offset=this.convertAreaToOffset(this.currentCropVariant.focusArea,this.cropBox)),this.updatePreviewThumbnail(this.currentCropVariant,this.activeCropVariantTrigger),this.updateCropVariantData(this.currentCropVariant);const a=Math.round(this.currentCropVariant.cropArea.width*this.imageOriginalSizeFactor),i=Math.round(this.currentCropVariant.cropArea.height*this.imageOriginalSizeFactor);this.cropInfo.innerText=`${a}×${i} px`}}static wait(t,e){window.setTimeout(t,e)}static toCssPercent(t){return 100*t+"%"}static serializeCropVariants(t){return JSON.stringify(t,((t,e)=>"id"===t||"title"===t||"allowedAspectRatios"===t||"coverAreas"===t?void 0:e))}static isEmptyObject(t){return!t||"object"!=typeof t||0===Object.keys(t).length||"{}"===JSON.stringify(t)}static resolvePointerEventNames(){const t="undefined"!=typeof window&&void 0!==window.document,e=!(!t||!window.document.documentElement)&&"ontouchstart"in window.document.documentElement,r=!!t&&"PointerEvent"in window,a=e?["touchmove"]:["mousemove"],i=e?["touchstart"]:["mousedown"],o=e?["touchend","touchcancel"]:["mouseup"];return{touchStart:i,touchMove:a,touchEnd:o,pointerDown:r?["pointerdown"]:i,pointerMove:r?["pointermove"]:a,pointerUp:r?["pointerup","pointercancel"]:o}}initializeTrigger(){this.triggerListener||(this.triggerListener=new RegularEvent("click",((t,e)=>{t.preventDefault(),this.trigger=e,this.show()})),this.triggerListener.delegateTo(document,".t3js-image-manipulation-trigger"))}async initializeCropperModal(){const t=this.currentModal.querySelector(this.cropImageSelector);await new Promise((e=>{t.complete?e():t.addEventListener("load",(()=>e()))})),this.init()}show(){const t=this.trigger.dataset,e=t.modalTitle,r=t.buttonPreviewText,a=t.buttonDismissText,i=t.buttonSaveText,o=t.url,s=JSON.parse(t.payload);this.currentModal=Modal.advanced({additionalCssClasses:["modal-image-manipulation","cropper"],buttons:[{btnClass:"btn-default float-start",name:"preview",icon:"actions-view",text:r},{btnClass:"btn-default",name:"dismiss",icon:"actions-close",text:a},{btnClass:"btn-primary",name:"save",icon:"actions-document-save",text:i}],content:html`<div class="modal-loading"><typo3-backend-spinner size="large"></typo3-backend-spinner></div>`,size:Modal.sizes.full,style:Modal.styles.dark,title:e,staticBackdrop:!0}),this.currentModal.addEventListener("typo3-modal-shown",(()=>{new AjaxRequest(o).post(s).then((async t=>{const e=await t.resolve();this.currentModal.templateResultContent=html`${unsafeHTML(e)}`,this.currentModal.updateComplete.then((()=>this.initializeCropperModal()))}))})),this.currentModal.addEventListener("typo3-modal-hide",(()=>{this.destroy()}))}init(){const t=this.currentModal.querySelector(this.cropImageSelector),e=this.trigger.dataset.cropVariants;if(!e)throw new TypeError("ImageManipulation: No cropVariants data found for image");this.data=ImageManipulation.isEmptyObject(this.data)?JSON.parse(e):this.data,this.cropVariantTriggers=this.currentModal.querySelectorAll(".t3js-crop-variant-trigger"),this.activeCropVariantTrigger=this.currentModal.querySelector(".t3js-crop-variant-trigger.is-active"),this.cropInfo=this.currentModal.querySelector(this.cropInfoSelector),this.currentCropVariant=this.data[this.activeCropVariantTrigger.dataset.cropVariantId],this.cropVariantTriggers.forEach((t=>t.addEventListener("click",(t=>{if(t.currentTarget.classList.contains("is-active"))return t.stopPropagation(),void t.preventDefault();this.activeCropVariantTrigger.classList.remove("is-active"),t.currentTarget.classList.add("is-active"),this.activeCropVariantTrigger=t.currentTarget;const e=this.data[this.activeCropVariantTrigger.dataset.cropVariantId],r=this.cropper.getImageData();e.cropArea=this.convertRelativeToAbsoluteCropArea(e.cropArea,r),this.currentCropVariant=Object.assign({},e),this.update(e)})))),new RegularEvent("click",((t,e)=>{const r=e.dataset.bsOption;this.handleAspectRatioChange(r)})).delegateTo(this.currentModal,"label[data-method=setAspectRatio]"),new RegularEvent("keydown",((t,e)=>{if(!["Enter","Space"].includes(t.code))return;t.preventDefault(),t.stopImmediatePropagation();const r=e.closest('label[data-method="setAspectRatio"]'),a=r.dataset.bsOption;r.querySelector("input").checked=!0,this.handleAspectRatioChange(a)})).delegateTo(this.currentModal,'label[data-method="setAspectRatio"] input[type="radio"]'),new RegularEvent("click",(()=>this.save(this.data))).delegateTo(this.currentModal,"button[name=save]"),this.trigger.dataset.previewUrl?new RegularEvent("click",(()=>this.openPreview(this.data))).delegateTo(this.currentModal,"button[name=preview]"):this.currentModal.querySelectorAll("button[name=preview]").forEach((t=>t.style.display="none")),new RegularEvent("click",(()=>this.currentModal.hideModal())).delegateTo(this.currentModal,"button[name=dismiss]"),new RegularEvent("click",((t,e)=>{const r=this.cropper.getImageData(),a=e.dataset.cropVariant;if(t.preventDefault(),t.stopPropagation(),!a)throw new TypeError("TYPO3 Cropper: No cropVariant data attribute found on reset element.");const i=JSON.parse(a),o=this.convertRelativeToAbsoluteCropArea(i.cropArea,r);this.currentCropVariant=Object.assign({},i,{cropArea:o}),this.update(this.currentCropVariant)})).delegateTo(this.currentModal,"button[name=reset]"),ImageManipulation.isEmptyObject(this.currentCropVariant.cropArea)&&(this.defaultOpts=Object.assign({autoCropArea:1},this.defaultOpts)),this.cropper=new Cropper(t,Object.assign({},this.defaultOpts,{ready:()=>{this.cropBuiltHandler(),this.update(this.currentCropVariant)},crop:this.cropMoveHandler.bind(this),data:this.currentCropVariant.cropArea}))}handleAspectRatioChange(t){const e=Object.assign({},this.currentCropVariant),r=e.allowedAspectRatios[t];this.setAspectRatio(r),this.setCropArea(e.cropArea),this.currentCropVariant=Object.assign({},e,{selectedRatio:t}),this.update(this.currentCropVariant)}update(t){const e=Object.assign({},t),r=t.allowedAspectRatios[t.selectedRatio];this.cropInfo=this.currentModal.querySelector(`[data-crop-variant-container="${t.id}"]`)?.querySelector(this.cropInfoSelector),this.currentModal.querySelector(`[data-crop-variant-container="${t.id}"]`)?.querySelector("[data-bs-option].active")?.classList.remove("active"),this.currentModal.querySelector(`[data-crop-variant-container="${t.id}"]`)?.querySelector(`[data-bs-option="${t.selectedRatio}"]`)?.classList.add("active"),this.setAspectRatio(r),this.setCropArea(e.cropArea),this.currentCropVariant=Object.assign({},e,t),this.cropBox?.querySelectorAll(this.coverAreaSelector)?.forEach((t=>t.remove())),this.cropBox?.querySelectorAll(this.focusAreaSelector)?.length>0&&this.focusAreaEl.remove(),t.focusArea&&(ImageManipulation.isEmptyObject(t.focusArea)&&(this.currentCropVariant.focusArea=Object.assign({},this.defaultFocusArea)),this.focusAreaEl?.remove(),this.initFocusArea(this.cropBox)),t.coverAreas&&this.initCoverAreas(this.cropBox,this.currentCropVariant.coverAreas),this.updatePreviewThumbnail(this.currentCropVariant,this.activeCropVariantTrigger)}initFocusArea(t){this.focusAreaEl=document.createElement("typo3-backend-draggable-resizable"),this.focusAreaEl.window=this.currentModal.ownerDocument.defaultView,this.focusAreaEl.offset=this.convertAreaToOffset(this.currentCropVariant.focusArea,t),this.focusAreaEl.container=t,this.focusAreaEl.pointerEventNames=ImageManipulation.resolvePointerEventNames(),this.focusAreaEl.addEventListener("draggable-resizable-started",(()=>{this.cropper.disable()})),this.focusAreaEl.addEventListener("draggable-resizable-updated",(()=>{const e=this.currentCropVariant.coverAreas,r=this.convertOffsetToArea(this.focusAreaEl.offset,t),a=this.focusAreaEl.querySelector(this.focusAreaSelector);this.checkFocusAndCoverAreasCollision(r,e)?a.classList.add("has-nodrop"):a.classList.remove("has-nodrop")})),this.focusAreaEl.addEventListener("draggable-resizable-finished",(e=>{const r=this.currentCropVariant.coverAreas,a=this.convertOffsetToArea(this.focusAreaEl.offset,t);this.checkFocusAndCoverAreasCollision(a,r)?this.focusAreaEl.revert(e.detail.originOffset):this.scaleAndMoveFocusArea(a);this.focusAreaEl.querySelector(this.focusAreaSelector).classList.remove("has-nodrop"),this.cropper.enable()})),t.appendChild(this.focusAreaEl),this.scaleAndMoveFocusArea(this.currentCropVariant.focusArea)}initCoverAreas(t,e){e.forEach((e=>{const r={height:ImageManipulation.toCssPercent(e.height),left:ImageManipulation.toCssPercent(e.x),top:ImageManipulation.toCssPercent(e.y),width:ImageManipulation.toCssPercent(e.width)},a=html`
        <div class="cropper-cover-area t3js-cropper-cover-area" style=${styleMap(r)}></div>
      `;this.renderElements(a,t)}))}updatePreviewThumbnail(t,e){const r=e.querySelector(".t3js-cropper-preview-thumbnail-crop-area"),a=e.querySelector(".t3js-cropper-preview-thumbnail-crop-image"),i=e.querySelector(".t3js-cropper-preview-thumbnail-focus-area"),o=this.cropper.getImageData();Object.assign(r.style,{height:ImageManipulation.toCssPercent(t.cropArea.height/o.naturalHeight),left:ImageManipulation.toCssPercent(t.cropArea.x/o.naturalWidth),top:ImageManipulation.toCssPercent(t.cropArea.y/o.naturalHeight),width:ImageManipulation.toCssPercent(t.cropArea.width/o.naturalWidth)}),t.focusArea&&Object.assign(i.style,{height:ImageManipulation.toCssPercent(t.focusArea.height),left:ImageManipulation.toCssPercent(t.focusArea.x),top:ImageManipulation.toCssPercent(t.focusArea.y),width:ImageManipulation.toCssPercent(t.focusArea.width)});const s=getComputedStyle(r),n={width:s.getPropertyValue("width"),height:s.getPropertyValue("height"),left:s.getPropertyValue("left"),top:s.getPropertyValue("top")};Object.assign(a.style,{height:parseFloat(n.height)*(1/(t.cropArea.height/o.naturalHeight))+"px",margin:-1*parseFloat(n.left)+"px",marginTop:-1*parseFloat(n.top)+"px",width:parseFloat(n.width)*(1/(t.cropArea.width/o.naturalWidth))+"px"})}scaleAndMoveFocusArea(t){this.currentCropVariant.focusArea=t,this.updatePreviewThumbnail(this.currentCropVariant,this.activeCropVariantTrigger),this.updateCropVariantData(this.currentCropVariant)}updateCropVariantData(t){const e=this.cropper.getImageData(),r=this.convertAbsoluteToRelativeCropArea(t.cropArea,e);this.data[t.id]=Object.assign({},t,{cropArea:r})}setAspectRatio(t){this.cropper.setAspectRatio(t.value)}setCropArea(t){const e=this.currentCropVariant.allowedAspectRatios[this.currentCropVariant.selectedRatio];0===e.value?this.cropper.setData({height:t.height,width:t.width,x:t.x,y:t.y}):this.cropper.setData({height:t.height,width:t.height*e.value,x:t.x,y:t.y})}checkFocusAndCoverAreasCollision(t,e){return!!e&&e.some((e=>t.x<e.x+e.width&&e.x<t.x+t.width&&t.y<e.y+e.height&&e.y<t.height+t.y))}convertAbsoluteToRelativeCropArea(t,e){const{height:r,width:a,x:i,y:o}=t;return{height:r/e.naturalHeight,width:a/e.naturalWidth,x:i/e.naturalWidth,y:o/e.naturalHeight}}convertRelativeToAbsoluteCropArea(t,e){const{height:r,width:a,x:i,y:o}=t;return{height:r*e.naturalHeight,width:a*e.naturalWidth,x:i*e.naturalWidth,y:o*e.naturalHeight}}setPreviewImages(t){const e=this.cropper.image,r=this.cropper.getImageData();Object.keys(t).forEach((a=>{const i=t[a],o=this.convertRelativeToAbsoluteCropArea(i.cropArea,r),s=this.trigger.closest(".form-group").querySelector(`.t3js-image-manipulation-preview[data-crop-variant-id="${a}"]`),n=this.trigger.closest(".form-group").querySelector(`.t3js-image-manipulation-selected-ratio[data-crop-variant-id="${a}"]`);if(!(s instanceof HTMLElement))return;let c=s.getBoundingClientRect().width,l=parseInt(s.dataset.previewHeight,10);const h=o.width/o.height,p=c/h;p>l?c=l*h:l=p,c>o.width&&(c=o.width,l=o.height);const d=c/o.width,u={height:r.naturalHeight*d+"px",left:-o.x*d+"px",top:-o.y*d+"px",width:r.naturalWidth*d+"px"},g=html`
        <span class="thumbnail thumbnail-status">
          <div class="cropper-preview-container" style="${styleMap({width:`${c}px`,height:`${l}px`})}">
            <img src="${e.src}" style="${styleMap(u)}">
          </div>
        </span>
      `;for(;s.firstChild;)s.removeChild(s.firstChild);this.renderElements(g,s);const m=this.currentModal.ownerDocument.defaultView,v=this.currentModal.querySelector(`.t3-js-ratio-title[data-ratio-id="${i.id}${i.selectedRatio}"]`);n instanceof HTMLElement&&v instanceof m.HTMLElement&&(n.innerText=v.innerText)}))}openPreview(t){const e=ImageManipulation.serializeCropVariants(t);let r=this.trigger.dataset.previewUrl;r=r+(r.includes("?")?"&":"?")+"cropVariants="+encodeURIComponent(e),window.open(r,"TYPO3ImageManipulationPreview")}save(t){const e=ImageManipulation.serializeCropVariants(t),r=document.querySelector(`#${this.trigger.dataset.field}`);this.trigger.dataset.cropVariants=JSON.stringify(t),this.setPreviewImages(t),r.value=e,FormEngineValidation.markFieldAsChanged(r),this.currentModal.hideModal()}destroy(){this.currentModal&&(this.cropper instanceof Cropper&&this.cropper.destroy(),this.initialized=!1,this.cropper=null,this.currentModal=null,this.data=null)}convertAreaToOffset(t,e){const r=e.getBoundingClientRect();return new Offset(t.x*r.width,t.y*r.height,t.width*r.width,t.height*r.height)}convertOffsetToArea(t,e){const r=e.getBoundingClientRect();return{x:t.left/r.width,y:t.top/r.height,width:t.width/r.width,height:t.height/r.height}}renderElements(t,e,r){const a=renderNodes(t);return Array.from(a).filter((t=>t instanceof HTMLElement)).forEach((t=>e.appendChild(t))),r?e.querySelector(r):null}}export default new ImageManipulation;