/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import vcf.GTRec;
import vcf.Marker;
import vcf.Markers;
import vcf.Samples;

public class RestrictedVcfWindow
implements Closeable {
    private final SampleFileIt<? extends GTRec> it;
    private final List<GTRec> window;
    private Markers markers;
    private int overlap = 0;
    private int cumMarkerCnt;
    private GTRec next;

    public RestrictedVcfWindow(SampleFileIt<? extends GTRec> sampleFileIt) {
        if (!sampleFileIt.hasNext()) {
            throw new IllegalArgumentException("it.hasNext()==false");
        }
        this.it = sampleFileIt;
        this.window = new ArrayList<GTRec>();
        this.markers = null;
        this.overlap = 0;
        this.cumMarkerCnt = 0;
        this.next = (GTRec)sampleFileIt.next();
    }

    public GTRec[] advanceWindow(Markers markers) {
        this.checkMarkers(markers);
        this.advanceToCurrentChrom(markers);
        int n = RestrictedVcfWindow.overlap(this.markers, markers);
        ArrayList<GTRec> arrayList = new ArrayList<GTRec>(markers.size());
        arrayList.addAll(this.window.subList(this.window.size() - n, this.window.size()));
        this.overlap = RestrictedVcfWindow.countNonNull(arrayList);
        int n2 = markers.size();
        for (int i = n; i < n2; ++i) {
            Marker marker = markers.marker(i);
            if (this.next != null && this.next.marker().chromIndex() == marker.chromIndex()) {
                while (this.next != null && this.next.marker().chromIndex() == marker.chromIndex() && this.next.marker().pos() < marker.pos()) {
                    this.next = this.it.hasNext() ? (GTRec)this.it.next() : null;
                }
                while (this.next != null && this.next.marker().chromIndex() == marker.chromIndex() && this.next.marker().pos() == marker.pos() && !this.next.marker().equals(marker)) {
                    this.next = this.it.hasNext() ? (GTRec)this.it.next() : null;
                }
            }
            if (this.next != null && this.next.marker().equals(marker)) {
                ++this.cumMarkerCnt;
                arrayList.add(this.next);
                this.next = this.it.hasNext() ? (GTRec)this.it.next() : null;
                continue;
            }
            arrayList.add(null);
        }
        this.markers = markers;
        this.window.clear();
        this.window.addAll(arrayList);
        if (RestrictedVcfWindow.countNonNull(arrayList) == 0) {
            RestrictedVcfWindow.missingMarkersErr(markers);
        }
        return this.window.toArray(new GTRec[0]);
    }

    private void checkMarkers(Markers markers) {
        Object object;
        if (markers.size() == 0) {
            throw new IllegalArgumentException("markers do not advance window");
        }
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.size() - 1);
        if (this.markers != null && (object = this.markers.marker(this.markers.size() - 1)).chromIndex() == marker2.chromIndex() && object.pos() >= marker2.pos()) {
            String string = "markers do not advance window";
            throw new IllegalArgumentException(string);
        }
        if (marker.chromIndex() != marker2.chromIndex()) {
            object = "inconsistent chromosomes:" + Const.nl + marker + Const.nl + marker2;
            throw new IllegalArgumentException((String)object);
        }
    }

    private void advanceToCurrentChrom(Markers markers) {
        int n = markers.marker(0).chromIndex();
        while (this.next != null && this.next.marker().chromIndex() != n) {
            this.next = this.it.hasNext() ? (GTRec)this.it.next() : null;
        }
    }

    private static int overlap(Markers markers, Markers markers2) {
        int n;
        if (markers == null || markers.marker(0).chromIndex() != markers2.marker(0).chromIndex()) {
            return 0;
        }
        Marker marker = markers2.marker(0);
        int n2 = marker.pos();
        for (n = markers.size() - 1; n >= 0 && markers.marker(n).pos() > n2; --n) {
        }
        while (n >= 0 && !markers.marker(n).equals(marker)) {
            --n;
        }
        if (n < 0) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        int n3 = markers.size() - n;
        for (int i = 1; i < n3; ++i) {
            if (markers.marker(n + i).equals(markers2.marker(i))) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        return n3;
    }

    private static <E> int countNonNull(List<E> list) {
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (list.get(i) == null) continue;
            ++n;
        }
        return n;
    }

    private static void missingMarkersErr(Markers markers) {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(Const.nl);
        stringBuilder.append("ERROR: Reference and target files have no markers in common in interval: ");
        stringBuilder.append(Const.nl);
        stringBuilder.append("       ");
        stringBuilder.append(RestrictedVcfWindow.interval(markers));
        stringBuilder.append(Const.nl);
        stringBuilder.append(Const.nl);
        stringBuilder.append("Common markers must have identical CHROM, POS, REF, and ALT fields.");
        stringBuilder.append(Const.nl);
        stringBuilder.append("Exiting program.");
        stringBuilder.append(Const.nl);
        Utilities.exit(stringBuilder.toString());
    }

    private static String interval(Markers markers) {
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.size() - 1);
        assert (marker.chromIndex() == marker2.chromIndex());
        return marker.chrom() + ':' + marker.pos() + '-' + marker2.pos();
    }

    public File file() {
        return this.it.file();
    }

    public Samples samples() {
        return this.it.samples();
    }

    public int nSamples() {
        return this.it.samples().size();
    }

    public int overlap() {
        return this.overlap;
    }

    public int cumMarkerCnt() {
        return this.cumMarkerCnt;
    }

    @Override
    public void close() {
        this.it.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" - next:");
        stringBuilder.append(this.next);
        return stringBuilder.toString();
    }
}

