/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.vcf;

import htsjdk.samtools.FileTruncatedException;
import htsjdk.samtools.util.BlockCompressedInputStream;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.campagnelab.goby.modes.core.TabToColumnInfoModeCore;
import org.campagnelab.goby.readers.vcf.ColumnField;
import org.campagnelab.goby.readers.vcf.ColumnFields;
import org.campagnelab.goby.readers.vcf.ColumnInfo;
import org.campagnelab.goby.readers.vcf.ColumnType;
import org.campagnelab.goby.readers.vcf.Columns;
import org.campagnelab.goby.readers.vcf.GroupAssociations;

public class VCFParser
implements Closeable {
    private Reader input;
    private Columns columns = new Columns();
    private boolean hasNextDataLine;
    private int numberOfColumns;
    private int[] columnStarts;
    private int[] columnEnds;
    private MutableString line;
    private char columnSeparatorCharacter = (char)9;
    private int[] fieldStarts;
    private int[] fieldEnds;
    private char fieldSeparatorCharacter = (char)59;
    private char formatFieldSeparatorCharacter = (char)58;
    private int numberOfFields;
    private int globalFieldIndex;
    private int formatColumnIndex;
    private int lineLength;
    private int globalColumnIndex;
    private boolean TSV = true;
    private int[] fieldPermutation;
    public static final Comparator<ColumnInfo> COLUMN_SORT = new Comparator<ColumnInfo>(){

        @Override
        public int compare(ColumnInfo c1, ColumnInfo c2) {
            return c1.columnIndex - c2.columnIndex;
        }
    };
    public static final Comparator<ColumnField> FIELD_SORT = new Comparator<ColumnField>(){

        @Override
        public int compare(ColumnField c1, ColumnField c2) {
            return c1.globalFieldIndex - c2.globalFieldIndex;
        }
    };
    private final ObjectArrayList<ColumnInfo> columnList = new ObjectArrayList();
    private final ObjectArrayList<ColumnField> fieldList = new ObjectArrayList();
    private ColumnInfo formatColumn;
    private boolean headerLineNotParsed = true;
    private boolean headerParsed;
    private File inputFile;
    private Map<String, ColumnType> tsvColumnNameToTypeMap;
    private boolean cacheTsvColumnTypes = true;
    private int tsvLinesToScanForColumnType = -1;
    private boolean computedFieldPermutation;
    private boolean cacheFieldPermutation;
    private String associationString;
    private LineIterator lineIterator;
    private Int2ObjectMap<String> fieldIndexToName;
    private FastBufferedReader bufferedReader;
    final IntArrayList previousColumnFieldIndices = new IntArrayList();
    String[] formatSplit = null;
    private static final ColumnInfo[] fixedColumns = new ColumnInfo[]{new ColumnInfo("CHROM", true, new ColumnField("VALUE", 1, ColumnType.String, "The reference position, with the 1st base having position 1. Positions are sorted numerically, in increasing order, within each reference sequence CHROM.", "genomic-coordinate", "cross-sample-field")), new ColumnInfo("POS", true, new ColumnField("VALUE", 1, ColumnType.Integer, "he reference position, with the 1st base having position 1. Positions are sorted numerically, in increasing order, within each reference sequence CHROM.", "genomic-coordinate", "cross-sample-field")), new ColumnInfo("ID", true, new ColumnField("VALUE", 1, ColumnType.String, "ID semi-colon separated list of unique identifiers where available. If this is a dbSNP variant it is encouraged to use the rs number(s). No identifier should be present in more than one data record. If there is no identifier available, then the missing value should be used.", "external-identifiers", "cross-sample-field")), new ColumnInfo("REF", true, new ColumnField("VALUE", 1, ColumnType.String, "Reference base(s): Each base must be one of A,C,G,T,N. Bases should be in uppercase. Multiple bases are permitted. The value in the POS field refers to the position of the first base in the String. For InDels, the reference String must include the base before the event (which must be reflected in the POS field).", "cross-sample-field")), new ColumnInfo("ALT", true, new ColumnField("VALUE", 1, ColumnType.String, "Comma separated list of alternate non-reference alleles called on at least one of the samples. Options are base Strings made up of the bases A,C,G,T,N, or an angle-bracketed ID String (\"<ID>\"). If there are no alternative alleles, then the missing value should be used. Bases should be in uppercase. (Alphanumeric String; no whitespace, commas, or angle-brackets are permitted in the ID String itself).", "cross-sample-field")), new ColumnInfo("QUAL", true, new ColumnField("VALUE", 1, ColumnType.Float, "Phred-scaled quality score for the assertion made in ALT. i.e. give -10log_10 prob(call in ALT is wrong). If ALT is \".\" (no variant) then this is -10log_10 p(variant), and if ALT is not \".\" this is -10log_10 p(no variant). High QUAL scores indicate high confidence calls. Although traditionally people use integer phred scores, this field is permitted to be a floating point to enable higher resolution for low confidence calls if desired.", "cross-sample-field")), new ColumnInfo("FILTER", true, new ColumnField("VALUE", 1, ColumnType.String, "Filter: PASS if this position has passed all filters, i.e. a call is made at this position. Otherwise, if the site has not passed all filters, a semicolon-separated list of codes for filters that fail. e.g. \"10;s50\" might indicate that at this site the quality is below 10 and the number of samples with data is below 50%% of the total number of samples. \"0\" is reserved and should not be used as a filter String. If filters have not been applied, then this field should be set to the missing value.", "cross-sample-field")), new ColumnInfo("INFO", true, new ColumnField("VALUE", 1, ColumnType.String, "Additional information: INFO fields are encoded as a semicolon-separated series of short keys with optional values in the format: <key>=<data>[,data]. Arbitrary keys are permitted, although some sub-fields are reserved.", "cross-sample-field"))};

    public VCFParser(Reader file) {
        this.input = file;
    }

    public VCFParser(String filename) throws IOException {
        this.inputFile = new File(filename);
        this.input = filename.endsWith(".gz") ? new InputStreamReader((InputStream)new BlockCompressedInputStream((InputStream)new FileInputStream(filename))) : new FileReader(filename);
    }

    public void setCacheTsvColumnTypes(boolean cacheTsvColumnTypes) {
        this.cacheTsvColumnTypes = cacheTsvColumnTypes;
    }

    public boolean isCacheTsvColumnTypes() {
        return this.cacheTsvColumnTypes;
    }

    public void setTsvLinesToScanForColumnType(int tsvLinesToScanForColumnType) {
        this.tsvLinesToScanForColumnType = tsvLinesToScanForColumnType;
    }

    public int getTsvLinesToScanForColumnType() {
        return this.tsvLinesToScanForColumnType;
    }

    public void readTsvColumnTypes() throws IOException {
        if (this.tsvColumnNameToTypeMap == null && this.inputFile != null && this.inputFile.exists()) {
            TabToColumnInfoModeCore reader = new TabToColumnInfoModeCore();
            reader.addInputFile(this.inputFile);
            reader.setCreateCache(this.cacheTsvColumnTypes);
            reader.setNumberOfLinesToProcess(this.tsvLinesToScanForColumnType);
            reader.setReadFromCache(true);
            reader.execute();
            this.tsvColumnNameToTypeMap = reader.getDetailsAtIndex(0);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public Columns getColumns() {
        return this.columns;
    }

    public ColumnType getColumnType(int columnIndex) {
        ObjectIterator<ColumnInfo> objectIterator = this.columns.iterator();
        while (objectIterator.hasNext()) {
            ColumnInfo col = (ColumnInfo)objectIterator.next();
            if (col.columnIndex != columnIndex) continue;
            if (col.fields.size() != 1) break;
            return ((ColumnField)col.fields.toArray()[0]).type;
        }
        return ColumnType.String;
    }

    public ColumnType getFieldType(int globalFieldIndex) {
        return ((ColumnField)this.fieldList.get((int)globalFieldIndex)).type;
    }

    public int getFieldNumValues(int globalFieldIndex) {
        return ((ColumnField)this.fieldList.get((int)globalFieldIndex)).numberOfValues;
    }

    public String getColumnName(int columnIndex) {
        ObjectIterator<ColumnInfo> objectIterator = this.columns.iterator();
        while (objectIterator.hasNext()) {
            ColumnInfo col = (ColumnInfo)objectIterator.next();
            if (col.columnIndex != columnIndex) continue;
            return col.columnName;
        }
        return null;
    }

    public boolean hasNextDataLine() {
        if (this.hasNextDataLine) {
            return true;
        }
        this.hasNextDataLine = this.lineIterator.hasNext();
        if (this.hasNextDataLine) {
            this.line = this.lineIterator.next();
            if (!this.TSV) {
                this.parseCurrentLine();
            } else {
                this.parseTSVLine();
            }
        }
        return this.hasNextDataLine;
    }

    public void next() {
        if (!this.hasNextDataLine) {
            throw new IllegalArgumentException("Next can be called only after hasNext has returned true.");
        }
        this.hasNextDataLine = false;
    }

    public CharSequence getColumnValue(int columnIndex) {
        if (this.hasNextDataLine) {
            return this.line.subSequence(this.columnStarts[columnIndex], this.columnEnds[columnIndex]);
        }
        return null;
    }

    public int countAllFields() {
        int n = 0;
        ObjectIterator<ColumnInfo> objectIterator = this.columns.iterator();
        while (objectIterator.hasNext()) {
            ColumnInfo column = (ColumnInfo)objectIterator.next();
            n += column.fields.size();
        }
        return n;
    }

    public CharSequence getFieldValue(int globalFieldIndex) {
        if (this.hasNextDataLine) {
            int lineFieldIndex = this.fieldPermutation[globalFieldIndex];
            if (lineFieldIndex == -1) {
                return "";
            }
            int start = this.fieldStarts[lineFieldIndex];
            int end = this.fieldEnds[lineFieldIndex];
            assert (start >= 0 && end <= this.lineLength) : String.format("position indices must be within line boundaries start: %d end: %d length: %d", start, end, this.lineLength);
            return this.line.subSequence(start, end);
        }
        return null;
    }

    public String getStringFieldValue(int globalFieldIndex) {
        CharSequence value = this.getFieldValue(globalFieldIndex);
        return value == null ? null : value.toString();
    }

    public String getStringColumnValue(int columnIndex) {
        return this.getColumnValue(columnIndex).toString();
    }

    public String getFieldName(int globalFieldIndex) {
        return (String)this.fieldIndexToName.get(globalFieldIndex);
    }

    public void readHeader() throws SyntaxException {
        if (this.headerParsed) {
            return;
        }
        this.headerParsed = true;
        this.globalFieldIndex = 0;
        this.fieldIndexToName = new Int2ObjectOpenHashMap();
        this.bufferedReader = new FastBufferedReader(this.input);
        this.lineIterator = new LineIterator(this.bufferedReader);
        int lineNumber = 1;
        try {
            while (this.lineIterator.hasNext()) {
                this.line = this.lineIterator.next();
                if (this.hasVcfMetaLine()) {
                    this.TSV = false;
                }
                if (!this.line.startsWith("#")) {
                    if (this.TSV && lineNumber == 1 && this.headerLineNotParsed) {
                        this.parseHeaderLine(new MutableString("#" + this.line));
                    } else {
                        if (!this.TSV) {
                            this.parseCurrentLine();
                        } else {
                            this.parseTSVLine();
                        }
                        this.hasNextDataLine = true;
                    }
                    break;
                }
                if (this.hasVcfMetaLine()) {
                    this.TSV = false;
                    this.processMetaInfoLine(this.line);
                } else if (this.line.startsWith("#")) {
                    this.parseHeaderLine(this.line);
                }
                ++lineNumber;
            }
        }
        catch (FileTruncatedException e) {
            this.line = null;
            this.hasNextDataLine = false;
            this.lineIterator = new LineIterator(this.bufferedReader){

                public boolean hasNext() {
                    return false;
                }

                public MutableString next() {
                    return null;
                }
            };
        }
    }

    private boolean hasVcfMetaLine() {
        return this.line.startsWith("##") && this.line.indexOf('=') != -1;
    }

    private void parseTSVLine() {
        Arrays.fill(this.columnStarts, 0);
        Arrays.fill(this.columnEnds, 0);
        Arrays.fill(this.fieldStarts, 0);
        Arrays.fill(this.fieldEnds, 0);
        int columnIndex = 0;
        this.lineLength = this.line.length();
        for (int i = 0; i < this.lineLength; ++i) {
            char c = this.line.charAt(i);
            if (c != '\t') continue;
            String columnName = ((ColumnInfo)this.columnList.get((int)columnIndex)).columnName;
            this.columnEnds[columnIndex] = i;
            if (columnIndex + 1 < this.columnStarts.length) {
                this.columnStarts[columnIndex + 1] = i + 1;
            }
            this.fieldPermutation[columnIndex] = columnIndex;
            ++columnIndex;
        }
        this.fieldPermutation[this.columnEnds.length - 1] = this.columnEnds.length - 1;
        this.columnEnds[this.columnEnds.length - 1] = this.lineLength;
        this.columnStarts[this.columnEnds.length - 1] = this.columnEnds[this.columnEnds.length - 2] + 1;
        System.arraycopy(this.columnEnds, 0, this.fieldEnds, 0, this.columnEnds.length);
        System.arraycopy(this.columnStarts, 0, this.fieldStarts, 0, this.columnStarts.length);
    }

    private void parseCurrentLine() {
        Arrays.fill(this.columnStarts, 0);
        Arrays.fill(this.columnEnds, 0);
        Arrays.fill(this.fieldStarts, 0);
        Arrays.fill(this.fieldEnds, 0);
        this.columnStarts[0] = 0;
        int columnIndex = 0;
        int fieldIndex = 0;
        this.lineLength = this.line.length();
        int[] lineFieldIndexToColumnIndex = new int[this.numberOfFields];
        Arrays.fill(lineFieldIndexToColumnIndex, -1);
        this.previousColumnFieldIndices.clear();
        char[] chrs = this.line.toCharArray();
        for (int i = 0; i < this.lineLength; ++i) {
            char c = chrs[i];
            if (c == this.columnSeparatorCharacter) {
                this.fieldPermutation[columnIndex] = columnIndex;
                this.columnEnds[columnIndex] = i;
                if (columnIndex + 1 < this.numberOfColumns) {
                    this.columnStarts[columnIndex + 1] = i + 1;
                }
            }
            if (c == this.columnSeparatorCharacter || c == this.fieldSeparatorCharacter || columnIndex >= this.formatColumnIndex && c == this.formatFieldSeparatorCharacter) {
                if (this.TSV) {
                    this.fieldEnds[columnIndex] = this.columnEnds[columnIndex];
                    this.fieldStarts[columnIndex] = this.columnStarts[columnIndex];
                    fieldIndex = columnIndex;
                    lineFieldIndexToColumnIndex[fieldIndex] = columnIndex;
                } else {
                    this.fieldEnds[fieldIndex] = i;
                    if (fieldIndex + 1 < this.numberOfFields) {
                        this.fieldStarts[fieldIndex + 1] = i + 1;
                    }
                    this.previousColumnFieldIndices.add(fieldIndex);
                    ++fieldIndex;
                    fieldIndex = Math.min(this.fieldEnds.length - 1, fieldIndex);
                    fieldIndex = Math.min(this.fieldStarts.length - 1, fieldIndex);
                }
            }
            if (c != this.columnSeparatorCharacter) continue;
            if (this.TSV) {
                lineFieldIndexToColumnIndex[fieldIndex] = columnIndex;
            }
            this.push(columnIndex, lineFieldIndexToColumnIndex, this.previousColumnFieldIndices);
            ++columnIndex;
        }
        int numberOfFieldsOnLine = Math.min(fieldIndex, this.fieldEnds.length - 1);
        int numberOfColumnsOnLine = Math.min(columnIndex, this.columnEnds.length - 1);
        this.columnStarts[0] = 0;
        this.columnEnds[numberOfColumnsOnLine - (this.TSV ? 1 : 0)] = this.line.length();
        this.fieldStarts[0] = 0;
        this.fieldEnds[numberOfFieldsOnLine - (this.TSV ? 1 : 0)] = this.line.length();
        this.previousColumnFieldIndices.add(fieldIndex);
        this.push(columnIndex, lineFieldIndexToColumnIndex, this.previousColumnFieldIndices);
        if (this.cacheFieldPermutation && this.computedFieldPermutation) {
            return;
        }
        Arrays.fill(this.fieldPermutation, -1);
        ObjectIterator<ColumnInfo> objectIterator = this.columns.iterator();
        while (objectIterator.hasNext()) {
            ColumnInfo c = (ColumnInfo)objectIterator.next();
            c.formatIndex = 0;
        }
        block2: for (int lineFieldIndex = 0; lineFieldIndex <= numberOfFieldsOnLine; ++lineFieldIndex) {
            int start = this.fieldStarts[lineFieldIndex];
            int end = this.fieldEnds[lineFieldIndex];
            int cIndex = lineFieldIndexToColumnIndex[lineFieldIndex];
            if (cIndex >= this.columnList.size()) break;
            ColumnInfo column = (ColumnInfo)this.columnList.get(cIndex);
            int colMinGlobalFieldIndex = Integer.MAX_VALUE;
            int colMaxGlobalFieldIndex = Integer.MIN_VALUE;
            ColumnFields fields = column.fields;
            fields.rebuildList();
            for (int fi = 0; fi < fields.size(); ++fi) {
                ColumnField f = fields.get(fi);
                colMinGlobalFieldIndex = Math.min(colMinGlobalFieldIndex, f.globalFieldIndex);
                colMaxGlobalFieldIndex = Math.max(colMaxGlobalFieldIndex, f.globalFieldIndex);
            }
            int formatColumnIndex = this.TSV ? -1 : this.formatColumn.columnIndex;
            int startFormatColumn = this.TSV ? 0 : this.columnStarts[formatColumnIndex];
            int endFormatColumn = this.TSV ? 0 : this.columnEnds[formatColumnIndex];
            String[] formatTokens = this.split(this.line, this.formatFieldSeparatorCharacter, startFormatColumn, endFormatColumn);
            for (int fi = 0; fi < fields.size(); ++fi) {
                ColumnField f = fields.get(fi);
                if (this.fieldPermutation[f.globalFieldIndex] != -1) continue;
                if (colMaxGlobalFieldIndex == colMinGlobalFieldIndex) {
                    this.fieldPermutation[f.globalFieldIndex] = lineFieldIndex;
                    continue block2;
                }
                int j = start;
                String id = f.id;
                int matchLength = 0;
                for (int i = 0; i < id.length() && j < end; ++j, ++i) {
                    char linechar = this.line.charAt(j);
                    if (id.charAt(i) != linechar) {
                        matchLength = -1;
                        break;
                    }
                    ++matchLength;
                }
                if (matchLength == id.length() && this.line.charAt(j) == '=' || j == end && f.type == ColumnType.Flag) {
                    this.fieldPermutation[f.globalFieldIndex] = lineFieldIndex;
                    if (f.type == ColumnType.Flag) continue block2;
                    int n = lineFieldIndex;
                    this.fieldStarts[n] = this.fieldStarts[n] + (f.id.length() + 1);
                    continue block2;
                }
                if (!column.useFormat || column.formatIndex >= formatTokens.length || !f.id.equals(formatTokens[column.formatIndex])) continue;
                this.fieldPermutation[f.globalFieldIndex] = lineFieldIndex;
                ++column.formatIndex;
                continue block2;
            }
        }
        this.computedFieldPermutation = true;
    }

    private String[] split(MutableString line, char formatFieldSeparatorCharacter, int startFormatColumn, int endFormatColumn) {
        if (this.cacheFieldPermutation && this.formatSplit != null) {
            return this.formatSplit;
        }
        MutableString formatSpan = line.substring(startFormatColumn, endFormatColumn);
        int fieldCount = 0;
        formatSpan.append(formatFieldSeparatorCharacter);
        int length = formatSpan.length();
        for (int i = 0; i < length; ++i) {
            if (formatSpan.charAt(i) != formatFieldSeparatorCharacter) continue;
            ++fieldCount;
        }
        String[] result = new String[fieldCount];
        MutableString value = new MutableString();
        int last = 0;
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (formatSpan.charAt(i) != formatFieldSeparatorCharacter || i <= last) continue;
            value.append(formatSpan.substring(last, i));
            last = i + 1;
            result[j] = value.toString();
            value.setLength(0);
            ++j;
        }
        this.formatSplit = result;
        return result;
    }

    private void push(int columnIndex, int[] lineFieldIndexToColumnIndex, IntArrayList previousColumnFieldIndices) {
        int size = previousColumnFieldIndices.size();
        for (int i = 0; i < size; ++i) {
            int fIndex = previousColumnFieldIndices.getInt(i);
            lineFieldIndexToColumnIndex[fIndex] = columnIndex;
        }
        previousColumnFieldIndices.clear();
    }

    private void parseHeaderLine(MutableString line) {
        ObjectListIterator columnNames;
        if (this.TSV) {
            try {
                this.readTsvColumnTypes();
            }
            catch (IOException e) {
                System.err.println("Could not determine column info from tsv file " + e.getMessage());
            }
        }
        this.headerLineNotParsed = false;
        line = line.substring(1);
        for (String columnName : columnNames = line.toString().split("[\\t]")) {
            ColumnField[] fields;
            this.defineFixedColumn(columnName);
            if (this.columns.hasColumnName(columnName)) continue;
            ColumnInfo formatColumn = this.columns.find("FORMAT");
            if (formatColumn != null) {
                fields = new ColumnField[formatColumn.fields.size()];
                int i = 0;
                ObjectIterator<ColumnField> objectIterator = formatColumn.fields.iterator();
                while (objectIterator.hasNext()) {
                    ColumnField field = (ColumnField)objectIterator.next();
                    fields[i] = new ColumnField(field.id, field.numberOfValues, field.type, field.description);
                    fields[i].globalFieldIndex = -1;
                    ++i;
                }
            } else {
                ColumnType columnType = this.tsvColumnNameToTypeMap != null ? (this.tsvColumnNameToTypeMap.get(columnName) == null ? ColumnType.String : this.tsvColumnNameToTypeMap.get(columnName)) : ColumnType.String;
                fields = new ColumnField[]{new ColumnField("VALUE", 1, columnType, "")};
                fields[0].globalFieldIndex = -1;
            }
            ColumnInfo newCol = new ColumnInfo(columnName, fields);
            newCol.useFormat = true;
            this.columns.add(newCol);
        }
        this.formatColumn = this.columns.find("FORMAT");
        ObjectListIterator objectListIterator = this.columns.iterator();
        while (objectListIterator.hasNext()) {
            ColumnInfo column = (ColumnInfo)objectListIterator.next();
            if (column.columnIndex == -1) {
                ++this.globalColumnIndex;
                column.columnIndex = column.columnIndex;
            }
            ObjectIterator<ColumnField> objectIterator = column.fields.iterator();
            while (objectIterator.hasNext()) {
                ColumnField field = (ColumnField)objectIterator.next();
                if (field.globalFieldIndex == -1) {
                    ++this.globalFieldIndex;
                    field.globalFieldIndex = field.globalFieldIndex;
                }
                String name = column.fields.size() == 1 ? column.columnName : String.format("%s[%s]", column.columnName, field.id);
                this.fieldIndexToName.put(field.globalFieldIndex, (Object)name);
            }
        }
        this.formatColumnIndex = this.TSV ? -1 : this.formatColumn.columnIndex;
        this.numberOfColumns = this.globalColumnIndex;
        this.columnStarts = new int[this.numberOfColumns];
        this.columnEnds = new int[this.numberOfColumns];
        this.numberOfFields = this.globalFieldIndex;
        this.fieldStarts = new int[this.numberOfFields];
        this.fieldEnds = new int[this.numberOfFields];
        this.fieldPermutation = new int[this.numberOfFields];
        this.columnList.addAll((Collection)((Object)this.columns));
        Collections.sort(this.columnList, COLUMN_SORT);
        for (ColumnInfo column : this.columnList) {
            this.fieldList.addAll((Collection)((Object)column.fields));
        }
    }

    private void defineFixedColumn(String columnName) {
        for (ColumnInfo fixed : fixedColumns) {
            if (!fixed.columnName.equals(columnName) || this.columns.hasColumnName(columnName)) continue;
            fixed.columnIndex = this.globalColumnIndex++;
            ObjectIterator<ColumnField> objectIterator = fixed.fields.iterator();
            while (objectIterator.hasNext()) {
                ColumnField field = (ColumnField)objectIterator.next();
                ++this.globalFieldIndex;
                field.globalFieldIndex = field.globalFieldIndex;
            }
            this.columns.add(fixed);
            return;
        }
    }

    public static ColumnInfo[] fixedColumn() {
        ColumnInfo[] copy = new ColumnInfo[fixedColumns.length];
        int i = 0;
        for (ColumnInfo fixedColumn : fixedColumns) {
            copy[i++] = fixedColumn.copy();
        }
        return copy;
    }

    private void processMetaInfoLine(MutableString line) throws SyntaxException {
        int start = 2;
        int end = line.indexOf('=');
        if (end > 2) {
            String columnName = line.substring(2, end).toString();
            MutableString restOfLine = line.substring(end + 1);
            this.processMetaInfo(columnName, restOfLine);
        }
    }

    private void processMetaInfo(String columnName, MutableString infoDefinition) throws SyntaxException {
        ColumnInfo info;
        if (this.line.startsWith("##FieldGroupAssociations=")) {
            this.associationString = this.line.replace("##FieldGroupAssociations=", "").toString();
            return;
        }
        if ("fileformat".equals(columnName) || "samtoolsVersion".equals(columnName)) {
            return;
        }
        Object[] array = new String[]{"FILTER", "INFO", "FORMAT"};
        ObjectArrayList fixedColumnNames = ObjectArrayList.wrap((Object[])array);
        if (!fixedColumnNames.contains((Object)columnName)) {
            return;
        }
        if (!infoDefinition.startsWith("<") && !infoDefinition.endsWith(">")) {
            return;
        }
        if (this.columns.hasColumnName(columnName)) {
            info = this.columns.find(columnName);
        } else {
            info = new ColumnInfo();
            info.columnName = columnName;
            this.columns.add(info);
        }
        ColumnField field = new ColumnField();
        MutableString insideBrackets = infoDefinition.substring(1, infoDefinition.length() - 1);
        try {
            String[] tokens;
            for (String token : tokens = insideBrackets.toString().split("(,N)|(,T)|(,D)|(,G)")) {
                String[] kv = new String[2];
                int firstEqualIndex = token.indexOf(61);
                kv[0] = token.substring(0, firstEqualIndex);
                kv[1] = token.substring(firstEqualIndex + 1);
                if ("ID".equals(kv[0])) {
                    field.id = kv[1];
                    continue;
                }
                if ("umber".equals(kv[0])) {
                    String num = kv[1];
                    if (".".equals(num)) {
                        num = "-1";
                    }
                    field.numberOfValues = Integer.parseInt(num);
                    continue;
                }
                if ("ype".equals(kv[0])) {
                    field.type = ColumnType.valueOf(kv[1]);
                    continue;
                }
                if ("roup".equals(kv[0])) {
                    field.group = kv[1];
                    continue;
                }
                if ("escription".equals(kv[0])) {
                    if (kv[1].startsWith("\"") && kv[1].endsWith("\"")) {
                        kv[1] = kv[1].substring(1, kv[1].length() - 1);
                    }
                    field.description = kv[1];
                    continue;
                }
                throw new SyntaxException(infoDefinition);
            }
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(infoDefinition);
        }
        info.addField(field);
    }

    public int getGlobalFieldIndex(String columnName, String fieldId) {
        ColumnInfo column = this.columns.find(columnName);
        if (column == null) {
            return -1;
        }
        ColumnField columnField = column.fields.find(fieldId);
        if (columnField == null) {
            return -1;
        }
        return columnField.globalFieldIndex;
    }

    @Override
    public void close() throws IOException {
        if (this.bufferedReader != null) {
            IOUtils.closeQuietly((Reader)this.bufferedReader);
        }
        IOUtils.closeQuietly((Reader)this.input);
    }

    public String[] getColumnNamesUsingFormat() {
        ObjectArrayList columnNamesUsingFormat = new ObjectArrayList();
        ObjectIterator<ColumnInfo> objectIterator = this.columns.iterator();
        while (objectIterator.hasNext()) {
            ColumnInfo info = (ColumnInfo)objectIterator.next();
            if (!info.useFormat) continue;
            columnNamesUsingFormat.add((Object)info.columnName);
        }
        return (String[])columnNamesUsingFormat.toArray((Object[])new String[columnNamesUsingFormat.size()]);
    }

    public void setCacheFieldPermutation(boolean cacheFieldPermutation) {
        this.cacheFieldPermutation = cacheFieldPermutation;
    }

    public GroupAssociations getGroupAssociations() {
        return new GroupAssociations(this.associationString, this.columns.find("FORMAT"), this.getColumnNamesUsingFormat());
    }

    public class SyntaxException
    extends Exception {
        public SyntaxException(MutableString line) {
            super(line.toString());
        }
    }
}

