/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Caret;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final long serialVersionUID = 3876025080382781659L;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    private static final String SELECTION_BACKGROUND_CHANGED_PROPERTY = "selectionBackground";
    private static final String SELECTION_FOREGROUND_CHANGED_PROPERTY = "selectionForeground";
    protected Hashtable defaultEditorsByColumnClass;
    protected Hashtable defaultRenderersByColumnClass;
    protected int editingColumn;
    protected int editingRow;
    protected transient Component editorComp;
    protected boolean autoCreateColumnsFromModel;
    protected int autoResizeMode;
    protected int rowHeight;
    protected int rowMargin;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected TableCellEditor cellEditor;
    private boolean dragEnabled;
    protected Color gridColor;
    protected Dimension preferredViewportSize;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected JTableHeader tableHeader;
    int rowBeingEdited;
    int columnBeingEdited;
    Timer editorTimer;
    Object oldCellValue;
    TableColumnPropertyChangeHandler tableColumnPropertyChangeHandler;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$JScrollPane;
    private static final /* synthetic */ boolean assert;

    protected void initializeLocalVars() {
        this.setTableHeader(this.createDefaultTableHeader());
        if (this.autoCreateColumnsFromModel) {
            this.createDefaultColumnsFromModel();
        }
        this.columnModel.addColumnModelListener(this);
        this.defaultRenderersByColumnClass = new Hashtable();
        this.createDefaultRenderers();
        this.defaultEditorsByColumnClass = new Hashtable();
        this.createDefaultEditors();
        this.autoResizeMode = 2;
        this.rowHeight = 16;
        this.rowMargin = 1;
        this.rowSelectionAllowed = true;
        this.cellEditor = null;
        this.dragEnabled = true;
        this.preferredViewportSize = new Dimension(450, 400);
        this.showHorizontalLines = true;
        this.showVerticalLines = true;
        this.editingColumn = -1;
        this.editingRow = -1;
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    public void addColumn(TableColumn column) {
        if (column.getHeaderValue() == null) {
            String name = this.dataModel.getColumnName(column.getModelIndex());
            column.setHeaderValue(name);
        }
        this.columnModel.addColumn(column);
        column.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
    }

    protected void createDefaultEditors() {
    }

    protected void createDefaultRenderers() {
        Class clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = JTable.class("[Ljava.lang.Boolean;", false);
        }
        this.setDefaultRenderer(clazz, new BooleanCellRenderer());
        Class clazz2 = class$java$lang$Number;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Number = JTable.class("[Ljava.lang.Number;", false);
        }
        this.setDefaultRenderer(clazz2, new NumberCellRenderer());
        Class clazz3 = class$java$lang$Double;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Double = JTable.class("[Ljava.lang.Double;", false);
        }
        this.setDefaultRenderer(clazz3, new DoubleCellRenderer());
        Class clazz4 = class$java$lang$Double;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Double = JTable.class("[Ljava.lang.Double;", false);
        }
        this.setDefaultRenderer(clazz4, new FloatCellRenderer());
        Class clazz5 = class$java$util$Date;
        if (clazz5 == null) {
            clazz5 = class$java$util$Date = JTable.class("[Ljava.util.Date;", false);
        }
        this.setDefaultRenderer(clazz5, new DateCellRenderer());
        Class clazz6 = class$javax$swing$Icon;
        if (clazz6 == null) {
            clazz6 = class$javax$swing$Icon = JTable.class("[Ljavax.swing.Icon;", false);
        }
        this.setDefaultRenderer(clazz6, new IconCellRenderer());
    }

    public static JScrollPane createScrollPaneForTable(JTable table) {
        return new JScrollPane(table);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    public void columnAdded(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnMoved(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent event) {
        this.repaint();
    }

    public void editingCanceled(ChangeEvent event) {
        if (this.rowBeingEdited > -1 && this.columnBeingEdited > -1) {
            if (this.getValueAt(this.rowBeingEdited, this.columnBeingEdited) instanceof JTextField) {
                this.remove((Component)this.getValueAt(this.rowBeingEdited, this.columnBeingEdited));
                this.setValueAt(this.oldCellValue, this.rowBeingEdited, this.columnBeingEdited);
            }
            this.rowBeingEdited = -1;
            this.columnBeingEdited = -1;
        }
        this.editorTimer.stop();
        this.editorComp = null;
        this.cellEditor = null;
        this.requestFocusInWindow(false);
        this.repaint();
    }

    public void editingStopped(ChangeEvent event) {
        if (this.rowBeingEdited > -1 && this.columnBeingEdited > -1) {
            if (this.getValueAt(this.rowBeingEdited, this.columnBeingEdited) instanceof JTextField) {
                this.remove((Component)this.getValueAt(this.rowBeingEdited, this.columnBeingEdited));
                this.setValueAt(((JTextField)this.editorComp).getText(), this.rowBeingEdited, this.columnBeingEdited);
            }
            this.rowBeingEdited = -1;
            this.columnBeingEdited = -1;
        }
        this.editorTimer.stop();
        this.editorComp = null;
        this.cellEditor = null;
        this.requestFocusInWindow(false);
        this.repaint();
    }

    public void tableChanged(TableModelEvent event) {
        if (event.getFirstRow() == -1 && this.autoCreateColumnsFromModel) {
            this.createDefaultColumnsFromModel();
        }
        if (event.getType() == 1 || event.getType() == -1) {
            this.revalidate();
        }
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent event) {
        this.repaint();
    }

    public int columnAtPoint(Point point) {
        if (point != null) {
            int x0 = this.getLocation().x;
            int ncols = this.getColumnCount();
            Dimension gap = this.getIntercellSpacing();
            TableColumnModel cols = this.getColumnModel();
            int x = point.x;
            int i = 0;
            while (i < ncols) {
                int n = cols.getColumn(i).getWidth();
                int n2 = 0;
                if (gap != null) {
                    n2 = gap.width;
                }
                int width = n + n2;
                if (x >= 0 && x < width) {
                    return i;
                }
                x -= width;
                ++i;
            }
        }
        return -1;
    }

    public int rowAtPoint(Point point) {
        if (point != null) {
            int y0 = this.getLocation().y;
            int nrows = this.getRowCount();
            int height = this.getRowHeight();
            int y = point.y;
            int i = 0;
            while (i < nrows) {
                if (y >= 0 && y < height) {
                    return i;
                }
                y -= height;
                ++i;
            }
        }
        return -1;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        int height = this.getRowHeight(row);
        int width = this.columnModel.getColumn(column).getWidth();
        int x_gap = this.columnModel.getColumnMargin();
        int y_gap = this.rowMargin;
        column = Math.max(0, Math.min(column, this.getColumnCount() - 1));
        row = Math.max(0, Math.min(row, this.getRowCount() - 1));
        int x = 0;
        int y = (height + y_gap) * row;
        int i = 0;
        while (i < column) {
            x += this.columnModel.getColumn(i).getWidth();
            ++i;
        }
        if (includeSpacing) {
            return new Rectangle(x, y, width, height);
        }
        return new Rectangle(x, y, width - x_gap, height - y_gap);
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.getColumnModel().getSelectionModel().clearSelection();
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height * direction;
        }
        return visibleRect.width * direction;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return direction * this.rowHeight;
        }
        int sum = 0;
        int i = 0;
        while (i < this.getColumnCount()) {
            sum += this.columnModel.getColumn(0).getWidth();
            ++i;
        }
        int inc = this.getColumnCount() == 0 ? 10 : sum / this.getColumnCount();
        return direction * inc;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.columnModel.getColumn(column).getCellEditor();
        if (editor == null) {
            editor = this.getDefaultEditor(this.dataModel.getColumnClass(column));
        }
        return editor;
    }

    public TableCellEditor getDefaultEditor(Class columnClass) {
        if (this.defaultEditorsByColumnClass.containsKey(columnClass)) {
            return (TableCellEditor)this.defaultEditorsByColumnClass.get(columnClass);
        }
        DefaultCellEditor r = new DefaultCellEditor(new JTextField());
        this.defaultEditorsByColumnClass.put(columnClass, r);
        return r;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.columnModel.getColumn(column).getCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(this.dataModel.getColumnClass(column));
        }
        return renderer;
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer rend) {
        this.defaultRenderersByColumnClass.put(columnClass, rend);
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        if (this.defaultRenderersByColumnClass.containsKey(columnClass)) {
            return (TableCellRenderer)this.defaultRenderersByColumnClass.get(columnClass);
        }
        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        this.defaultRenderersByColumnClass.put(columnClass, r);
        return r;
    }

    public int convertColumnIndexToModel(int vc) {
        if (vc < 0) {
            return vc;
        }
        return this.columnModel.getColumn(vc).getModelIndex();
    }

    public int convertColumnIndexToView(int mc) {
        if (mc < 0) {
            return mc;
        }
        int ncols = this.getColumnCount();
        int vc = 0;
        while (vc < ncols) {
            if (this.columnModel.getColumn(vc).getModelIndex() == mc) {
                return vc;
            }
            ++vc;
        }
        return -1;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean rsa = this.getRowSelectionAllowed();
        boolean csa = this.getColumnSelectionAllowed();
        boolean bl = false;
        if (rsa) {
            bl = this.getSelectionModel().isSelectedIndex(row);
        }
        boolean rs = bl;
        boolean bl2 = false;
        if (csa) {
            bl2 = this.columnModel.getSelectionModel().isSelectedIndex(column);
        }
        boolean cs = bl2;
        boolean bl3 = false;
        if (rsa && csa && rs && cs || rsa && !csa && rs || !rsa && csa && cs) {
            bl3 = true;
        }
        boolean isSelected = bl3;
        return renderer.getTableCellRendererComponent(this, this.dataModel.getValueAt(row, this.convertColumnIndexToModel(column)), isSelected, false, row, column);
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowHeight(int row) {
        return this.rowHeight;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean getCellSelectionEnabled() {
        boolean bl = false;
        if (this.getColumnSelectionAllowed() && this.getRowSelectionAllowed()) {
            bl = true;
        }
        return bl;
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    private static final int countSelections(ListSelectionModel lsm) {
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int sum = 0;
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    sum = 1;
                    break;
                }
                case 1: {
                    sum = hi - lo + 1;
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ++sum;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return sum;
    }

    private static final int[] getSelections(ListSelectionModel lsm) {
        int sz = JTable.countSelections(lsm);
        int[] ret = new int[sz];
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int j = 0;
        ArrayList ls = new ArrayList();
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    ret[0] = lo;
                    break;
                }
                case 1: {
                    int i = lo;
                    while (i <= hi) {
                        ret[j++] = i++;
                    }
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ret[j++] = i;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return ret;
    }

    public int getSelectedColumnCount() {
        return JTable.countSelections(this.columnModel.getSelectionModel());
    }

    public int[] getSelectedColumns() {
        return JTable.getSelections(this.columnModel.getSelectionModel());
    }

    public boolean getColumnSelectionAllowed() {
        return this.getColumnModel().getColumnSelectionAllowed();
    }

    public int getSelectedRowCount() {
        return JTable.countSelections(this.selectionModel);
    }

    public int[] getSelectedRows() {
        return JTable.getSelections(this.selectionModel);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.columnModel.getColumnMargin(), this.rowMargin);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void removeColumn(TableColumn column) {
        this.columnModel.removeColumn(column);
    }

    public void moveColumn(int column, int targetColumn) {
        this.columnModel.moveColumn(column, targetColumn);
    }

    public void setAutoCreateColumnsFromModel(boolean autoCreate) {
        if (this.autoCreateColumnsFromModel != autoCreate) {
            this.autoCreateColumnsFromModel = autoCreate;
            if (autoCreate) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    public void setAutoResizeMode(int a) {
        this.autoResizeMode = a;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int r) {
        if (r < 1) {
            throw new IllegalArgumentException();
        }
        this.rowHeight = r;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int row, int rh) {
        this.setRowHeight(rh);
    }

    public void setRowMargin(int r) {
        this.rowMargin = r;
        this.revalidate();
        this.repaint();
    }

    public void setRowSelectionAllowed(boolean r) {
        this.rowSelectionAllowed = r;
        this.repaint();
    }

    public void setCellSelectionEnabled(boolean c) {
        this.setColumnSelectionAllowed(c);
        this.setRowSelectionAllowed(c);
        this.cellSelectionEnabled = true;
    }

    public void setModel(TableModel m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataModel == m) {
            return;
        }
        TableModel oldModel = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        if (m != null) {
            this.dataModel = m;
            this.dataModel.addTableModelListener(this);
            if (this.autoCreateColumnsFromModel) {
                this.createDefaultColumnsFromModel();
            }
        }
        this.firePropertyChange("model", oldModel, this.dataModel);
        this.revalidate();
        this.repaint();
    }

    public void setColumnModel(TableColumnModel c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        TableColumnModel tmp = this.columnModel;
        if (tmp != null) {
            tmp.removeColumnModelListener(this);
        }
        if (c != null) {
            c.addColumnModelListener(this);
        }
        this.columnModel = c;
        if (this.dataModel != null && this.columnModel != null) {
            int ncols = this.getColumnCount();
            int i = 0;
            while (i < ncols) {
                this.columnModel.getColumn(i).setHeaderValue(this.dataModel.getColumnName(i));
                ++i;
            }
        }
        if (this.tableHeader != null) {
            this.tableHeader.setColumnModel(c);
        }
        this.revalidate();
        this.repaint();
    }

    public void setColumnSelectionAllowed(boolean c) {
        this.getColumnModel().setColumnSelectionAllowed(c);
        this.repaint();
    }

    public void setSelectionModel(ListSelectionModel s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        ListSelectionModel tmp = this.selectionModel;
        if (tmp != null) {
            tmp.removeListSelectionListener(this);
        }
        if (s != null) {
            s.addListSelectionListener(this);
        }
        this.selectionModel = s;
    }

    public void setSelectionMode(int s) {
        this.selectionModel.setSelectionMode(s);
        this.columnModel.getSelectionModel().setSelectionMode(s);
        this.repaint();
    }

    public void setCellEditor(TableCellEditor c) {
        TableCellEditor tmp = this.cellEditor;
        if (tmp != null) {
            tmp.removeCellEditorListener(this);
        }
        if (c != null) {
            c.addCellEditorListener(this);
        }
        this.cellEditor = c;
    }

    public void setDragEnabled(boolean d) {
        this.dragEnabled = d;
    }

    public void setGridColor(Color g) {
        this.gridColor = g;
        this.repaint();
    }

    public void setIntercellSpacing(Dimension i) {
        this.rowMargin = i.height;
        this.columnModel.setColumnMargin(i.width);
        this.repaint();
    }

    public void setPreferredScrollableViewportSize(Dimension p) {
        this.preferredViewportSize = p;
        this.revalidate();
        this.repaint();
    }

    public void setSelectionBackground(Color s) {
        Color tmp = this.selectionBackground;
        this.selectionBackground = s;
        if (tmp == null && s != null || s == null && tmp != null || tmp != null && s != null && !tmp.equals(s)) {
            this.firePropertyChange(SELECTION_BACKGROUND_CHANGED_PROPERTY, tmp, s);
        }
        this.repaint();
    }

    public void setSelectionForeground(Color s) {
        Color tmp = this.selectionForeground;
        this.selectionForeground = s;
        if (tmp == null && s != null || s == null && tmp != null || tmp != null && s != null && !tmp.equals(s)) {
            this.firePropertyChange(SELECTION_FOREGROUND_CHANGED_PROPERTY, tmp, s);
        }
        this.repaint();
    }

    public void setShowGrid(boolean s) {
        this.setShowVerticalLines(s);
        this.setShowHorizontalLines(s);
    }

    public void setShowHorizontalLines(boolean s) {
        this.showHorizontalLines = s;
        this.repaint();
    }

    public void setShowVerticalLines(boolean s) {
        this.showVerticalLines = s;
        this.repaint();
    }

    public void setTableHeader(JTableHeader t) {
        if (this.tableHeader != null) {
            this.tableHeader.setTable(null);
        }
        this.tableHeader = t;
        if (this.tableHeader != null) {
            this.tableHeader.setTable(this);
        }
        this.revalidate();
        this.repaint();
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane jsp;
        Class clazz = class$javax$swing$JScrollPane;
        if (clazz == null) {
            clazz = class$javax$swing$JScrollPane = JTable.class("[Ljavax.swing.JScrollPane;", false);
        }
        if ((jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(clazz, this)) != null && this.tableHeader != null) {
            jsp.setColumnHeaderView(this.tableHeader);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane jsp;
        Class clazz = class$javax$swing$JScrollPane;
        if (clazz == null) {
            clazz = class$javax$swing$JScrollPane = JTable.class("[Ljavax.swing.JScrollPane;", false);
        }
        if ((jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(clazz, this)) != null) {
            jsp.setColumnHeaderView(null);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    public void removeNotify() {
        super.addNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private final void distributeSpill(TableColumn[] cols, int spill) {
        int average = spill / cols.length;
        int i = 0;
        while (i < cols.length) {
            if (cols[i] != null) {
                cols[i].setWidth(cols[i].getWidth() + average);
            }
            ++i;
        }
    }

    public void doLayout() {
        TableColumn col;
        TableColumn resizingColumn = null;
        int ncols = this.getColumnCount();
        if (ncols < 1) {
            return;
        }
        int[] pref = new int[ncols];
        int prefSum = 0;
        int rCol = -1;
        if (this.tableHeader != null) {
            resizingColumn = this.tableHeader.getResizingColumn();
        }
        int i = 0;
        while (i < ncols) {
            int p;
            col = this.columnModel.getColumn(i);
            pref[i] = p = col.getWidth();
            prefSum += p;
            if (resizingColumn == col) {
                rCol = i;
            }
            ++i;
        }
        int spill = this.getWidth() - prefSum;
        if (resizingColumn != null) {
            switch (this.getAutoResizeMode()) {
                case 3: {
                    col = this.columnModel.getColumn(ncols - 1);
                    col.setWidth(col.getPreferredWidth() + spill);
                    break;
                }
                case 1: {
                    col = this.columnModel.getColumn(ncols - 1);
                    col.setWidth(col.getPreferredWidth() + spill);
                    break;
                }
                case 4: {
                    TableColumn[] cols = new TableColumn[ncols];
                    int i2 = 0;
                    while (i2 < ncols) {
                        cols[i2] = this.columnModel.getColumn(i2);
                        ++i2;
                    }
                    this.distributeSpill(cols, spill);
                    break;
                }
                case 2: {
                    TableColumn[] cols = new TableColumn[ncols];
                    int i3 = rCol;
                    while (i3 < ncols) {
                        cols[i3] = this.columnModel.getColumn(i3);
                        ++i3;
                    }
                    this.distributeSpill(cols, spill);
                    break;
                }
                default: {
                    int prefWidth = resizingColumn.getPreferredWidth();
                    resizingColumn.setWidth(prefWidth);
                    break;
                }
            }
        } else {
            TableColumn[] cols = new TableColumn[ncols];
            int i4 = 0;
            while (i4 < ncols) {
                cols[i4] = this.columnModel.getColumn(i4);
                ++i4;
            }
            this.distributeSpill(cols, spill);
        }
    }

    public void sizeColumnsToFit(boolean lastColumnOnly) {
        this.doLayout();
    }

    public void sizeColumnsToFit(int resizingColumn) {
        this.doLayout();
    }

    public String getUIClassID() {
        return "TableUI";
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((TableUI)UIManager.getUI(this));
        this.revalidate();
        this.repaint();
    }

    public Class getColumnClass(int column) {
        return this.dataModel.getColumnClass(column);
    }

    public String getColumnName(int column) {
        int modelColumn = this.columnModel.getColumn(column).getModelIndex();
        return this.dataModel.getColumnName(modelColumn);
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void setEditingColumn(int column) {
        this.editingColumn = column;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int column) {
        this.editingRow = column;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public boolean isEditing() {
        boolean bl = false;
        if (this.editorComp != null) {
            bl = true;
        }
        return bl;
    }

    public void setDefaultEditor(Class columnClass, TableCellEditor editor) {
        if (editor != null) {
            this.defaultEditorsByColumnClass.put(columnClass, editor);
        } else {
            this.defaultEditorsByColumnClass.remove(columnClass);
        }
    }

    public void addColumnSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getColumnCount() - 1 || index1 < 0 || index1 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().addSelectionInterval(index0, index1);
    }

    public void addRowSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getRowCount() - 1 || index1 < 0 || index1 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().addSelectionInterval(index0, index1);
    }

    public void setColumnSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getColumnCount() - 1 || index1 < 0 || index1 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().setSelectionInterval(index0, index1);
    }

    public void setRowSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getRowCount() - 1 || index1 < 0 || index1 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().setSelectionInterval(index0, index1);
    }

    public void removeColumnSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getColumnCount() - 1 || index1 < 0 || index1 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public void removeRowSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getRowCount() - 1 || index1 < 0 || index1 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public boolean isColumnSelected(int column) {
        return this.getColumnModel().getSelectionModel().isSelectedIndex(column);
    }

    public boolean isRowSelected(int row) {
        return this.getSelectionModel().isSelectedIndex(row);
    }

    public boolean isCellSelected(int row, int column) {
        boolean bl = false;
        if (this.isRowSelected(row) && this.isColumnSelected(column)) {
            bl = true;
        }
        return bl;
    }

    public void selectAll() {
        int rowLead = this.selectionModel.getLeadSelectionIndex();
        int colLead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        this.setRowSelectionInterval(0, this.getRowCount() - 1);
        this.addColumnSelectionInterval(colLead, colLead);
        this.addRowSelectionInterval(rowLead, rowLead);
    }

    public Object getValueAt(int row, int column) {
        return this.dataModel.getValueAt(row, this.convertColumnIndexToModel(column));
    }

    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        if (value instanceof Component) {
            this.add((Component)value);
        }
        this.dataModel.setValueAt(value, row, this.convertColumnIndexToModel(column));
    }

    public TableColumn getColumn(Object identifier) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(identifier));
    }

    public boolean isCellEditable(int row, int column) {
        return this.dataModel.isCellEditable(row, this.convertColumnIndexToModel(column));
    }

    public void createDefaultColumnsFromModel() {
        if (!assert && this.columnModel == null) {
            throw new AssertionError((Object)"The columnModel must not be null.");
        }
        int columnIndex = this.columnModel.getColumnCount() - 1;
        while (columnIndex >= 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(columnIndex));
            --columnIndex;
        }
        int columnCount = this.dataModel.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            TableColumn column = new TableColumn(c);
            column.setIdentifier(this.dataModel.getColumnName(c));
            column.setHeaderValue(this.dataModel.getColumnName(c));
            this.columnModel.addColumn(column);
            column.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
            ++c;
        }
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (toggle && extend) {
            this.selectionModel.setAnchorSelectionIndex(rowIndex);
            this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(columnIndex);
        } else if (toggle) {
            if (this.isCellSelected(rowIndex, columnIndex)) {
                this.selectionModel.removeSelectionInterval(rowIndex, rowIndex);
                this.getColumnModel().getSelectionModel().removeSelectionInterval(columnIndex, columnIndex);
            } else {
                this.selectionModel.addSelectionInterval(rowIndex, rowIndex);
                this.getColumnModel().getSelectionModel().addSelectionInterval(columnIndex, columnIndex);
            }
        } else if (extend) {
            this.selectionModel.setLeadSelectionIndex(rowIndex);
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(columnIndex);
        } else {
            this.selectionModel.clearSelection();
            this.selectionModel.setSelectionInterval(rowIndex, rowIndex);
            this.getColumnModel().getSelectionModel().clearSelection();
            this.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
        }
    }

    public boolean editCellAt(int row, int column) {
        this.oldCellValue = this.getValueAt(row, column);
        this.setCellEditor(this.getCellEditor(row, column));
        this.editorComp = this.prepareEditor(this.cellEditor, row, column);
        this.cellEditor.addCellEditorListener(this);
        this.rowBeingEdited = row;
        this.columnBeingEdited = column;
        this.setValueAt(this.editorComp, row, column);
        ((JTextField)this.editorComp).requestFocusInWindow(false);
        this.editorTimer.start();
        return true;
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        return this.editCellAt(row, column);
    }

    public void removeEditor() {
        this.editingStopped(new ChangeEvent(this));
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        return editor.getTableCellEditorComponent(this, this.getValueAt(row, column), this.isCellSelected(row, column), row, column);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.rowBeingEdited = -1;
        this.columnBeingEdited = -1;
        this.editorTimer = new EditorUpdateTimer();
        this.tableColumnPropertyChangeHandler = new TableColumnPropertyChangeHandler();
    }

    public JTable() {
        this(null, null, null);
    }

    public JTable(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public JTable(Object[][] data, Object[] columnNames) {
        this(new DefaultTableModel(data, columnNames));
    }

    public JTable(TableModel dm) {
        this(dm, null, null);
    }

    public JTable(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    public JTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        this.this();
        boolean autoCreate = false;
        if (cm != null) {
            this.setColumnModel(cm);
        } else {
            this.setColumnModel(this.createDefaultColumnModel());
            autoCreate = true;
        }
        this.setSelectionModel(sm == null ? this.createDefaultSelectionModel() : sm);
        this.setModel(dm == null ? this.createDefaultDataModel() : dm);
        this.setAutoCreateColumnsFromModel(autoCreate);
        this.initializeLocalVars();
        this.selectionModel.setAnchorSelectionIndex(0);
        this.selectionModel.setLeadSelectionIndex(0);
        this.columnModel.getSelectionModel().setAnchorSelectionIndex(0);
        this.columnModel.getSelectionModel().setLeadSelectionIndex(0);
        this.updateUI();
    }

    public JTable(Vector data, Vector columnNames) {
        this(new DefaultTableModel(data, columnNames));
    }

    static {
        assert = Class.forName("[Ljavax.swing.JTable;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BooleanCellRenderer
    extends DefaultTableCellRenderer {
        private JCheckBox checkBox;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean boolValue = (Boolean)value;
            this.checkBox.setSelected(boolValue);
            return this.checkBox;
        }

        private final /* synthetic */ void this() {
            this.checkBox = new JCheckBox();
        }

        private BooleanCellRenderer() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NumberCellRenderer
    extends DefaultTableCellRenderer {
        public NumberCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DoubleCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                NumberFormat nf = NumberFormat.getInstance();
                this.setText(nf.format(doubleValue));
            }
            return this;
        }

        public DoubleCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class FloatCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Float) {
                Float floatValue = (Float)value;
                NumberFormat nf = NumberFormat.getInstance();
                this.setText(nf.format(floatValue.floatValue()));
            }
            return this;
        }

        public FloatCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DateCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                Date dateValue = (Date)value;
                DateFormat df = DateFormat.getDateInstance(3);
                this.setText(df.format(dateValue));
            }
            return this;
        }

        private DateCellRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IconCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Icon) {
                Icon iconValue = (Icon)value;
                this.setIcon(iconValue);
            }
            return this;
        }

        private IconCellRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EditorUpdateTimer
    extends Timer
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            Caret c = ((JTextField)JTable.this.editorComp).getCaret();
            if (c != null) {
                c.setVisible(c.isVisible() ^ true);
            }
            JTable.this.repaint();
        }

        public void update() {
            this.stop();
            Caret c = ((JTextField)JTable.this.editorComp).getCaret();
            if (c != null) {
                this.setDelay(c.getBlinkRate());
                if (((JTextField)JTable.this.editorComp).isEditable()) {
                    this.start();
                } else {
                    c.setVisible(false);
                }
            }
        }

        public EditorUpdateTimer() {
            super(500, null);
            this.addActionListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TableColumnPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("preferredWidth")) {
                JTableHeader header = JTable.this.getTableHeader();
                TableColumn col = (TableColumn)ev.getSource();
                header.setResizingColumn(col);
                JTable.this.doLayout();
                header.setResizingColumn(null);
            }
        }

        TableColumnPropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        public int getAccessibleSelectionCount() {
            return JTable.this.getSelectedColumnCount();
        }

        public Accessible getAccessibleSelection(int i) {
            return null;
        }

        public boolean isAccessibleChildSelected(int i) {
            return false;
        }

        public void addAccessibleSelection(int i) {
        }

        public void removeAccessibleSelection(int i) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }

        public void valueChanged(ListSelectionEvent event) {
        }

        public void tableChanged(TableModelEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.tableRowsInserted(event);
                    break;
                }
                case -1: {
                    this.tableRowsDeleted(event);
                    break;
                }
            }
        }

        public void tableRowsInserted(TableModelEvent event) {
        }

        public void tableRowsDeleted(TableModelEvent event) {
        }

        public void columnAdded(TableColumnModelEvent event) {
        }

        public void columnMarginChanged(ChangeEvent event) {
        }

        public void columnMoved(TableColumnModelEvent event) {
        }

        public void columnRemoved(TableColumnModelEvent event) {
        }

        public void columnSelectionChanged(ListSelectionEvent event) {
        }

        public void editingCanceled(ChangeEvent event) {
        }

        public void editingStopped(ChangeEvent event) {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if (propName.equals("tableModel")) {
                TableModel oldModel = (TableModel)e.getOldValue();
                oldModel.removeTableModelListener(this);
                TableModel newModel = (TableModel)e.getNewValue();
                newModel.addTableModelListener(this);
            } else if (propName.equals("columnModel")) {
                TableColumnModel oldModel = (TableColumnModel)e.getOldValue();
                oldModel.removeColumnModelListener(this);
                TableColumnModel newModel = (TableColumnModel)e.getNewValue();
                newModel.addColumnModelListener(this);
            } else if (propName.equals("selectionModel")) {
                ListSelectionModel oldModel = (ListSelectionModel)e.getOldValue();
                oldModel.removeListSelectionListener(this);
                ListSelectionModel newModel = (ListSelectionModel)e.getNewValue();
                newModel.addListSelectionListener(this);
            } else if (propName.equals("cellEditor")) {
                CellEditor oldEd = (CellEditor)e.getOldValue();
                oldEd.removeCellEditorListener(this);
                CellEditor newEd = (CellEditor)e.getNewValue();
                newEd.addCellEditorListener(this);
            }
        }

        public int getAccessibleRow(int index) {
            return 0;
        }

        public int getAccessibleColumn(int index) {
            return 0;
        }

        public int getAccessibleIndex(int r, int c) {
            return 0;
        }

        public Accessible getAccessibleCaption() {
            return null;
        }

        public void setAccessibleCaption(Accessible caption) {
        }

        public Accessible getAccessibleSummary() {
            return null;
        }

        public void setAccessibleSummary(Accessible summary) {
        }

        public int getAccessibleRowCount() {
            return 0;
        }

        public int getAccessibleColumnCount() {
            return 0;
        }

        public Accessible getAccessibleAt(int r, int c) {
            return null;
        }

        public int getAccessibleRowExtentAt(int r, int c) {
            return 0;
        }

        public int getAccessibleColumnExtentAt(int r, int c) {
            return 0;
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public void setAccessibleRowHeader(AccessibleTable header) {
        }

        public AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        public void setAccessibleColumnHeader(AccessibleTable header) {
        }

        public Accessible getAccessibleRowDescription(int r) {
            return null;
        }

        public void setAccessibleRowDescription(int r, Accessible description) {
        }

        public Accessible getAccessibleColumnDescription(int c) {
            return null;
        }

        public void setAccessibleColumnDescription(int c, Accessible description) {
        }

        public boolean isAccessibleSelected(int r, int c) {
            return false;
        }

        public boolean isAccessibleRowSelected(int r) {
            return false;
        }

        public boolean isAccessibleColumnSelected(int c) {
            return false;
        }

        public int[] getSelectedAccessibleRows() {
            return null;
        }

        public int[] getSelectedAccessibleColumns() {
            return null;
        }

        protected AccessibleJTable() {
            JTable.this.getModel().addTableModelListener(this);
            JTable.this.getSelectionModel().addListSelectionListener(this);
            JTable.this.getColumnModel().addColumnModelListener(this);
            JTable.this.getCellEditor().addCellEditorListener(this);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            public int getType() {
                return this.type;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }

            protected AccessibleJTableModelChange(int type, int firstRow, int lastRow, int firstColumn, int lastColumn) {
                this.type = type;
                this.firstRow = firstRow;
                this.lastRow = lastRow;
                this.firstColumn = firstColumn;
                this.lastColumn = lastColumn;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable table;
            private int row;
            private int column;
            private int index;

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return new AccessibleStateSet();
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public Locale getLocale() {
                return Locale.ENGLISH;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.table.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.table.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.table.getCursor();
            }

            public void setCursor(Cursor cursor) {
            }

            public Font getFont() {
                return this.table.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.table.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.table.isEnabled();
            }

            public void setEnabled(boolean b) {
            }

            public boolean isVisible() {
                return this.table.isVisible();
            }

            public void setVisible(boolean b) {
            }

            public boolean isShowing() {
                return this.table.isShowing();
            }

            public boolean contains(Point point) {
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                cellRect.x = 0;
                cellRect.y = 0;
                return cellRect.contains(point);
            }

            public Point getLocationOnScreen() {
                Point tableLoc = this.table.getLocationOnScreen();
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                tableLoc.x += cellRect.x;
                tableLoc.y += cellRect.y;
                return tableLoc;
            }

            public Point getLocation() {
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                return new Point(cellRect.x, cellRect.y);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.table.getCellRect(this.row, this.column, true);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                return new Dimension(cellRect.width, cellRect.height);
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return this.table.isFocusable();
            }

            public void requestFocus() {
                this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(this.column);
                this.table.getSelectionModel().setLeadSelectionIndex(this.row);
                this.table.requestFocus();
            }

            public void addFocusListener(FocusListener listener) {
                this.table.addFocusListener(listener);
            }

            public void removeFocusListener(FocusListener listener) {
                this.table.removeFocusListener(listener);
            }

            public AccessibleJTableCell(JTable t, int r, int c, int i) {
                this.table = t;
                this.row = r;
                this.column = c;
                this.index = i;
            }
        }
    }
}

