'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH cmip n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
cmip \- A Tcl interface to the CMIP protocol.
.BE

.SH DESCRIPTION
The \fBcmip\fR command provides an interface to the Common Management
Information Protocol. It enables Tcl scripts to connect to a remote
OSI management agent and to use the Common Management Information
Services (CMIS).

.SH CMIP COMMAND
.TP
.B cmip connect \fIagent\fR \fIhost\fR
The \fBcmip connect\fR command establishes an association to a remote
\fIagent\fR running on \fIhost\fR.  This command returns a cmip
association object which allows to invoke association specific
commands (see below).
.TP
.B cmip wait
The \fBcmip wait\fR command blocks until all asynchronous requests for
all CMIP associations have been processed. Events are processed while
waiting for outstanding responses which can have arbitrary side
effects.
.TP
.B cmip info
The \fBcmip info\fR command returns a list of all existing cmip
association handles that have been created using the \fBcmip connect\fR
command.

.SH CMIP ASSOCIATION COMMAND
.TP
.B cmip# get \fIclass\fR \fIinstance\fR ?\fIoptions\fR?
Retrieve management information on this association (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object that will be returned,
if not modified by the options.

.RS 5
The available 
.I options
for get are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -attributes \fIattributes\fR
The \fIattributes\fR is a list, that may contain the attributes to ask
for. {} for no attributes. Default is all attributes. Each Element of
the list may be a list, but only the first element is used as an
attribute to look for (so e.g. the result of an get or set request may
be used as the input).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.RE

.TP
.B cmip# set \fIclass\fR \fIinstance\fR \fIattributes\fR ?\fIoptions\fR?
Set management information at the agent (cmip#). The \fIclass\fR and
the \fIinstance\fR define the base managed object on which
\fIattributes\fR will be set, if not modified by the options. The
\fIattributes\fR argument is a list whose elements are a list of
attribute-type, attribute-value and an
\fImodify-operation\fRtriples. The possible \fImodify-operations\fR
are replace, addValue, removeValue and setToDefault. If no
\fImodify-operation\fR is given, than replace is used.

.RS 5
The available 
.I options
for set are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.TP
.B -nonconfirmed
The set-option may be used as a confirmed or non-confirmed service.
Default is to use the confirmed service, but if you want to use the
unconfirmed service just use -nonconfirmed as one of the options.

.RE

.TP
.B cmip# action \fIclass\fR \fIinstance\fR \fIaction\fR ?\fIoptions\fR?
Perform an action on management information at the agent (cmip#).
The \fIclass\fR and the \fIinstance\fR define the base managed object on
which the \fIaction\fR will be performed,
if not modified by the options. The \fIaction\fR is a list containing the
action-type and an optional action-value.

.RS 5
The available 
.I options
for set are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.TP
.B -nonconfirmed
The action-option may be used as a confirmed or non-confirmed service.
Default is to use the confirmed service, but if you want to use the
unconfirmed service just use -nonconfirmed as one of the options.

.RE

.TP
.B cmip# create \fIclass\fR ?\fIoptions\fR?
Create a managed object (MO) at the agent (cmip#).

.RS 5
The available 
.I options
for create are:
.RE

.RS 
.TP 10
.B -instance \fIinstance\fR | -superior \fIsuperiorInst\fR
The \fIinstance\fR specifies the object instance name, alternatively
the \fIsuperiorInst\fR specifies the object that is the parent in the
containment tree

.TP
.B -reference \fIreferenceInst\fR
The \fIreferenceInst\fR specifies a reference object instance to be used for
initial attribute values to be copied.

.TP
.B -attributes \fIattributes\fR
The \fIattributes\fR specifies initial attribute values, it contains a
list of attribute-type and attribute-value pairs.

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is complete.
.RE

.TP
.B cmip# delete \fIclass\fR \fIinstance\fR ?\fIoptions\fR?
Delete managed object(s) at the agent (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object which
will be deleted,
if not modified by the options.

.RS 5
The available 
.I options
for delete are:
.RE

.RS 
.TP 10
.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is complete.

.RE

.TP
.B cmip# cancelGet \fIrequestHandle\fR ?-callback callback?
Cancel the outstanding asynchronous GET request at the agent (cmip#),
given by \fIrequestHandle\fR. If a callback is given, it will be executed,
if the result of the asynchronous request is complete.

.TP
.B cmip# eventSink ?-callback callback?
Initialize a callback for event reports. If no callback is given, this
will wait for event reports till eternity and show event reports
emitted by MOs of the agent.

.TP
.B cmip# requests
The \fBcmip# requests\fR command returns a list of all outstanding
asynchronous requests.
.TP
.B cmip# wait
The \fBcmip# wait\fR command blocks until all asynchronous requests
for this association are processed. Events are processed while
waiting for outstanding responses which can have arbitrary side
effects.
.TP
.B cmip# release
The \fBcmip# release\fR command releases the association and deletes
the cmip# object. The \fBcmip# release\fR command should be the normal
way to terminate an association.
.TP
.B cmip# abort
The \fBcmip# abort\fR command aborts the association immediately and
deletes the cmip# object.

.SH BUGS
The current implementation of the \fBcmip\fR commands described above
depends on the OSIMIS package which itself depends on the ISODE
package. Both packages are no longer freely available and both
packages tend to be complicated to install.

.SH SEE ALSO
scotty(1), Tcl(n)

.SH AUTHORS
Michael Kernchen <kernchen@ibr.cs.tu-bs.de>
.br
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
