/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.wiztools.restclient.bean.MultipartMode;
import org.wiztools.restclient.bean.MultipartSubtype;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.RESTUserInterface;

public class MultipartOptionsDialog
extends EscapableDialog {
    protected final RESTUserInterface rest_ui;
    private static final MultipartMode DEFAULT_MODE = MultipartMode.BROWSER_COMPATIBLE;
    private static final MultipartSubtype DEFAULT_SUBTYPE = MultipartSubtype.FORM_DATA;
    private final JComboBox<MultipartSubtype> jcb_subtype = new JComboBox<MultipartSubtype>(MultipartSubtype.values());
    private final JComboBox<MultipartMode> jcb_mode = new JComboBox<MultipartMode>(MultipartMode.values());
    private final JButton jb_ok = new JButton("Ok");
    private final JButton jb_cancel = new JButton("Cancel");
    private MultipartSubtype selectedSubtype = DEFAULT_SUBTYPE;
    private MultipartMode selectedMode = DEFAULT_MODE;

    @Inject
    public MultipartOptionsDialog(RESTUserInterface ui) {
        super((Frame)ui.getFrame(), true);
        this.rest_ui = ui;
        this.setTitle("Multipart Options");
        this.initComponents();
        this.initLayout();
        this.pack();
    }

    private void initComponents() {
        this.jcb_subtype.setSelectedItem((Object)DEFAULT_SUBTYPE);
        this.jcb_mode.setSelectedItem((Object)DEFAULT_MODE);
        this.getRootPane().setDefaultButton(this.jb_ok);
        this.jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipartOptionsDialog.this.onOk();
            }
        });
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipartOptionsDialog.this.onCancel();
            }
        });
    }

    private void initLayout() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(5, 5));
        JPanel jp = new JPanel(new GridLayout(2, 1));
        jp.add(new JLabel(" Subtype (multipart/?): "));
        jp.add(new JLabel(" Mode: "));
        c.add((Component)jp, "West");
        jp = new JPanel(new GridLayout(2, 1));
        jp.add(this.jcb_subtype);
        jp.add(this.jcb_mode);
        c.add((Component)jp, "Center");
        jp = new JPanel(new FlowLayout(2));
        jp.add(this.jb_cancel);
        jp.add(this.jb_ok);
        c.add((Component)jp, "South");
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.onCancel();
    }

    private void onOk() {
        this.selectedMode = (MultipartMode)((Object)this.jcb_mode.getSelectedItem());
        this.selectedSubtype = (MultipartSubtype)((Object)this.jcb_subtype.getSelectedItem());
        this.setVisible(false);
    }

    private void onCancel() {
        this.jcb_mode.setSelectedItem((Object)this.selectedMode);
        this.jcb_subtype.setSelectedItem((Object)this.selectedSubtype);
        this.setVisible(false);
    }

    public void clear() {
        this.selectedMode = DEFAULT_MODE;
        this.selectedSubtype = DEFAULT_SUBTYPE;
        this.jcb_mode.setSelectedItem((Object)DEFAULT_MODE);
        this.jcb_subtype.setSelectedItem((Object)DEFAULT_SUBTYPE);
    }

    public MultipartSubtype getSelectedSubtype() {
        return this.selectedSubtype;
    }

    public void setSelectedSubtype(MultipartSubtype selectedSubtype) {
        this.selectedSubtype = selectedSubtype;
        this.jcb_subtype.setSelectedItem((Object)selectedSubtype);
    }

    public MultipartMode getSelectedMode() {
        return this.selectedMode;
    }

    public void setSelectedMode(MultipartMode selectedMode) {
        this.selectedMode = selectedMode;
        this.jcb_mode.setSelectedItem((Object)selectedMode);
    }
}

