require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_PROC_H_)) {
    eval 'sub _SYS_PROC_H_ () {1;}' unless defined(&_SYS_PROC_H_);
    require 'sys/lwp.ph';
    if(defined(&_KMEMUSER) || defined(&_KERNEL)) {
	if(defined(&_KERNEL_OPT)) {
	    require './sys/opt_multiprocessor.ph';
	    require './sys/opt_kstack.ph';
	    require './sys/opt_lockdebug.ph';
	}
	require 'machine/proc.ph';
	require 'machine/pcb.ph';
	require 'sys/aio.ph';
	require 'sys/idtype.ph';
	require 'sys/rwlock.ph';
	require 'sys/mqueue.ph';
	require 'sys/mutex.ph';
	require 'sys/condvar.ph';
	require 'sys/queue.ph';
	require 'sys/signalvar.ph';
	require 'sys/siginfo.ph';
	require 'sys/event.ph';
	require 'sys/specificdata.ph';
	unless(defined(&_KERNEL)) {
	    require 'sys/time.ph';
	    require 'sys/resource.ph';
	}
	eval 'sub S_LOGIN_SET () {1;}' unless defined(&S_LOGIN_SET);
	unless(defined(&__HAVE_MINIMAL_EMUL)) {
	}
	if(defined(&__HAVE_SYSCALL_INTERN)) {
	} else {
	}
	eval 'sub EMUL_HAS_SYS___syscall () {0x1;}' unless defined(&EMUL_HAS_SYS___syscall);
	eval 'sub p_startzero () { &p_nlwps;}' unless defined(&p_startzero);
	eval 'sub p_endzero () { &p_startcopy;}' unless defined(&p_endzero);
	eval 'sub p_startcopy () { &p_sigctx;}' unless defined(&p_startcopy);
	eval 'sub p_endcopy () { &p_xsig;}' unless defined(&p_endcopy);
	eval 'sub p_rlimit () { ($p_limit->{pl_rlimit});}' unless defined(&p_rlimit);
	eval 'sub p_session () { ($p_pgrp->{pg_session});}' unless defined(&p_session);
	eval 'sub p_pgid () { ($p_pgrp->{pg_id});}' unless defined(&p_pgid);
    }
    eval 'sub SIDL () {1;}' unless defined(&SIDL);
    eval 'sub SACTIVE () {2;}' unless defined(&SACTIVE);
    eval 'sub SDYING () {3;}' unless defined(&SDYING);
    eval 'sub SSTOP () {4;}' unless defined(&SSTOP);
    eval 'sub SZOMB () {5;}' unless defined(&SZOMB);
    eval 'sub SDEAD () {6;}' unless defined(&SDEAD);
    eval 'sub P_ZOMBIE {
        my($p) = @_;
	    eval q((($p)-> &p_stat ==  &SZOMB || ($p)-> &p_stat ==  &SDYING || ($p)-> &p_stat ==  &SDEAD));
    }' unless defined(&P_ZOMBIE);
    eval 'sub PK_ADVLOCK () {0x1;}' unless defined(&PK_ADVLOCK);
    eval 'sub PK_SYSTEM () {0x2;}' unless defined(&PK_SYSTEM);
    eval 'sub PK_SYSVSEM () {0x4;}' unless defined(&PK_SYSVSEM);
    eval 'sub PK_SUGID () {0x100;}' unless defined(&PK_SUGID);
    eval 'sub PK_KMEM () {0x200;}' unless defined(&PK_KMEM);
    eval 'sub PK_EXEC () {0x4000;}' unless defined(&PK_EXEC);
    eval 'sub PK_NOCLDWAIT () {0x20000;}' unless defined(&PK_NOCLDWAIT);
    eval 'sub PK_32 () {0x40000;}' unless defined(&PK_32);
    eval 'sub PK_CLDSIGIGN () {0x80000;}' unless defined(&PK_CLDSIGIGN);
    eval 'sub PK_MARKER () {0x80000000;}' unless defined(&PK_MARKER);
    eval 'sub PS_NOCLDSTOP () {0x8;}' unless defined(&PS_NOCLDSTOP);
    eval 'sub PS_RUMP_LWPEXIT () {0x400;}' unless defined(&PS_RUMP_LWPEXIT);
    eval 'sub PS_WCORE () {0x1000;}' unless defined(&PS_WCORE);
    eval 'sub PS_WEXIT () {0x2000;}' unless defined(&PS_WEXIT);
    eval 'sub PS_STOPFORK () {0x800000;}' unless defined(&PS_STOPFORK);
    eval 'sub PS_STOPEXEC () {0x1000000;}' unless defined(&PS_STOPEXEC);
    eval 'sub PS_STOPEXIT () {0x2000000;}' unless defined(&PS_STOPEXIT);
    eval 'sub PS_COREDUMP () {0x20000000;}' unless defined(&PS_COREDUMP);
    eval 'sub PS_CONTINUED () {0x40000000;}' unless defined(&PS_CONTINUED);
    eval 'sub PS_STOPPING () {0x80000000;}' unless defined(&PS_STOPPING);
    eval 'sub PSL_TRACEFORK () {0x1;}' unless defined(&PSL_TRACEFORK);
    eval 'sub PSL_TRACEVFORK () {0x2;}' unless defined(&PSL_TRACEVFORK);
    eval 'sub PSL_TRACEVFORK_DONE () {0x4;}' unless defined(&PSL_TRACEVFORK_DONE);
    eval 'sub PSL_TRACELWP_CREATE () {0x8;}' unless defined(&PSL_TRACELWP_CREATE);
    eval 'sub PSL_TRACELWP_EXIT () {0x10;}' unless defined(&PSL_TRACELWP_EXIT);
    eval 'sub PSL_TRACEPOSIX_SPAWN () {0x20;}' unless defined(&PSL_TRACEPOSIX_SPAWN);
    eval 'sub PSL_TRACED () {0x800;}' unless defined(&PSL_TRACED);
    eval 'sub PSL_CHTRACED () {0x400000;}' unless defined(&PSL_CHTRACED);
    eval 'sub PSL_SYSCALL () {0x4000000;}' unless defined(&PSL_SYSCALL);
    eval 'sub PSL_SYSCALLEMU () {0x8000000;}' unless defined(&PSL_SYSCALLEMU);
    eval 'sub PST_PROFIL () {0x20;}' unless defined(&PST_PROFIL);
    eval 'sub PL_CONTROLT () {0x2;}' unless defined(&PL_CONTROLT);
    eval 'sub PL_PPWAIT () {0x10;}' unless defined(&PL_PPWAIT);
    eval 'sub PL_SIGCOMPAT () {0x200;}' unless defined(&PL_SIGCOMPAT);
    eval 'sub PL_ORPHANPG () {0x20000000;}' unless defined(&PL_ORPHANPG);
    if(defined(&_KMEMUSER) || defined(&_KERNEL)) {
	eval 'sub P_EXITSIG {
	    my($p) = @_;
    	    eval q(((($p)-> &p_slflag &  &PSL_TRACED) ?  &SIGCHLD :  ($p->{p_exitsig})));
	}' unless defined(&P_EXITSIG);
	eval 'sub P_WAITSTATUS {
	    my($p) = @_;
    	    eval q( &W_EXITCODE(($p)-> &p_xexit, (($p)-> &p_xsig | ((($p)-> &p_sflag &  &PS_COREDUMP) ?  &WCOREFLAG : 0))));
	}' unless defined(&P_WAITSTATUS);
	if(defined(&_KERNEL)) {
	    eval 'sub PID_MAX () {30000;}' unless defined(&PID_MAX);
	    eval 'sub NO_PGID () {(( &pid_t)-1);}' unless defined(&NO_PGID);
	    eval 'sub SESS_LEADER {
	        my($p) = @_;
    		eval q((($p)-> ($p_session->{s_leader}) == ($p)));
	    }' unless defined(&SESS_LEADER);
	    eval 'sub FORK_PPWAIT () {0x1;}' unless defined(&FORK_PPWAIT);
	    eval 'sub FORK_SHAREVM () {0x2;}' unless defined(&FORK_SHAREVM);
	    eval 'sub FORK_SHARECWD () {0x4;}' unless defined(&FORK_SHARECWD);
	    eval 'sub FORK_SHAREFILES () {0x8;}' unless defined(&FORK_SHAREFILES);
	    eval 'sub FORK_SHARESIGS () {0x10;}' unless defined(&FORK_SHARESIGS);
	    eval 'sub FORK_NOWAIT () {0x20;}' unless defined(&FORK_NOWAIT);
	    eval 'sub FORK_CLEANFILES () {0x40;}' unless defined(&FORK_CLEANFILES);
	    eval 'sub FORK_SYSTEM () {0x80;}' unless defined(&FORK_SYSTEM);
	    eval 'sub vmspace_kernel () {
	        eval q(( ($proc0->{p_vmspace})));
	    }' unless defined(&vmspace_kernel);
	    if(defined(&__HAVE_SYSCALL_INTERN)) {
	    }
	    eval 'sub _proclist_skipmarker {
	        my($p0) = @_;
    		eval q({ \'struct proc\' * &p = $p0;  &while ( &p !=  &NULL  &&  ($p->{p_flag}) &  &PK_MARKER)  &p =  &LIST_NEXT( &p,  &p_list);  &p; });
	    }' unless defined(&_proclist_skipmarker);
	    eval 'sub PROC_PTRSZ {
	        my($p) = @_;
    		eval q(((($p)-> &p_flag &  &PK_32) ? $sizeof{\'int\'} : $sizeof{ &void }));
	    }' unless defined(&PROC_PTRSZ);
	    eval 'sub PROC_REGSZ {
	        my($p) = @_;
    		eval q(((($p)-> &p_flag &  &PK_32) ? $sizeof{ &process_reg32} : $sizeof{\'struct reg\'}));
	    }' unless defined(&PROC_REGSZ);
	    eval 'sub PROC_FPREGSZ {
	        my($p) = @_;
    		eval q(((($p)-> &p_flag &  &PK_32) ? $sizeof{ &process_fpreg32} : $sizeof{\'struct fpreg\'}));
	    }' unless defined(&PROC_FPREGSZ);
	    eval 'sub PROC_DBREGSZ {
	        my($p) = @_;
    		eval q(((($p)-> &p_flag &  &PK_32) ? $sizeof{ &process_dbreg32} : $sizeof{\'struct dbreg\'}));
	    }' unless defined(&PROC_DBREGSZ);
	    eval 'sub PROCLIST_FOREACH {
	        my($var, $head) = @_;
    		eval q( &for (($var) =  &LIST_FIRST($head); (($var) =  &_proclist_skipmarker($var)) !=  &NULL; ($var) =  &LIST_NEXT($var,  &p_list)));
	    }' unless defined(&PROCLIST_FOREACH);
	    if(defined(&KSTACK_CHECK_MAGIC)) {
	    } else {
		eval 'sub kstack_setup_magic {
		    my($x) = @_;
    		    eval q();
		}' unless defined(&kstack_setup_magic);
		eval 'sub kstack_check_magic {
		    my($x) = @_;
    		    eval q();
		}' unless defined(&kstack_check_magic);
	    }
	}
	unless(defined(&KSTACK_LOWEST_ADDR)) {
	    eval 'sub KSTACK_LOWEST_ADDR {
	        my($l) = @_;
    		eval q((( &void *) &ALIGN((($l)-> &l_addr) + 1)));
	    }' unless defined(&KSTACK_LOWEST_ADDR);
	}
	unless(defined(&KSTACK_SIZE)) {
	    eval 'sub KSTACK_SIZE () {( &USPACE -  &ALIGN($sizeof{\'struct pcb\'}));}' unless defined(&KSTACK_SIZE);
	}
    }
}
1;
