/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.Matrix3x3;
import br.arca.morcego.physics.Vector3D;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Matrix3DTest
extends TestCase {
    public void setUp() throws Exception {
        super.setUp();
        Config.init();
        Morcego.setUp();
    }

    public void testConstructor() {
        Matrix3x3 m = new Matrix3x3();
        Assert.assertTrue((String)"New matrix must be identity", (boolean)m.isIdentity());
    }

    public void testIdentity() {
        Matrix3x3 identity = new Matrix3x3();
        Matrix3x3 n = new Matrix3x3();
        n = n.multiplyByScalar(17.0f);
        n = n.multiplyByMatrix(Matrix3x3.getXRotation(79.0f));
        String nDescription = n.toString();
        n.multiplyByMatrix(identity);
        Assert.assertTrue((String)"Matrix multiplied by identity must remain same", (boolean)nDescription.equals(n.multiplyByMatrix(identity).toString()));
    }

    public void testMultiply() {
        Matrix3x3 m = new Matrix3x3();
        m.multiplyByScalar(20.0f);
        m.multiplyByScalar(0.0f);
    }

    public void testSetIdentity() {
        Matrix3x3 m = new Matrix3x3();
        m = m.multiplyByScalar(23.0f);
        Assert.assertFalse((String)"Matrix should not be identity after multiplication", (boolean)m.isIdentity());
        m.setIdentity();
        Assert.assertTrue((String)"Matrix should be identity", (boolean)m.isIdentity());
    }

    public void testTransform() {
        Matrix3x3 m = new Matrix3x3();
        float x = 10.0f;
        float y = 20.0f;
        float z = 30.0f;
        Vector3D v = new Vector3D(x, y, z);
        m.multiplyByVector(v);
        Assert.assertTrue((String)"Identity matrix should not modify vertex", (x == v.x && y == v.y && z == v.z ? 1 : 0) != 0);
    }

    public void testRotations() {
        Matrix3x3 m = new Matrix3x3();
        Vector3D v = new Vector3D(1.0f, 0.0f, 0.0f);
    }
}

