"""Initial revision

Revision ID: d295f8dcfa64
Revises: 
Create Date: 2019-09-27 00:21:02.527915

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd295f8dcfa64'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('client',
    sa.Column('id', sa.String(length=255), nullable=False),
    sa.Column('homeserver', sa.String(length=255), nullable=False),
    sa.Column('access_token', sa.Text(), nullable=False),
    sa.Column('enabled', sa.Boolean(), nullable=False),
    sa.Column('next_batch', sa.String(length=255), nullable=False),
    sa.Column('filter_id', sa.String(length=255), nullable=False),
    sa.Column('sync', sa.Boolean(), nullable=False),
    sa.Column('autojoin', sa.Boolean(), nullable=False),
    sa.Column('displayname', sa.String(length=255), nullable=False),
    sa.Column('avatar_url', sa.String(length=255), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('plugin',
    sa.Column('id', sa.String(length=255), nullable=False),
    sa.Column('type', sa.String(length=255), nullable=False),
    sa.Column('enabled', sa.Boolean(), nullable=False),
    sa.Column('primary_user', sa.String(length=255), nullable=False),
    sa.Column('config', sa.Text(), nullable=False),
    sa.ForeignKeyConstraint(['primary_user'], ['client.id'], onupdate='CASCADE', ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('plugin')
    op.drop_table('client')
    # ### end Alembic commands ###
