/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.charset.EncodingHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;

public class OutputStreamWriter
extends Writer {
    private static final int BUFFER_SIZE = 1024;
    private OutputStream out;
    private CharsetEncoder encoder;
    private String encodingName;
    private CharBuffer outputBuffer;

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flush();
        this.out.close();
        this.out = null;
    }

    public String getEncoding() {
        return this.out != null ? this.encodingName : null;
    }

    public void flush() throws IOException {
        if (this.out != null) {
            char[] cArray;
            if (this.outputBuffer != null && (cArray = new char[this.outputBuffer.position()]).length > 0) {
                this.outputBuffer.flip();
                this.outputBuffer.get(cArray);
                this.writeConvert(cArray, 0, cArray.length);
                this.outputBuffer.clear();
            }
            this.out.flush();
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.out == null) {
            throw new IOException("Stream is closed.");
        }
        if (cArray == null) {
            throw new IOException("Buffer is null.");
        }
        if (this.outputBuffer != null) {
            if (n2 >= this.outputBuffer.remaining()) {
                int n3 = this.outputBuffer.remaining();
                this.outputBuffer.put(cArray, n, n3);
                this.writeConvert(this.outputBuffer.array(), 0, 1024);
                this.outputBuffer.clear();
                n += n3;
                if ((n2 -= n3) >= this.outputBuffer.remaining()) {
                    this.writeConvert(cArray, n, n2);
                    return;
                }
            }
            this.outputBuffer.put(cArray, n, n2);
        } else {
            this.writeConvert(cArray, n, n2);
        }
    }

    private final void writeConvert(char[] cArray, int n, int n2) throws IOException {
        if (this.encoder == null) {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = (byte)(cArray[n + n3] <= '\u00ff' ? cArray[n + n3] : 63);
                ++n3;
            }
            this.out.write(byArray);
        } else {
            try {
                ByteBuffer byteBuffer = this.encoder.encode(CharBuffer.wrap(cArray, n, n2));
                this.encoder.reset();
                if (byteBuffer.hasArray()) {
                    this.out.write(byteBuffer.array());
                } else {
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    this.out.write(byArray);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new IOException("Internal error.");
            }
            catch (MalformedInputException malformedInputException) {
                throw new IOException("Invalid character sequence.");
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IOException("Unmappable character.");
            }
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (string == null) {
            throw new IOException("String is null.");
        }
        this.write(string.toCharArray(), n, n2);
    }

    public void write(int n) throws IOException {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.out = outputStream;
        try {
            if (EncodingHelper.isISOLatin1(string)) {
                this.encodingName = "ISO8859_1";
                this.encoder = null;
                return;
            }
            try {
                if (string.equalsIgnoreCase("UnicodeBig") || string.equalsIgnoreCase("UTF-16") || string.equalsIgnoreCase("UTF16")) {
                    string = "UTF-16BE";
                    outputStream.write(-2);
                    outputStream.write(-1);
                } else if (string.equalsIgnoreCase("UnicodeLittle")) {
                    string = "UTF-16LE";
                    outputStream.write(-1);
                    outputStream.write(-2);
                }
            }
            catch (IOException iOException) {}
            this.outputBuffer = CharBuffer.allocate(1024);
            Charset charset = EncodingHelper.getCharset(string);
            if (charset == null) {
                throw new UnsupportedEncodingException("Encoding " + string + " unknown");
            }
            this.encoder = charset.newEncoder();
            this.encodingName = EncodingHelper.getOldCanonical(charset.name());
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (RuntimeException runtimeException) {
            this.encoder = null;
            this.encodingName = "ISO8859_1";
        }
    }

    public OutputStreamWriter(OutputStream outputStream) {
        this.out = outputStream;
        this.outputBuffer = null;
        try {
            String string = System.getProperty("file.encoding");
            Charset charset = Charset.forName(string);
            this.encoder = charset.newEncoder();
            this.encodingName = EncodingHelper.getOldCanonical(charset.name());
        }
        catch (RuntimeException runtimeException) {
            this.encoder = null;
            this.encodingName = "ISO8859_1";
        }
        if (this.encoder != null) {
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.outputBuffer = CharBuffer.allocate(1024);
        }
    }

    public OutputStreamWriter(OutputStream outputStream, Charset charset) {
        this.out = outputStream;
        this.encoder = charset.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.outputBuffer = CharBuffer.allocate(1024);
    }

    public OutputStreamWriter(OutputStream outputStream, CharsetEncoder charsetEncoder) {
        this.out = outputStream;
        this.encoder = charsetEncoder;
        this.outputBuffer = CharBuffer.allocate(1024);
    }
}

