/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi.CORBA;

import gnu.CORBA.ObjectCreator;
import gnu.CORBA.Poa.AOM;
import gnu.CORBA.Poa.ORB_1_4;
import gnu.CORBA.Poa.gnuPOA;
import gnu.CORBA.typecodes.GeneralTypeCode;
import gnu.javax.rmi.CORBA.DelegateFactory;
import gnu.javax.rmi.CORBA.RmiUtilities;
import gnu.javax.rmi.CORBA.StubDelegateImpl;
import gnu.javax.rmi.CORBA.TieTargetRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnexpectedException;
import java.rmi.server.RMIClassLoader;
import java.util.Hashtable;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class UtilDelegateImpl
extends RmiUtilities
implements UtilDelegate {
    static ValueHandler m_ValueHandler;
    static Hashtable m_Ties;
    static Hashtable m_Targets;
    static final String m_StandardPackage = "org.omg.CORBA.";

    public java.lang.Object copyObject(java.lang.Object object, ORB oRB) throws RemoteException {
        if (object instanceof String) {
            return object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String[] || object instanceof String[][] || object instanceof String[][][]) {
            return ((java.lang.Object[])object).clone();
        }
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                return objectInputStream.readObject();
            }
            catch (Exception exception) {
                RemoteException remoteException = new RemoteException("Cannot copy " + object);
                throw remoteException;
            }
        }
        return object;
    }

    public java.lang.Object[] copyObjects(java.lang.Object[] objectArray, ORB oRB) throws RemoteException {
        return (java.lang.Object[])this.copyObject(objectArray, oRB);
    }

    public ValueHandler createValueHandler() {
        if (m_ValueHandler == null) {
            m_ValueHandler = (ValueHandler)DelegateFactory.getInstance("ValueHandler");
        }
        return m_ValueHandler;
    }

    public String getCodebase(Class clazz) {
        return RMIClassLoader.getClassAnnotation(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tie getTie(Remote remote) {
        Hashtable hashtable = m_Targets;
        synchronized (hashtable) {
            Tie tie;
            block6: {
                block5: {
                    TieTargetRecord tieTargetRecord = (TieTargetRecord)m_Targets.get(remote);
                    if (tieTargetRecord != null) return tieTargetRecord.tie;
                    if (!(remote instanceof Stub)) break block5;
                    tie = StubDelegateImpl.getTieFromStub(remote);
                    this.registerTarget(tie, remote);
                    break block6;
                }
                String string = this.getTieClassName(remote.getClass().getName());
                try {
                    Class clazz = Util.loadClass(string, null, remote.getClass().getClassLoader());
                    tie = (Tie)clazz.newInstance();
                }
                catch (Exception exception) {
                    MARSHAL mARSHAL = new MARSHAL("Unable to instantiate " + string);
                    mARSHAL.minor = 1195573274;
                    mARSHAL.initCause(exception);
                    throw mARSHAL;
                }
                tie.setTarget(remote);
                this.registerTarget(tie, remote);
            }
            return tie;
        }
    }

    private final String getTieClassName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n < 0 ? "_" + string + "_Tie" : string.substring(0, n + 1) + '_' + string.substring(n + 1) + "_Tie";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerTarget(Tie tie, Remote remote) {
        Hashtable hashtable = m_Ties;
        synchronized (hashtable) {
            Hashtable hashtable2 = m_Targets;
            synchronized (hashtable2) {
                TieTargetRecord tieTargetRecord = (TieTargetRecord)m_Ties.get(tie);
                if (tieTargetRecord == null) {
                    tieTargetRecord = new TieTargetRecord(tie);
                    m_Ties.put(tie, tieTargetRecord);
                }
                if (remote != null) {
                    tieTargetRecord.add(remote);
                    m_Targets.put(remote, tieTargetRecord);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unexportObject(Remote remote) throws NoSuchObjectException {
        Hashtable hashtable = m_Ties;
        synchronized (hashtable) {
            Hashtable hashtable2 = m_Targets;
            synchronized (hashtable2) {
                TieTargetRecord tieTargetRecord = (TieTargetRecord)m_Targets.get(remote);
                if (tieTargetRecord != null) {
                    if (remote instanceof Object) {
                        tieTargetRecord.tie.orb().disconnect((Object)((java.lang.Object)remote));
                    }
                    if (tieTargetRecord.unused()) {
                        m_Targets.remove(remote);
                        m_Ties.remove(tieTargetRecord.tie);
                        tieTargetRecord.tie.deactivate();
                        if (tieTargetRecord.tie.orb() instanceof ORB_1_4) {
                            AOM.Obj obj;
                            ORB_1_4 oRB_1_4 = (ORB_1_4)tieTargetRecord.tie.orb();
                            if (remote instanceof Object && (obj = oRB_1_4.rootPOA.findObject((Object)((java.lang.Object)remote))) != null && obj.servant == tieTargetRecord.tie && obj.poa instanceof gnuPOA) {
                                obj.poa.aom.remove(obj.key);
                                obj.deactivated = true;
                                obj.servant = null;
                            }
                        }
                    }
                }
                return;
            }
        }
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        try {
            return stub._is_local();
        }
        catch (SystemException systemException) {
            RemoteException remoteException = new RemoteException();
            remoteException.initCause(systemException);
            throw remoteException;
        }
    }

    public Class loadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        String string3 = System.getProperty("java.rmi.server.useCodebaseOnly");
        boolean bl = false;
        if (string3 != null && string3.trim().equalsIgnoreCase("true")) {
            bl = true;
        }
        boolean bl2 = bl;
        try {
            if (string2 != null && !bl2) {
                return RMIClassLoader.loadClass(string2, string);
            }
        }
        catch (Exception exception) {}
        try {
            if (string2 == null || bl2) {
                return RMIClassLoader.loadClass(string2, string);
            }
        }
        catch (Exception exception) {}
        if (classLoader != null) {
            return Class.forName(string, true, classLoader);
        }
        throw new ClassNotFoundException(string + " at " + string2);
    }

    public RemoteException mapSystemException(SystemException systemException) {
        RemoteException remoteException;
        String string;
        switch (systemException.completed.value()) {
            case 2: {
                string = "Maybe";
                break;
            }
            case 1: {
                string = "No";
                break;
            }
            case 0: {
                string = "Yes";
                break;
            }
            default: {
                string = "Unexpected completion status " + systemException.completed.value();
            }
        }
        String string2 = systemException.getClass().getName();
        if (string2.startsWith(m_StandardPackage)) {
            string2 = string2.substring(m_StandardPackage.length());
        }
        String string3 = "CORBA " + string2 + " 0x" + Integer.toHexString(systemException.minor) + ' ' + string;
        if (systemException instanceof COMM_FAILURE) {
            remoteException = new MarshalException(string3, systemException);
        } else if (systemException instanceof INV_OBJREF) {
            remoteException = new NoSuchObjectException(string3);
            remoteException.detail = systemException;
        } else if (systemException instanceof NO_PERMISSION) {
            remoteException = new AccessException(string3, systemException);
        } else if (systemException instanceof MARSHAL) {
            remoteException = new MarshalException(string3, systemException);
        } else if (systemException instanceof BAD_PARAM) {
            remoteException = new MarshalException(string3, systemException);
        } else if (systemException instanceof OBJECT_NOT_EXIST) {
            remoteException = new NoSuchObjectException(string3);
            remoteException.detail = systemException;
        } else if (systemException instanceof TRANSACTION_REQUIRED) {
            remoteException = new TransactionRequiredException(string3);
            remoteException.detail = systemException;
        } else if (systemException instanceof TRANSACTION_ROLLEDBACK) {
            remoteException = new TransactionRolledbackException(string3);
            remoteException.detail = systemException;
        } else if (systemException instanceof INVALID_TRANSACTION) {
            remoteException = new InvalidTransactionException(string3);
            remoteException.detail = systemException;
        } else {
            remoteException = systemException instanceof UNKNOWN ? this.wrapException(systemException.getCause()) : new RemoteException(string3, systemException);
        }
        return remoteException;
    }

    public RemoteException wrapException(Throwable throwable) throws RuntimeException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            return new ServerError(throwable.getMessage(), (Error)throwable);
        }
        if (throwable instanceof RemoteException) {
            return new ServerException(throwable.getMessage(), (Exception)throwable);
        }
        if (throwable instanceof SystemException) {
            return this.wrapException(this.mapSystemException((SystemException)throwable));
        }
        return new UnexpectedException("Unexpected", (Exception)throwable);
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream outputStream, java.lang.Object object) {
        ((OutputStream)outputStream).write_abstract_interface(object);
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream outputStream, java.lang.Object object) {
        boolean bl;
        Any any = outputStream.orb().create_any();
        if (object == null) {
            GeneralTypeCode generalTypeCode = new GeneralTypeCode(TCKind.tk_abstract_interface);
            generalTypeCode.setId("IDL:omg.org/CORBA/AbstractBase:1.0");
            generalTypeCode.setName("");
            any.type(generalTypeCode);
            outputStream.write_any(any);
            return;
        }
        if (object instanceof Object && !(object instanceof Remote) && (bl = ObjectCreator.insertWithHelper(any, object))) {
            outputStream.write_any(any);
            return;
        }
        if (object instanceof Object) {
            this.writeAnyAsRemote(outputStream, object);
        } else if (object instanceof Serializable) {
            any.insert_Value((Serializable)object);
            outputStream.write_any(any);
        } else {
            MARSHAL mARSHAL = new MARSHAL(object.getClass().getName() + " must be CORBA Object, Remote or Serializable");
            mARSHAL.minor = 1195573276;
            throw mARSHAL;
        }
    }

    void writeAnyAsRemote(org.omg.CORBA.portable.OutputStream outputStream, java.lang.Object object) {
        GeneralTypeCode generalTypeCode = new GeneralTypeCode(TCKind.tk_objref);
        generalTypeCode.setId(m_ValueHandler.getRMIRepositoryID(object.getClass()));
        generalTypeCode.setName(object.getClass().getName());
        outputStream.write_TypeCode(generalTypeCode);
        this.writeRemoteObject(outputStream, object);
    }

    String getName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public java.lang.Object readAny(InputStream inputStream) {
        return inputStream.read_any();
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream outputStream, java.lang.Object object) {
        OutputStream outputStream2 = (OutputStream)outputStream;
        if (object == null) {
            outputStream.write_Object(null);
        } else if (this.isTieRequired(object)) {
            Class clazz = this.getExportedInterface(object);
            this.exportTie(outputStream2, object, clazz);
        } else if (object instanceof Object) {
            this.ensureOrbRunning(outputStream2);
            outputStream.write_Object((Object)object);
        } else if (object != null && object instanceof Serializable) {
            this.writeFields(outputStream, (Serializable)object);
        }
    }

    static {
        m_Ties = new Hashtable();
        m_Targets = new Hashtable();
    }
}

