/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryPropertyEditor
extends PropertyEditorSupport {
    private static final Pattern BYTE_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*b?\\s*$", 2);
    private static final Pattern KIB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*k(ib)?\\s*$", 2);
    private static final Pattern MIB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*m(ib)?\\s*$", 2);
    private static final Pattern GIB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*g(ib)?\\s*$", 2);
    private static final Pattern TIB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*t(ib)?\\s*$", 2);
    private static final Pattern PIB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*p(ib)?\\s*$", 2);
    private static final Pattern EIB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*e(ib)?\\s*$", 2);
    private static final Pattern KB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*kb?\\s*$", 2);
    private static final Pattern MB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*mb?\\s*$", 2);
    private static final Pattern GB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*gb?\\s*$", 2);
    private static final Pattern TB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*tb?\\s*$", 2);
    private static final Pattern PB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*pb?\\s*$", 2);
    private static final Pattern EB_PATTERN = Pattern.compile("^\\s*(-?\\d+)\\s*eb?\\s*$", 2);

    public void setAsText(String text) throws IllegalArgumentException {
        Matcher m = BYTE_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)));
            return;
        }
        m = KIB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1024L);
            return;
        }
        m = MIB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1024L * 1024L);
            return;
        }
        m = GIB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1024L * 1024L * 1024L);
            return;
        }
        m = TIB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1024L * 1024L * 1024L * 1024L);
            return;
        }
        m = PIB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1024L * 1024L * 1024L * 1024L * 1024L);
            return;
        }
        m = EIB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1024L * 1024L * 1024L * 1024L * 1024L * 1024L);
            return;
        }
        m = KB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1000L);
            return;
        }
        m = MB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1000L * 1000L);
            return;
        }
        m = GB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1000L * 1000L * 1000L);
            return;
        }
        m = TB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1000L * 1000L * 1000L * 1000L);
            return;
        }
        m = PB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1000L * 1000L * 1000L * 1000L * 1000L);
            return;
        }
        m = EB_PATTERN.matcher(text);
        if (m.matches()) {
            this.setValue(Long.parseLong(m.group(1)) * 1000L * 1000L * 1000L * 1000L * 1000L * 1000L);
            return;
        }
        throw new IllegalArgumentException("Could convert not to a memory size: " + text);
    }

    public String getAsText() {
        Long value = (Long)this.getValue();
        if (value == null) {
            return "";
        }
        long v = value;
        if (v % 1024L != 0L) {
            if (v % 1000L != 0L) {
                return Long.toString(v);
            }
            if ((v /= 1000L) % 1000L != 0L) {
                return v + "kB";
            }
            if ((v /= 1000L) % 1000L != 0L) {
                return v + "MB";
            }
            if ((v /= 1000L) % 1000L != 0L) {
                return v + "GB";
            }
            if ((v /= 1000L) % 1000L != 0L) {
                return v + "TB";
            }
            if ((v /= 1000L) % 1000L != 0L) {
                return v + "PB";
            }
            return (v /= 1000L) + "EB";
        }
        if ((v /= 1024L) % 1024L != 0L) {
            return v + "KiB";
        }
        if ((v /= 1024L) % 1024L != 0L) {
            return v + "MiB";
        }
        if ((v /= 1024L) % 1024L != 0L) {
            return v + "GiB";
        }
        if ((v /= 1024L) % 1024L != 0L) {
            return v + "TiB";
        }
        if ((v /= 1024L) % 1024L != 0L) {
            return v + "PiB";
        }
        return (v /= 1024L) + "EiB";
    }

    public static long parse(String value) {
        MemoryPropertyEditor pe = new MemoryPropertyEditor();
        pe.setAsText(value);
        return (Long)pe.getValue();
    }

    public static String format(long value) {
        MemoryPropertyEditor pe = new MemoryPropertyEditor();
        pe.setValue(value);
        return pe.getAsText();
    }
}

