/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class OffscreenViewPanel
extends ViewPanel {
    BufferedImage buffImg;

    public BufferedImage getImage() {
        return this.buffImg;
    }

    public OffscreenViewPanel(Vector cameras) {
        this.cams = new Camera[cameras.size()];
        for (int nbcam = 0; nbcam < cameras.size(); ++nbcam) {
            this.cams[nbcam] = (Camera)cameras.get(nbcam);
        }
        this.setBackground(Color.white);
    }

    public synchronized void stop() {
    }

    public Dimension getSize() {
        return this.size != null ? this.size : new Dimension(0, 0);
    }

    public BufferedImage rasterize(int w, int h) {
        return this.rasterize(w, h, this.backColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage rasterize(int w, int h, Color backgroundColor) {
        this.backColor = backgroundColor;
        this.size = new Dimension(w, h);
        Graphics BufferG2D = null;
        Graphics g2d = null;
        if (this.buffImg == null) {
            this.buffImg = new BufferedImage(this.size.width, this.size.height, 2);
        }
        if (BufferG2D == null) {
            BufferG2D = this.buffImg.createGraphics();
        }
        BufferG2D.setFont(VirtualSpaceManager.mainFont);
        if (this.antialias) {
            ((Graphics2D)BufferG2D).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)BufferG2D).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2d = BufferG2D;
        this.standardStroke = ((Graphics2D)g2d).getStroke();
        this.standardTransform = ((Graphics2D)g2d).getTransform();
        g2d.setPaintMode();
        ((Graphics2D)g2d).setBackground(this.backColor);
        g2d.clearRect(0, 0, this.size.width, this.size.height);
        for (int nbcam = 0; nbcam < this.cams.length; ++nbcam) {
            if (this.cams[nbcam] == null || !this.cams[nbcam].enabled) continue;
            this.camIndex = this.cams[nbcam].getIndex();
            Vector vector = this.drawnGlyphs = this.cams[nbcam].parentSpace.getDrawnGlyphs(this.camIndex);
            synchronized (vector) {
                this.drawnGlyphs.removeAllElements();
                this.uncoef = (this.cams[nbcam].focal + this.cams[nbcam].altitude) / this.cams[nbcam].focal;
                this.viewW = this.getSize().width;
                this.viewH = this.getSize().height;
                this.viewEC = (long)((float)this.cams[nbcam].posx + (float)(this.viewW / 2L) * this.uncoef);
                this.viewNC = (long)((float)this.cams[nbcam].posy + (float)(this.viewH / 2L) * this.uncoef);
                this.viewWC = (long)((float)this.cams[nbcam].posx - (float)(this.viewW / 2L) * this.uncoef);
                this.viewSC = (long)((float)this.cams[nbcam].posy - (float)(this.viewH / 2L) * this.uncoef);
                this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                for (int i = 0; i < this.gll.length; ++i) {
                    if (!this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) continue;
                    Glyph glyph = this.gll[i];
                    synchronized (glyph) {
                        this.gll[i].project(this.cams[nbcam], this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw((Graphics2D)g2d, this.size.width, this.size.height, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                            this.cams[nbcam].parentSpace.drewGlyph(this.gll[i], this.camIndex);
                        }
                        continue;
                    }
                }
                continue;
            }
        }
        if (this.repaintListener != null) {
            this.repaintListener.viewRepainted(this.parent);
        }
        return this.buffImg;
    }
}

