/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.gogui.OptionalButton;
import net.sf.gogui.utils.Platform;

public class GoGuiToolBar
extends JToolBar {
    private boolean m_computerButtonsEnabled = true;
    private static final long serialVersionUID = 0L;
    private final ActionListener m_listener;
    private final OptionalButton m_buttonBeginning;
    private final OptionalButton m_buttonBackward;
    private final OptionalButton m_buttonBackward10;
    private final OptionalButton m_buttonEnd;
    private final OptionalButton m_buttonPlay;
    private final OptionalButton m_buttonForward;
    private final OptionalButton m_buttonForward10;
    private final OptionalButton m_buttonInterrupt;
    private final JButton m_buttonNew;
    private final OptionalButton m_buttonNextVariation;
    private final JButton m_buttonOpen;
    private final JButton m_buttonPass;
    private final OptionalButton m_buttonPreviousVariation;
    private final JButton m_buttonSave;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GoGuiToolBar(ActionListener actionListener) {
        this.m_listener = actionListener;
        this.m_buttonOpen = this.addButton("fileopen.png", "open", "Open");
        this.m_buttonSave = this.addButton("filesave2.png", "save", "Save");
        this.addSeparator();
        this.m_buttonNew = this.addButton("filenew.png", "new-game", "New Game");
        this.addSeparator();
        this.m_buttonPlay = this.addOptionalButton("next.png", "play", "Play");
        this.m_buttonPass = this.addButton("pass.png", "pass", "Pass");
        this.m_buttonInterrupt = this.addOptionalButton("stop.png", "interrupt", "Interrupt");
        this.addSeparator();
        this.m_buttonBeginning = this.addOptionalButton("beginning.png", "beginning", "Beginning");
        this.m_buttonBackward10 = this.addOptionalButton("backward10.png", "backward-10", "Backward 10");
        this.m_buttonBackward = this.addOptionalButton("back.png", "backward", "Backward");
        this.m_buttonForward = this.addOptionalButton("forward.png", "forward", "Forward");
        this.m_buttonForward10 = this.addOptionalButton("forward10.png", "forward-10", "Forward 10");
        this.m_buttonEnd = this.addOptionalButton("end.png", "end", "End");
        this.addSeparator();
        this.m_buttonNextVariation = this.addOptionalButton("down.png", "next-variation", "Next Variation");
        this.m_buttonPreviousVariation = this.addOptionalButton("up.png", "previous-variation", "Previous Variation");
        this.setRollover(true);
        this.setFloatable(false);
        this.putClientProperty("jgoodies.headerStyle", "Both");
    }

    public void setComputerEnabled(boolean bl) {
        this.m_computerButtonsEnabled = bl;
        this.m_buttonPlay.setSameDisabledIcon(bl);
        this.m_buttonInterrupt.setSameDisabledIcon(bl);
    }

    public void update(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        boolean bl = node.getFather() != null;
        boolean bl2 = node.getNumberChildren() > 0;
        boolean bl3 = NodeUtils.getNextVariation(node) != null;
        boolean bl4 = NodeUtils.getPreviousVariation(node) != null;
        this.m_buttonBeginning.setSameDisabledIcon(bl);
        this.m_buttonBackward.setSameDisabledIcon(bl);
        this.m_buttonBackward10.setSameDisabledIcon(bl);
        this.m_buttonForward.setSameDisabledIcon(bl2);
        this.m_buttonForward10.setSameDisabledIcon(bl2);
        this.m_buttonEnd.setSameDisabledIcon(bl2);
        this.m_buttonNextVariation.setSameDisabledIcon(bl3);
        this.m_buttonPreviousVariation.setSameDisabledIcon(bl4);
        this.paintImmediately(this.getVisibleRect());
    }

    public void enableAll(boolean bl, Node node) {
        GoGuiToolBar.setEnabled(this.m_buttonBeginning, bl);
        GoGuiToolBar.setEnabled(this.m_buttonBackward, bl);
        GoGuiToolBar.setEnabled(this.m_buttonBackward10, bl);
        GoGuiToolBar.setEnabled(this.m_buttonEnd, bl);
        GoGuiToolBar.setEnabled(this.m_buttonForward, bl);
        GoGuiToolBar.setEnabled(this.m_buttonForward10, bl);
        GoGuiToolBar.setEnabled(this.m_buttonInterrupt, false);
        GoGuiToolBar.setEnabled(this.m_buttonNew, bl);
        GoGuiToolBar.setEnabled(this.m_buttonNextVariation, bl);
        GoGuiToolBar.setEnabled(this.m_buttonOpen, bl);
        GoGuiToolBar.setEnabled(this.m_buttonPreviousVariation, bl);
        GoGuiToolBar.setEnabled(this.m_buttonSave, bl);
        if (Platform.isMac()) {
            GoGuiToolBar.setEnabled(this.m_buttonPlay, bl);
            GoGuiToolBar.setEnabled(this.m_buttonPass, bl);
        }
        if (bl) {
            if (!this.m_computerButtonsEnabled) {
                this.setComputerEnabled(false);
            }
            this.update(node);
        }
    }

    public void setCommandInProgress() {
        this.enableAll(false, null);
        if (!Platform.isMac()) {
            GoGuiToolBar.setEnabled(this.m_buttonPlay, true);
            GoGuiToolBar.setEnabled(this.m_buttonPass, true);
        }
        GoGuiToolBar.setEnabled(this.m_buttonInterrupt, true);
    }

    private JButton addButton(String string, String string2, String string3) {
        JButton jButton = new JButton();
        Icon icon = this.getIcon(string, string2);
        jButton.setIcon(icon);
        jButton.setDisabledIcon(icon);
        this.addButton(jButton, string2, string3);
        return jButton;
    }

    private JButton addButton(JButton jButton, String string, String string2) {
        jButton.setActionCommand(string);
        jButton.setToolTipText(string2);
        jButton.addActionListener(this.m_listener);
        jButton.setFocusable(false);
        this.add(jButton);
        return jButton;
    }

    private OptionalButton addOptionalButton(String string, String string2, String string3) {
        Icon icon = this.getIcon(string, string2);
        OptionalButton optionalButton = new OptionalButton(icon);
        this.addButton(optionalButton, string2, string3);
        return optionalButton;
    }

    private Icon getIcon(String string, String string2) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL uRL = classLoader.getResource("net/sf/gogui/images/" + string);
        return new ImageIcon(uRL, string2);
    }

    private static void setEnabled(JButton jButton, boolean bl) {
        jButton.setEnabled(bl);
    }

    static {
        $assertionsDisabled = !GoGuiToolBar.class.desiredAssertionStatus();
    }
}

