/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.core.references;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.util.List;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.ResourceRegistry;
import org.w3c.epubcheck.util.url.URLUtils;

public final class ReferenceRegistry {
    private final OCFContainer container;
    private final ImmutableList.Builder<Reference> references = ImmutableList.builder();
    private final ResourceRegistry resourceRegistry;

    public ReferenceRegistry(OCFContainer container, ResourceRegistry resourceRegistry) {
        Preconditions.checkArgument((container != null ? 1 : 0) != 0);
        Preconditions.checkArgument((resourceRegistry != null ? 1 : 0) != 0);
        this.container = container;
        this.resourceRegistry = resourceRegistry;
    }

    public List<Reference> asList() {
        return this.references.build();
    }

    public boolean isReferenced(URL resource) {
        return this.references.build().stream().anyMatch(ref -> ref.url.equals((Object)resource));
    }

    public void registerReference(URL url, Reference.Type type, EPUBLocation location) {
        this.registerReference(url, type, location, false);
    }

    public void registerReference(URL url, Reference.Type type, EPUBLocation location, boolean hasIntrinsicFallback) {
        if (url == null) {
            return;
        }
        if (url.isHierarchical() && url.query() != null && !this.container.isRemote(url)) {
            try {
                url = url.withQuery(null);
            }
            catch (GalimatiasParseException e) {
                new AssertionError((Object)"could not remove URL query");
            }
        }
        Reference xref = new Reference(url, type, location, hasIntrinsicFallback);
        this.references.add((Object)xref);
        if ("data".equals(url.scheme())) {
            this.resourceRegistry.registerResource(url, URLUtils.getDataURLType(url));
        }
    }

    public boolean hasReferencesTo(URL resource) {
        return resource != null && this.references.build().stream().anyMatch(ref -> resource.equals((Object)ref.targetResource));
    }
}

