/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.dtm;

import java.io.IOException;
import org.apache.xalan.xpath.SimpleNodeLocator;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XPathEnvSupport;
import org.apache.xalan.xpath.XPathFactory;
import org.apache.xalan.xpath.dtm.DTM;
import org.apache.xalan.xpath.dtm.DTMNodeLocator;
import org.apache.xalan.xpath.dtm.DTMProxy;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import org.apache.xalan.xpath.xml.DefaultErrorHandler;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTMLiaison
extends XercesLiaison {
    private boolean m_doThreading = true;

    boolean getDoThreading() {
        return this.m_doThreading;
    }

    void setDoThreading(boolean bl) {
        this.m_doThreading = bl;
    }

    public DTMLiaison(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    public DTMLiaison(XPathEnvSupport xPathEnvSupport) {
        super(xPathEnvSupport);
    }

    public DTMLiaison() {
    }

    public void setShouldExpandEntityRefs(boolean bl) {
        if (!bl) {
            this.warn(10);
        }
        this.m_shouldExpandEntityRefs = bl;
    }

    public void checkNode(Node node) throws SAXException {
        if (!(node instanceof DTMProxy)) {
            throw new SAXException(XSLMessages.createXPATHMessage(59, new Object[]{node.getClass()}));
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        if (this.m_docHandler == null) {
            DTM dTM = new DTM(this.getProblemListener());
            Object var3_3 = null;
            if (this.m_errorHandler != null) {
                dTM.setErrorHandler(this.m_errorHandler);
            } else {
                String string = inputSource.getSystemId() == null ? "Input XSL" : inputSource.getSystemId();
                dTM.setErrorHandler(new DefaultErrorHandler(string));
            }
            if (this.m_entityResolver != null) {
                dTM.setEntityResolver(this.m_entityResolver);
            }
            if (this.m_locale != null) {
                dTM.setLocale(this.m_locale);
            }
            dTM.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", this.getShouldExpandEntityRefs());
            if (this.m_useDOM2getNamespaceURI) {
                dTM.setFeature("http://xml.org/sax/features/namespaces", true);
            } else {
                dTM.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            if (this.m_isDefaultUseValidation) {
                dTM.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            } else if (this.getUseValidation()) {
                dTM.setFeature("http://xml.org/sax/features/validation", true);
            } else {
                dTM.setFeature("http://xml.org/sax/features/validation", false);
            }
            dTM.parse(inputSource);
            try {
                dTM.reset();
            }
            catch (Exception exception) {}
            ++this.m_parseCountSinceGC;
            if (this.m_parseCountSinceGC > 10) {
                this.m_parseCountSinceGC = 0;
                System.gc();
            }
            this.m_document = dTM.getDocument();
            inputSource.getSystemId();
            return;
        }
        super.parse(inputSource);
    }

    public boolean supportsSAX() {
        return true;
    }

    public String getNamespaceOfNode(Node node) {
        try {
            return ((DTMProxy)node).getNamespaceURI();
        }
        catch (ClassCastException classCastException) {
            return super.getNamespaceOfNode(node);
        }
    }

    public String getLocalNameOfNode(Node node) {
        try {
            return ((DTMProxy)node).getLocalName();
        }
        catch (ClassCastException classCastException) {
            return super.getLocalNameOfNode(node);
        }
    }

    public Node getParentOfNode(Node node) throws RuntimeException {
        try {
            return ((DTMProxy)node).getOwnerNode();
        }
        catch (ClassCastException classCastException) {
            return super.getParentOfNode(node);
        }
    }

    public Element getElementByID(String string, Document document) {
        try {
            return ((DTMProxy)document).getDTM().getIdentifier(string);
        }
        catch (ClassCastException classCastException) {
            return super.getElementByID(string, document);
        }
    }

    public String getUnparsedEntityURI(String string, Document document) {
        try {
            String string2 = null;
            DTMProxy dTMProxy = (DTMProxy)document;
            DTM dTM = dTMProxy.dtm;
            int n = dTM.getStringPool().addSymbol(string);
            int n2 = dTM.m_entities.get(n);
            int[] nArray = new int[4];
            dTM.m_entityNodes.readSlot(n2, nArray);
            if (nArray[3] >> 16 != 0 && (string2 = dTM.getStringPool().toString(nArray[3] & 0xFF)) == null) {
                string2 = dTM.getStringPool().toString(nArray[2]);
            }
            return string2;
        }
        catch (ClassCastException classCastException) {
            return super.getUnparsedEntityURI(string, document);
        }
    }

    public XPathFactory getDefaultXPathFactory() {
        return SimpleNodeLocator.factory();
    }

    public XLocator getXLocatorFromNode(Node node) {
        return DTMNodeLocator.getDefaultLocator();
    }

    public XLocator createXLocatorHandler() {
        return DTMNodeLocator.getDefaultLocator();
    }

    public boolean supportsNodeNumber(Node node) {
        return node instanceof DTMProxy;
    }

    public int getNodeNumber(Node node) {
        return ((DTMProxy)node).getDTMNodeNumber();
    }
}

