<?php

require_once dirname(__FILE__) . '/../../../videos/configuration.php';
require_once dirname(__FILE__) . '/../../../objects/bootGrid.php';
require_once dirname(__FILE__) . '/../../../objects/user.php';

class MenuItem extends ObjectYPT {

    protected $id, $title, $image, $url, $class, $style, $item_order, $topMenu_id, $status, $text, $icon, $clean_url, $menuSeoUrlItem;

    static function getSearchFieldsNames() {
        return array();
    }

    static function getTableName() {
        return 'topMenu_items';
    }

    static function getAllFromMenu($menu_id, $activeOnly = false, $sort = true) {
        global $global;
        if(empty($global)){
            $global = [];
        }
        $menu_id = intval($menu_id);
        if (empty($menu_id)) {
            return false;
        }
        $sql = "SELECT * FROM  " . static::getTableName() . " WHERE topMenu_id = {$menu_id}";

        if ($activeOnly) {
            $sql .= " AND status = 'active' ";
        }

        if ($sort) {
            $sql .= " ORDER BY item_order ";
        }

        $res = $global['mysqli']->query($sql);
        $rows = array();
        if ($res) {
            $webSiteRootURLParse = parse_url($global['webSiteRootURL']);
            $webSiteRootURLParse['host'] = strtolower($webSiteRootURLParse['host']);
            while ($row = $res->fetch_assoc()) {
                $row['finalURL'] = $row['url'];
                $row['target'] = "";
                if (!empty($row['url']) && strpos($row['url'], 'iframe:') === false) {// it is not an iframe
                    $parse = parse_url($row['url']);
                    if (!empty($parse['host']) && strtolower($parse['host']) !== $webSiteRootURLParse['host']) {// it is to another domain
                        $row['target'] = " target='_blank' rel='noopener noreferrer' ";
                    }
                } else {
                    if (!empty($row['menuSeoUrlItem'])) {
                        $row['finalURL'] = $global['webSiteRootURL'] . "menu/{$row['menuSeoUrlItem']}";
                    } else {
                        $row['finalURL'] = $global['webSiteRootURL'] . "plugin/TopMenu/?id={$row['id']}";
                    }
                }
                $rows[] = $row;
            }
        } 
        return $rows;
    }

    function setTitle($title) {
        $this->title = $title;
    }

    function setImage($image) {
        $this->image = $image;
    }

    function setUrl($url) {
        $this->url = $url;
    }

    function setClass($class) {
        $this->class = $class;
    }

    function setStyle($style) {
        $this->style = $style;
    }

    function setItem_order($item_order) {
        $this->item_order = intval($item_order);
    }

    function setTopMenu_id($topMenu_id) {
        $this->topMenu_id = intval($topMenu_id);
    }

    function setStatus($status) {
        $this->status = $status;
    }

    function setText($text) {
        $this->text = $text;
    }

    function setIcon($icon) {
        $this->icon = $icon;
    }

    function setClean_url($clean_url) {
        $this->clean_url = $clean_url;
    }

    function setmenuSeoUrlItem($menuSeoUrlItem) {
        $this->menuSeoUrlItem = $menuSeoUrlItem;
    }

    function save() {
        global $global;
        if (empty($this->title)) {
            $this->title = "Unknow Item Menu Title";
        }
        if (empty($this->status)) {
            $this->status = "active";
        }
        if (empty($this->menuSeoUrlItem)) {
            $this->menuSeoUrlItem = $this->title;
        }
        $this->menuSeoUrlItem = (preg_replace('/[^a-z0-9]+/', '_', strtolower($this->title)));

        $this->title = ($this->title);
        $this->text = ($this->text);

        return parent::save();
    }

    function getTitle() {
        return $this->title;
    }

    function getText() {
        return $this->text;
    }

    function getUrl() {
        return $this->url;
    }

}
