/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PYTHON_WORKSHEET_H__
#define __SG_PYTHON_WORKSHEET_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "sg_python.h"
#include <arrayobject.h>
#include "widgets/sg_worksheet.h"

void sg_python_worksheet_init(void);

int python_insert_object(SGworksheet *worksheet,gint row, gint col,
                         PyObject *object,GtkOrientation orient,
                         gboolean link,gboolean as_is);
                                                                                
int python_sheet(SGworksheet *worksheet,
                 gint row, gint col,
                 gchar *command,
                 GtkOrientation orient);
                                                                                
int python_array        (SGworksheet *worksheet,
                         gint row,
                         gint col,
                         PyArrayObject *object,
                         GtkOrientation orient,
                         gboolean link);
                                                                                
int python_sequence     (SGworksheet *worksheet,
                         gint row, gint col,
                         PyObject *object,
                         GtkOrientation orient,
                         gboolean link,
                         gboolean as_is);
                                                                                
int python_singleton    (SGworksheet *worksheet,
                         gint row, gint col,
                         PyObject *object,
                         gboolean link,
                         gboolean as_is);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PYTHON_WORKSHEET_H__ */
