/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NavigationFilter;
import javax.swing.text.NumberFormatter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JFormattedTextField
extends JTextField {
    private static final long serialVersionUID = 5464657870110180632L;
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private Object value;
    private int focusLostBehavior;
    private AbstractFormatterFactory formatterFactory;
    private AbstractFormatter formatter;
    boolean editValid;

    private final AbstractFormatterFactory getAppropriateFormatterFactory(Format format) {
        InternationalFormatter internationalFormatter = format instanceof DateFormat ? new DateFormatter((DateFormat)format) : (format instanceof NumberFormat ? new NumberFormatter((NumberFormat)format) : new InternationalFormatter(format));
        return new DefaultFormatterFactory(internationalFormatter);
    }

    public void commitEdit() throws ParseException {
        if (this.formatter == null) {
            return;
        }
        Object object = this.value;
        this.value = this.formatter.stringToValue(this.getText());
        this.editValid = true;
        this.firePropertyChange("value", object, this.value);
    }

    public Action[] getActions() {
        return super.getActions();
    }

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public AbstractFormatter getFormatter() {
        return this.formatter;
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public String getUIClassID() {
        return "FormattedTextFieldUI";
    }

    public Object getValue() {
        return this.value;
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.setFormatter(this.formatterFactory.getFormatter(this));
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 == document) {
            return;
        }
        super.setDocument(document);
    }

    public void setFocusLostBehavior(int n) {
        if (n != 0 && n != 1 && n != 3 && n != 2) {
            throw new IllegalArgumentException("invalid behavior");
        }
        this.focusLostBehavior = n;
    }

    protected void setFormatter(AbstractFormatter abstractFormatter) {
        AbstractFormatter abstractFormatter2 = null;
        abstractFormatter2 = this.formatter;
        if (abstractFormatter2 != null) {
            abstractFormatter2.uninstall();
        }
        this.formatter = abstractFormatter;
        if (abstractFormatter != null) {
            abstractFormatter.install(this);
        }
        this.firePropertyChange("formatter", abstractFormatter2, abstractFormatter);
    }

    public void setFormatterFactory(AbstractFormatterFactory abstractFormatterFactory) {
        if (this.formatterFactory == abstractFormatterFactory) {
            return;
        }
        AbstractFormatterFactory abstractFormatterFactory2 = this.formatterFactory;
        this.formatterFactory = abstractFormatterFactory;
        this.firePropertyChange("formatterFactory", abstractFormatterFactory2, abstractFormatterFactory);
        if (this.formatterFactory != null) {
            this.setFormatter(this.formatterFactory.getFormatter(this));
        } else {
            this.setFormatter(null);
        }
    }

    public void setValue(Object object) {
        if (this.value == object) {
            return;
        }
        Object object2 = this.value;
        this.value = object;
        if (this.formatterFactory == null) {
            this.setFormatterFactory(this.createFormatterFactory(object));
        }
        this.setFormatter(this.formatterFactory.getFormatter(this));
        this.firePropertyChange("value", object2, object);
    }

    AbstractFormatterFactory createFormatterFactory(Object object) {
        DefaultFormatter defaultFormatter = null;
        defaultFormatter = object instanceof Date ? new DateFormatter() : (object instanceof Number ? new NumberFormatter() : new DefaultFormatter());
        return new DefaultFormatterFactory(defaultFormatter);
    }

    private final /* synthetic */ void this() {
        this.focusLostBehavior = 1;
        this.editValid = true;
    }

    public JFormattedTextField() {
        this(null, null);
    }

    public JFormattedTextField(Format format) {
        this();
        this.setFormatterFactory(this.getAppropriateFormatterFactory(format));
    }

    public JFormattedTextField(AbstractFormatter abstractFormatter) {
        this(new DefaultFormatterFactory(abstractFormatter));
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory) {
        this.this();
        this.setFormatterFactory(abstractFormatterFactory);
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory, Object object) {
        this.this();
        this.setFormatterFactory(abstractFormatterFactory);
        this.setValue(object);
    }

    public JFormattedTextField(Object object) {
        this.this();
        this.setValue(object);
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private static final long serialVersionUID = -5193212041738979680L;
        private JFormattedTextField textField;

        protected Object clone() throws CloneNotSupportedException {
            AbstractFormatter abstractFormatter = (AbstractFormatter)super.clone();
            abstractFormatter.textField = null;
            return abstractFormatter;
        }

        protected Action[] getActions() {
            return null;
        }

        protected DocumentFilter getDocumentFilter() {
            return null;
        }

        protected JFormattedTextField getFormattedTextField() {
            return this.textField;
        }

        protected NavigationFilter getNavigationFilter() {
            return null;
        }

        public void install(JFormattedTextField jFormattedTextField) {
            if (this.textField != null) {
                this.uninstall();
            }
            this.textField = jFormattedTextField;
            if (jFormattedTextField != null) {
                try {
                    jFormattedTextField.setText(this.valueToString(jFormattedTextField.getValue()));
                    Document document = jFormattedTextField.getDocument();
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).setDocumentFilter(this.getDocumentFilter());
                    }
                    jFormattedTextField.setNavigationFilter(this.getNavigationFilter());
                }
                catch (ParseException parseException) {
                    jFormattedTextField.setText("");
                    this.setEditValid(false);
                }
            }
        }

        public void uninstall() {
            Document document = this.textField.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).setDocumentFilter(null);
            }
            this.textField.setNavigationFilter(null);
            this.textField = null;
        }

        protected void invalidEdit() {
            this.textField.invalidEdit();
        }

        protected void setEditValid(boolean bl) {
            this.textField.editValid = bl;
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }
}

