/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private static final int RC2_IV_LENGTH = 8;
    private int effectiveKeyBits;
    private byte[] iv;

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        byte[] byArray = ((RC2ParameterSpec)object).getIV();
        if (this.iv != byArray) {
            if (this.iv == null || byArray == null) {
                return false;
            }
            if (this.iv.length != byArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.iv.length) {
                if (this.iv[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
        }
        boolean bl = false;
        if (this.effectiveKeyBits == ((RC2ParameterSpec)object).getEffectiveKeyBits()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.effectiveKeyBits;
        if (this.iv != null) {
            int n2 = 0;
            while (n2 < 8) {
                n += this.iv[n2];
                ++n2;
            }
        }
        return n;
    }

    public RC2ParameterSpec(int n) {
        this.effectiveKeyBits = n;
    }

    public RC2ParameterSpec(int n, byte[] byArray) {
        this(n, byArray, 0);
    }

    public RC2ParameterSpec(int n, byte[] byArray, int n2) {
        if (byArray.length - n2 < 8) {
            throw new IllegalArgumentException("IV too short");
        }
        this.effectiveKeyBits = n;
        this.iv = new byte[8];
        System.arraycopy(byArray, n2, this.iv, 0, 8);
    }
}

