/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_ENTRY_H__
#define __SG_ENTRY_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define SG_ENTRY(obj)			GTK_CHECK_CAST (obj, sg_entry_get_type (), SGentry)
#define SG_ENTRY_CLASS(klass)	GTK_CHECK_CLASS_CAST (klass, sg_entry_get_type (), SGentryClass)
#define SG_IS_ENTRY(obj)       GTK_CHECK_TYPE (obj, sg_entry_get_type ())

typedef struct _SGentry		SGentry;
typedef struct _SGentryClass	SGentryClass;

/* you should access only the entry and list fields directly */
struct _SGentry {
	GtkFrame frame;

	GtkWidget *font_combo;
	GtkWidget *subs_button, *super_button, *bold_button, *italic_button;
	GtkWidget *plus_button, *minus_button, *greek_button, *normal_button;
	GtkWidget *spec_button, *spec_box, *spec_canvas, *text_entry;
};

struct _SGentryClass {
	GtkFrameClass parent_class;
};

guint     sg_entry_get_type	(void);
GtkWidget *sg_entry_new		(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_ENTRY_H__ */


