/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.util.ArrayList;
import java.util.List;

public class ArgumentsSplitter {
    public static List<String> split(String arguments) {
        ArrayList<String> commandLineArguments = new ArrayList<String>();
        Character currentQuote = null;
        StringBuilder currentOption = new StringBuilder();
        boolean hasOption = false;
        for (int index = 0; index < arguments.length(); ++index) {
            char c = arguments.charAt(index);
            if (currentQuote == null && Character.isWhitespace(c)) {
                if (!hasOption) continue;
                commandLineArguments.add(currentOption.toString());
                hasOption = false;
                currentOption.setLength(0);
                continue;
            }
            if (currentQuote == null && (c == '\"' || c == '\'')) {
                currentQuote = Character.valueOf(c);
                hasOption = true;
                continue;
            }
            if (currentQuote != null && c == currentQuote.charValue()) {
                currentQuote = null;
                continue;
            }
            currentOption.append(c);
            hasOption = true;
        }
        if (hasOption) {
            commandLineArguments.add(currentOption.toString());
        }
        return commandLineArguments;
    }
}

