/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.configurer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementAdapter;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementDeduplicator;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;

public class EclipseModelAwareUniqueProjectNameProvider
implements UniqueProjectNameProvider {
    private final ProjectStateRegistry projectRegistry;
    private Map<ProjectState, String> deduplicated;
    private List<ProjectStateWrapper> reservedNames = Collections.emptyList();
    private Map<ProjectState, ProjectStateWrapper> projectToInformationMap = Collections.emptyMap();

    public EclipseModelAwareUniqueProjectNameProvider(ProjectStateRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    public synchronized void setReservedProjectNames(List<String> reservedNames) {
        this.reservedNames = reservedNames.stream().map(ProjectStateWrapper::new).collect(Collectors.toList());
        this.deduplicated = null;
    }

    @Override
    public String getUniqueName(Project project) {
        ProjectState state = this.projectRegistry.stateFor(project);
        String uniqueName = this.getDeduplicatedNames().get(state);
        if (uniqueName != null) {
            return uniqueName;
        }
        ProjectStateWrapper information = this.projectToInformationMap.get(state);
        if (information != null) {
            return information.name;
        }
        return state.getName();
    }

    private synchronized Map<ProjectState, String> getDeduplicatedNames() {
        if (this.deduplicated == null) {
            this.projectToInformationMap = new HashMap<ProjectState, ProjectStateWrapper>();
            for (ProjectState state : this.projectRegistry.getAllProjects()) {
                EclipseModel model;
                ProjectInternal project = state.getOwner().getLoadedSettings().getGradle().getRootProject().findProject(state.getComponentIdentifier().getProjectPath());
                if (project != null && (model = (EclipseModel)project.getExtensions().findByType(EclipseModel.class)) != null && model.getProject().getName() != null) {
                    this.projectToInformationMap.put(state, new ProjectStateWrapper(model.getProject().getName(), state, state.getParent()));
                    continue;
                }
                this.projectToInformationMap.put(state, new ProjectStateWrapper(state.getName(), state, state.getParent()));
            }
            HierarchicalElementDeduplicator<ProjectStateWrapper> deduplicator = new HierarchicalElementDeduplicator<ProjectStateWrapper>(new ProjectPathDeduplicationAdapter(this.projectToInformationMap));
            ArrayList<ProjectStateWrapper> allElements = new ArrayList<ProjectStateWrapper>();
            allElements.addAll(this.reservedNames);
            allElements.addAll(this.projectToInformationMap.values());
            this.deduplicated = deduplicator.deduplicate(allElements).entrySet().stream().collect(Collectors.toMap(e -> ((ProjectStateWrapper)e.getKey()).project, Map.Entry::getValue));
        }
        return this.deduplicated;
    }

    private static class ProjectPathDeduplicationAdapter
    implements HierarchicalElementAdapter<ProjectStateWrapper> {
        private final Map<ProjectState, ProjectStateWrapper> projectToInformationMap;

        public ProjectPathDeduplicationAdapter(Map<ProjectState, ProjectStateWrapper> projectToInformationMap) {
            this.projectToInformationMap = projectToInformationMap;
        }

        @Override
        public String getName(ProjectStateWrapper element) {
            return element.name;
        }

        @Override
        public String getIdentityName(ProjectStateWrapper element) {
            return element.name;
        }

        @Override
        public ProjectStateWrapper getParent(ProjectStateWrapper element) {
            return this.projectToInformationMap.get(element.parent);
        }
    }

    private static class ProjectStateWrapper {
        private final String name;
        private final ProjectState project;
        private final ProjectState parent;

        public ProjectStateWrapper(String name, ProjectState project, ProjectState parent) {
            this.name = name;
            this.project = project;
            this.parent = parent;
        }

        public ProjectStateWrapper(String name) {
            this(name, null, null);
        }
    }
}

