/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.AbstractIncompleteFileSystemNode;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.PartialDirectoryNode;
import org.gradle.internal.snapshot.ReadOnlyFileSystemNode;
import org.gradle.internal.snapshot.SingletonChildMap;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.UnknownFileSystemNode;
import org.gradle.internal.snapshot.VfsRelativePath;

public class DefaultSnapshotHierarchy
implements SnapshotHierarchy {
    private final CaseSensitivity caseSensitivity;
    @VisibleForTesting
    final FileSystemNode rootNode;

    public static SnapshotHierarchy from(FileSystemNode rootNode, CaseSensitivity caseSensitivity) {
        return new DefaultSnapshotHierarchy(rootNode, caseSensitivity);
    }

    private DefaultSnapshotHierarchy(FileSystemNode rootNode, CaseSensitivity caseSensitivity) {
        this.caseSensitivity = caseSensitivity;
        this.rootNode = rootNode;
    }

    public static SnapshotHierarchy empty(CaseSensitivity caseSensitivity) {
        switch (caseSensitivity) {
            case CASE_SENSITIVE: {
                return EmptySnapshotHierarchy.CASE_SENSITIVE;
            }
            case CASE_INSENSITIVE: {
                return EmptySnapshotHierarchy.CASE_INSENSITIVE;
            }
        }
        throw new AssertionError((Object)("Unknown case sensitivity: " + (Object)((Object)caseSensitivity)));
    }

    @Override
    public Optional<MetadataSnapshot> getMetadata(String absolutePath) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        if (relativePath.length() == 0) {
            return this.rootNode.getSnapshot();
        }
        return this.rootNode.getSnapshot(relativePath, this.caseSensitivity);
    }

    @Override
    public boolean hasDescendantsUnder(String absolutePath) {
        return this.getNode(absolutePath).hasDescendants();
    }

    @Override
    public SnapshotHierarchy store(String absolutePath, MetadataSnapshot snapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        if (relativePath.length() == 0) {
            return new DefaultSnapshotHierarchy(snapshot.asFileSystemNode(), this.caseSensitivity);
        }
        return new DefaultSnapshotHierarchy(this.rootNode.store(relativePath, this.caseSensitivity, snapshot, diffListener), this.caseSensitivity);
    }

    @Override
    public SnapshotHierarchy invalidate(String absolutePath, SnapshotHierarchy.NodeDiffListener diffListener) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        if (relativePath.length() == 0) {
            diffListener.nodeRemoved(this.rootNode);
            return this.empty();
        }
        return this.rootNode.invalidate(relativePath, this.caseSensitivity, diffListener).map(it -> new DefaultSnapshotHierarchy((FileSystemNode)it, this.caseSensitivity)).orElseGet(() -> DefaultSnapshotHierarchy.empty(this.caseSensitivity));
    }

    @Override
    public SnapshotHierarchy empty() {
        return DefaultSnapshotHierarchy.empty(this.caseSensitivity);
    }

    @Override
    public void visitSnapshotRoots(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        this.rootNode.accept(snapshotVisitor);
    }

    @Override
    public void visitSnapshotRoots(String absolutePath, SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        this.getNode(absolutePath).accept(snapshotVisitor);
    }

    private ReadOnlyFileSystemNode getNode(String absolutePath) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        return relativePath.length() == 0 ? this.rootNode : this.rootNode.getNode(relativePath, this.caseSensitivity);
    }

    private static enum EmptySnapshotHierarchy implements SnapshotHierarchy
    {
        CASE_SENSITIVE(CaseSensitivity.CASE_SENSITIVE),
        CASE_INSENSITIVE(CaseSensitivity.CASE_INSENSITIVE);

        private final CaseSensitivity caseSensitivity;

        private EmptySnapshotHierarchy(CaseSensitivity caseInsensitive) {
            this.caseSensitivity = caseInsensitive;
        }

        @Override
        public Optional<MetadataSnapshot> getMetadata(String absolutePath) {
            return Optional.empty();
        }

        @Override
        public boolean hasDescendantsUnder(String absolutePath) {
            return false;
        }

        @Override
        public SnapshotHierarchy store(String absolutePath, MetadataSnapshot snapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
            VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
            String childPath = relativePath.getAsString();
            SingletonChildMap<FileSystemNode> children = new SingletonChildMap<FileSystemNode>(childPath, snapshot.asFileSystemNode());
            AbstractIncompleteFileSystemNode rootNode = snapshot.getType() == FileType.Missing ? new UnknownFileSystemNode(children) : new PartialDirectoryNode(children);
            diffListener.nodeAdded(rootNode);
            return DefaultSnapshotHierarchy.from(rootNode, this.caseSensitivity);
        }

        @Override
        public SnapshotHierarchy invalidate(String absolutePath, SnapshotHierarchy.NodeDiffListener diffListener) {
            return this;
        }

        @Override
        public SnapshotHierarchy empty() {
            return this;
        }

        @Override
        public void visitSnapshotRoots(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        }

        @Override
        public void visitSnapshotRoots(String absolutePath, SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        }
    }
}

