/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.util.Path;

class DefaultRootBuildState
extends AbstractCompositeParticipantBuildState
implements RootBuildState,
Stoppable {
    private final ListenerManager listenerManager;
    private final GradleLauncher gradleLauncher;

    DefaultRootBuildState(BuildDefinition buildDefinition, GradleLauncherFactory gradleLauncherFactory, ListenerManager listenerManager, BuildTreeState owner) {
        this.listenerManager = listenerManager;
        this.gradleLauncher = gradleLauncherFactory.newInstance(buildDefinition, (RootBuildState)this, owner);
    }

    public BuildIdentifier getBuildIdentifier() {
        return DefaultBuildIdentifier.ROOT;
    }

    public Path getIdentityPath() {
        return Path.ROOT;
    }

    public boolean isImplicitBuild() {
        return false;
    }

    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
    }

    public File getBuildRootDir() {
        return this.gradleLauncher.getBuildRootDir();
    }

    public void stop() {
        this.gradleLauncher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Transformer<T, ? super BuildController> buildAction) {
        GradleBuildController buildController = new GradleBuildController(this.gradleLauncher);
        RootBuildLifecycleListener buildLifecycleListener = (RootBuildLifecycleListener)this.listenerManager.getBroadcaster(RootBuildLifecycleListener.class);
        GradleInternal gradle = buildController.getGradle();
        buildLifecycleListener.afterStart(gradle);
        try {
            Object object = buildAction.transform((Object)buildController);
            return (T)object;
        }
        finally {
            buildLifecycleListener.beforeComplete(gradle);
        }
    }

    public StartParameter getStartParameter() {
        return this.gradleLauncher.getGradle().getStartParameter();
    }

    public SettingsInternal getLoadedSettings() {
        return this.gradleLauncher.getGradle().getSettings();
    }

    public NestedBuildFactory getNestedBuildFactory() {
        return (NestedBuildFactory)this.gradleLauncher.getGradle().getServices().get(NestedBuildFactory.class);
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return Path.ROOT;
    }

    public Path getIdentityPathForProject(Path path) {
        return path;
    }

    public GradleInternal getBuild() {
        return this.gradleLauncher.getGradle();
    }
}

