/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

public enum HDF5StorageLayout {
    COMPACT(HDF5Constants.H5D_COMPACT),
    CONTIGUOUS(HDF5Constants.H5D_CONTIGUOUS),
    CHUNKED(HDF5Constants.H5D_CHUNKED),
    NOT_APPLICABLE(-1);

    private int id;

    private HDF5StorageLayout(int id) {
        this.id = id;
    }

    static HDF5StorageLayout fromId(int id) throws IllegalArgumentException {
        HDF5StorageLayout[] hDF5StorageLayoutArray = HDF5StorageLayout.values();
        int n = hDF5StorageLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5StorageLayout layout = hDF5StorageLayoutArray[n2];
            if (layout.id == id) {
                return layout;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Illegal layout id " + id);
    }
}

