package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;
import java.util.*;

import itunes.FieldPair;
import org.cdavies.itunes.Database;
import org.cdavies.itunes.hash.*;
import org.cdavies.itunes.*;

public class LegacyTracklistRequest extends LegacyDatabaseRequest implements TracklistRequest {
	
	private Track[] _tracks;
	private int _dbId;
	
	public LegacyTracklistRequest(String server, int port, int sessionId, int dbId) {
		
		super(server, port, sessionId);
		
		requestString = "databases/"+dbId+"/items?session-id="+sessionId+"&meta=dmap.itemid,dmap.itemname,daap.songalbum,daap.songartist,daap.songtracknumber,daap.songuserrating,daap.songgenre,daap.songformat,daap.songtime";
		_dbId = dbId;
		
	}
	
	public void process() throws NoServerPermissionException {
		
		if (data.length==0) {
			return;
		}
		
		dataType= dataString(4);
		offset += 4;
		int _size = dataInt();
		offset += 4;
		
		fieldPairs = processDataFields();
		
		parseMLCL();
		
		_tracks = new Track[mlitDataFields.size()];
		
		for (int _i = 0; _i < mlitDataFields.size(); _i++) {
			
			ArrayList _fps = ((ArrayList)mlitDataFields.get(_i));
			
			Track _t = new Itunes4Track();
			
			for (int _j = 0; _j < _fps.size(); _j++) {
				
				FieldPair _fp = ((FieldPair)_fps.get(_j));
				
				if (_fp.name.equals("miid"))
					_t.setTrackId(Request.readInt(_fp.value, 0, 4));
				else if (_fp.name.equals("minm"))
					_t.setTrackName(Request.readString(_fp.value, 0, _fp.value.length));
				else if (_fp.name.equals("asal"))
					_t.setAlbumName(Request.readString(_fp.value, 0, _fp.value.length));
				else if (_fp.name.equals("asar"))
					_t.setArtistName(Request.readString(_fp.value, 0, _fp.value.length));
				else if (_fp.name.equals("astn"))
					_t.setTrackNumber(Request.readInt(_fp.value, 0, 2));
				else if (_fp.name.equals("asgn"))
					_t.setGenre(Request.readString(_fp.value, 0, _fp.value.length));
				else if (_fp.name.equals("asur"))
					_t.setRating(Request.readInt(_fp.value, 0, 1));
				else if (_fp.name.equals("asfm"))
					_t.setFormat(Request.readString(_fp.value, 0, _fp.value.length));
				else if (_fp.name.equals("astm"))
					_t.setLength(Request.readInt(_fp.value, 0, 4));	
				
			}
			
			_t.setDatabaseId(_dbId);
			_tracks[_i] = _t;
		}
		
	}
	
	public Track[] getTracklist() {
		
		return _tracks;
		
	}
	
	
}
