/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v1;

import org.apache.activemq.apollo.openwire.codec.DataStreamMarshaller;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQBytesMessageMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQMapMessageMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQMessageMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQObjectMessageMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQQueueMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQStreamMessageMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQTempQueueMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQTempTopicMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQTextMessageMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ActiveMQTopicMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.BrokerIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.BrokerInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConnectionControlMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConnectionErrorMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConnectionIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConnectionInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConsumerControlMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConsumerIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ConsumerInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ControlCommandMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.DataArrayResponseMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.DataResponseMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.DestinationInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.DiscoveryEventMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ExceptionResponseMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.FlushCommandMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.IntegerResponseMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.KeepAliveInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.LastPartialCommandMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.LocalTransactionIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.MessageAckMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.MessageDispatchMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.MessageDispatchNotificationMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.MessageIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.NetworkBridgeFilterMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.PartialCommandMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ProducerIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ProducerInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.RemoveInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.RemoveSubscriptionInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ReplayCommandMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ResponseMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.SessionIdMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.SessionInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.ShutdownInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.SubscriptionInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.TransactionInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.WireFormatInfoMarshaller;
import org.apache.activemq.apollo.openwire.codec.v1.XATransactionIdMarshaller;

public class MarshallerFactory {
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new ActiveMQBytesMessageMarshaller());
        MarshallerFactory.add(new ActiveMQMapMessageMarshaller());
        MarshallerFactory.add(new ActiveMQMessageMarshaller());
        MarshallerFactory.add(new ActiveMQObjectMessageMarshaller());
        MarshallerFactory.add(new ActiveMQQueueMarshaller());
        MarshallerFactory.add(new ActiveMQStreamMessageMarshaller());
        MarshallerFactory.add(new ActiveMQTempQueueMarshaller());
        MarshallerFactory.add(new ActiveMQTempTopicMarshaller());
        MarshallerFactory.add(new ActiveMQTextMessageMarshaller());
        MarshallerFactory.add(new ActiveMQTopicMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
    }
}

