######################################################################
### This function export the setup into an export file
######################################################################
proc export {filename} {
  global __OUTPUT __progList __hash __language
  startBusy "$__language(export,3)..."
  set __OUTPUT [open $filename w]

  set count [llength $__progList]
  timeWindow $count $__language(export,3) "$__language(export,2)\n$filename"
  
  foreach function $__progList {
    puts $__OUTPUT $__hash
    puts $__OUTPUT "\#\#\# $function"
    puts $__OUTPUT $__hash
    puts $__OUTPUT "PAGE $function"
    export_func $function top 2 __$function ""
    incrTimeWindow
  }
  close $__OUTPUT
  destroyTimeWindow
  endBusy
}

######################################################################
### This function export variables to a given function, from a given
### top. 'level' indicated the indentation level in the file
######################################################################
proc export_func {function top level prefix defaultVal} {
  global __children __widgetArgs __OUTPUT
  set index 0
  foreach child $__children(${function}__$top) {
    set type $__widgetArgs(${function}__${child}__type)

    if {$type == "line" || $type == "header"} continue
    set subCount [noOfVariableChildren $function $child]
    if {$subCount != 1} {
      set default [lrange $defaultVal $index [expr $index+ $subCount -1]]
    } else {
      set default [lindex $defaultVal $index]
    }
    incr index $subCount
    if {$default == ""} {
      set default $__widgetArgs(${function}__${child}__default)
    }

    if {!$__widgetArgs(${function}__${child}__export)} continue

    switch $type {
      checkbox -
      entry -
      int -
      float -
      textbox -
      menu  -
      combobox -
      label -
      command {
        upvar \#0 ${prefix}_$child variable
        if {$variable != $default} {
          puts $__OUTPUT \
              "[space $level][upCase $type] $child \"[escape* $variable]\""
        }
      }
      radio {
        set entries $__widgetArgs(${function}__${child}__entries)
        upvar \#0 ${prefix}_$child variable
        if {[lindex $entries $variable] != $default} {
          set txt [lindex $entries $variable]
          puts $__OUTPUT \
              "[space $level][upCase $type] $child \"[escape* $txt]\""
        }
      }
      listbox {
        upvar \#0 ${prefix}_$child variable
        set list ""
        foreach elm $variable {
          set txt \
              [lindex $__widgetArgs(${function}__${child}__entries) $elm]
          lappend list [escape* $txt]
        }
        puts $__OUTPUT \
            "[space $level][upCase $type] $child \"$list\""
      }
      extentry {
        export_extentry $function $level $prefix $child ""
      }
      frame -
      window {
        export_func $function $child $level $prefix $default
      }
      fillout {
        export_fillout $function $level $prefix $child
      }
    }
  }
}

######################################################################
### This function exports an ExtenTry
######################################################################
proc export_extentry {function level prefix name default} {
  global __widgetArgs __scrollBar __OUTPUT

  set count [lindex $__scrollBar(${prefix}_$name) 1]
  if {$count != 0} {
    puts $__OUTPUT "[space $level]EXTENTRY $name"
    for {set i 0} {$i < $count} {incr i} {
      puts $__OUTPUT "[space $level]\{"
      export_func $function $name [expr $level+2] ${prefix}_$name$i \
          [lindex $default $i]
      puts $__OUTPUT "[space $level]\}"
    }
  }
}

######################################################################
### This function export a FillOut
######################################################################
proc export_fillout {function level prefix name} {
  global __fillList __OUTPUT

  puts $__OUTPUT "[space $level]FILLOUT $name \{"

  set last -1
  incr level 2
  upvar \#0 ${prefix}_$name variable
  foreach filloutelm $__fillList(${prefix}_$name) {
    set start [lindex $filloutelm 0]
    set end [lindex $filloutelm 1]
    set elmName [lindex $filloutelm 2]
    set counter [lindex $filloutelm 3]
    if {$last < $start-1} {
      set text [string range $variable [expr $last+1] [expr $start-1]]
      puts $__OUTPUT \
          "[space $level]TEXT \"[escape* $text]\""
    }
    set last $end
    if {$counter == -1} {
      puts $__OUTPUT "[space $level]FILLOUTELM $elmName {}"
    } else {
      puts $__OUTPUT "[space $level]FILLOUTELM $elmName \{"
      export_func $function $elmName [expr $level+2] \
          ${prefix}_${name}_$counter ""
      puts $__OUTPUT "[space $level]\}"
    }
  }
  
  if {$last < [string length $variable]} {
    puts $__OUTPUT \
        "[space $level]TEXT \"[escape* [string range $variable [expr $last+1] end]]\""
  }

  puts $__OUTPUT "[space [expr $level-2]]\}"
}

############################################################
# This function escapes every control chars for the
# export file
############################################################  
proc escape* {string} {
  global tcl_version
  if {$tcl_version < 8.1} {
    regsub -all {[\"{}]} $string \\\\\\0 result
  } else {
    regsub -all {[\\"\{\}]} $string \\\\\\0 result
  }
  return $result
}
