/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.BreakIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class Utilities {
    private static final int BUF_LENGTH = 64;

    public static final int drawTabbedText(Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        char[] buffer = s.array;
        int pixelX = x;
        int pixelY = y;
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        int pixelWidth = 0;
        int pos = s.offset;
        int len = 0;
        int offset = s.offset;
        while (offset < s.offset + s.count) {
            char c = buffer[offset];
            if (c == '\t' || c == '\n') {
                if (len > 0) {
                    g.drawChars(buffer, pos, len, pixelX, pixelY + ascent);
                    pixelX += pixelWidth;
                    pixelWidth = 0;
                }
                pos = offset + 1;
                len = 0;
            }
            switch (c) {
                case '\t': {
                    if (e != null) {
                        pixelX = (int)e.nextTabStop(pixelX, startOffset + offset - s.offset);
                        break;
                    }
                    pixelX += metrics.charWidth(' ');
                    break;
                }
                case '\n': {
                    pixelY += metrics.getHeight();
                    pixelX = x;
                    break;
                }
                default: {
                    ++len;
                    pixelWidth += metrics.charWidth(buffer[offset]);
                    break;
                }
            }
            ++offset;
        }
        if (len > 0) {
            g.drawChars(buffer, pos, len, pixelX, pixelY + ascent);
        }
        return pixelX;
    }

    public static final int getTabbedTextWidth(Segment s, FontMetrics metrics, int x, TabExpander e, int startOffset) {
        char[] buffer = s.array;
        int pixelX = x;
        int maxWidth = 0;
        int offset = s.offset;
        while (offset < s.offset + s.count) {
            switch (buffer[offset]) {
                case '\t': {
                    if (e != null) {
                        pixelX = (int)e.nextTabStop(pixelX, startOffset + offset - s.offset);
                        break;
                    }
                    pixelX += metrics.charWidth(' ');
                    break;
                }
                case '\n': {
                    maxWidth = Math.max(maxWidth, (pixelX += metrics.charWidth(buffer[offset])) - x);
                    pixelX = x;
                    break;
                }
                default: {
                    pixelX += metrics.charWidth(buffer[offset]);
                    break;
                }
            }
            ++offset;
        }
        maxWidth = Math.max(maxWidth, pixelX - x);
        return maxWidth;
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics fm, int x0, int x, TabExpander te, int p0, boolean round) {
        int currentX = x0;
        int pos = p0;
        while (pos < s.count) {
            char nextChar = s.array[s.offset + pos];
            if (nextChar == '\u0000') {
                if (round) break;
                --pos;
                break;
            }
            currentX = nextChar != '\t' ? (currentX += fm.charWidth(nextChar)) : (te == null ? (currentX += fm.charWidth(' ')) : (int)te.nextTabStop(currentX, pos));
            if (currentX > x) {
                if (round) break;
                --pos;
                break;
            }
            ++pos;
        }
        return pos;
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics fm, int x0, int x, TabExpander te, int p0) {
        return Utilities.getTabbedTextOffset(s, fm, x0, x, te, p0, true);
    }

    public static final int getNextWord(JTextComponent c, int offs) throws BadLocationException {
        if (offs < 0 || offs > c.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        String text = c.getText();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        int last = wb.following(offs);
        int current = wb.next();
        while (current != -1) {
            int i = last;
            while (i < current) {
                if (Character.isLetter(text.charAt(i))) {
                    return last;
                }
                ++i;
            }
            last = current;
            current = wb.next();
        }
        return -1;
    }

    public static final int getPreviousWord(JTextComponent c, int offs) throws BadLocationException {
        if (offs < 0 || offs > c.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        String text = c.getText();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        int last = wb.preceding(offs);
        int current = wb.previous();
        while (current != -1) {
            int i = last;
            while (i < offs) {
                if (Character.isLetter(text.charAt(i))) {
                    return last;
                }
                ++i;
            }
            last = current;
            current = wb.previous();
        }
        return 0;
    }

    public static final int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        if (offs < 0 || offs >= c.getText().length()) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        String text = c.getText();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        if (wb.isBoundary(offs)) {
            return offs;
        }
        return wb.preceding(offs);
    }

    public static final int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        if (offs < 0 || offs >= c.getText().length()) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        String text = c.getText();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        return wb.following(offs);
    }

    public static final int getRowEnd(JTextComponent c, int offs) throws BadLocationException {
        String text = c.getText();
        if (text == null) {
            return -1;
        }
        int high = offs + (text.length() - 1 - offs) / 2;
        int low = offs;
        int oldHigh = text.length() + 1;
        while (true) {
            if (c.modelToView((int)high).y != c.modelToView((int)offs).y) {
                oldHigh = high;
                if (oldHigh != (high = low + (high + 1 - low) / 2)) continue;
                return high - 1;
            }
            low = high;
            if (low == (high += (oldHigh - high) / 2)) break;
        }
        return low;
    }

    public static final int getRowStart(JTextComponent c, int offs) throws BadLocationException {
        String text = c.getText();
        if (text == null) {
            return -1;
        }
        int high = offs;
        int low = 0;
        int oldLow = 0;
        while (true) {
            if (c.modelToView((int)low).y != c.modelToView((int)offs).y) {
                oldLow = low;
                if (oldLow != (low = high - (high + 1 - low) / 2)) continue;
                return low + 1;
            }
            if ((low -= (low - oldLow) / 2) == (high = low)) break;
        }
        return low;
    }

    public static final int getBreakLocation(Segment s, FontMetrics metrics, int x0, int x, TabExpander e, int startOffset) {
        int mark = Utilities.getTabbedTextOffset(s, metrics, x0, x, e, startOffset);
        BreakIterator breaker = BreakIterator.getWordInstance();
        breaker.setText(s.toString());
        if (mark == s.count) {
            return mark;
        }
        int preceding = breaker.preceding(mark + 1);
        if (preceding != 0) {
            return preceding;
        }
        return mark;
    }
}

