/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component center;
    private Component firstLine;
    private Component lastLine;
    private Component firstItem;
    private Component lastItem;
    private int hgap;
    private int vgap;

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("Constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, component);
    }

    public void addLayoutComponent(String constraints, Component component) {
        String str = constraints;
        if (str == null || str.equals(CENTER)) {
            this.center = component;
        } else if (str.equals(NORTH)) {
            this.north = component;
        } else if (str.equals(SOUTH)) {
            this.south = component;
        } else if (str.equals(EAST)) {
            this.east = component;
        } else if (str.equals(WEST)) {
            this.west = component;
        } else if (str.equals("First")) {
            this.firstLine = component;
        } else if (str.equals("Last")) {
            this.lastLine = component;
        } else if (str.equals("Before")) {
            this.firstItem = component;
        } else if (str.equals("After")) {
            this.lastItem = component;
        } else {
            throw new IllegalArgumentException("Constraint value not valid: " + str);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.north == component) {
            this.north = null;
        }
        if (this.south == component) {
            this.south = null;
        }
        if (this.east == component) {
            this.east = null;
        }
        if (this.west == component) {
            this.west = null;
        }
        if (this.center == component) {
            this.center = null;
        }
        if (this.firstItem == component) {
            this.firstItem = null;
        }
        if (this.lastItem == component) {
            this.lastItem = null;
        }
        if (this.firstLine == component) {
            this.firstLine = null;
        }
        if (this.lastLine == component) {
            this.lastLine = null;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.calcSize(target, 0);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.calcSize(target, 2);
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.calcSize(target, 1);
    }

    public float getLayoutAlignmentX(Container parent) {
        return parent.getAlignmentX();
    }

    public float getLayoutAlignmentY(Container parent) {
        return parent.getAlignmentY();
    }

    public void invalidateLayout(Container parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int x3;
            Component my_west;
            Component my_south;
            Component my_east;
            Component my_north;
            boolean left_to_right;
            Insets i;
            block15: {
                block16: {
                    i = target.getInsets();
                    ComponentOrientation orient = target.getComponentOrientation();
                    left_to_right = orient.isLeftToRight();
                    my_north = this.north;
                    my_east = this.east;
                    my_south = this.south;
                    my_west = this.west;
                    if (this.firstLine != null) {
                        my_north = this.firstLine;
                    }
                    if (this.lastLine != null) {
                        my_south = this.lastLine;
                    }
                    if (this.firstItem == null) break block15;
                    if (!left_to_right) break block16;
                    my_west = this.firstItem;
                    break block15;
                }
                my_east = this.firstItem;
            }
            if (this.lastItem != null) {
                if (left_to_right) {
                    my_east = this.lastItem;
                } else {
                    my_west = this.lastItem;
                }
            }
            Dimension c = this.calcCompSize(this.center, 2);
            Dimension n = this.calcCompSize(my_north, 2);
            Dimension s = this.calcCompSize(my_south, 2);
            Dimension e = this.calcCompSize(my_east, 2);
            Dimension w = this.calcCompSize(my_west, 2);
            int targetWidth = target.getWidth();
            int targetHeight = target.getHeight();
            int x1 = i.left;
            int n2 = x1 + w.width;
            int n3 = 0;
            if (w.width != 0) {
                n3 = this.hgap;
            }
            int x2 = n2 + n3;
            if (targetWidth <= i.right + e.width) {
                int n4 = x2 + w.width;
                int n5 = 0;
                if (w.width != 0) {
                    n5 = this.hgap;
                }
                x3 = n4 + n5;
            } else {
                x3 = targetWidth - i.right - e.width;
            }
            int ww = targetWidth - i.right - i.left;
            int y1 = i.top;
            int n6 = y1 + n.height;
            int n7 = 0;
            if (n.height != 0) {
                n7 = this.vgap;
            }
            int y2 = n6 + n7;
            int midh = Math.max(e.height, Math.max(w.height, c.height));
            int y3 = targetHeight <= i.bottom + s.height ? y2 + midh + this.vgap : targetHeight - i.bottom - s.height;
            int n8 = 0;
            if (s.height != 0) {
                n8 = this.vgap;
            }
            int hh = y3 - y2 - n8;
            int n9 = 0;
            if (w.width != 0) {
                n9 = this.hgap;
            }
            this.setBounds(this.center, x2, y2, x3 - x2 - n9, hh);
            this.setBounds(my_north, x1, y1, ww, n.height);
            this.setBounds(my_south, x1, y3, ww, s.height);
            this.setBounds(my_west, x1, y2, w.width, hh);
            this.setBounds(my_east, x3, y2, e.width, hh);
            return;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ']';
    }

    private final void setBounds(Component comp, int x, int y, int w, int h) {
        if (comp == null) {
            return;
        }
        comp.setBounds(x, y, w, h);
    }

    private final Dimension calcCompSize(Component comp, int what) {
        if (comp == null || !comp.isVisible()) {
            return new Dimension(0, 0);
        }
        if (what == 0) {
            return comp.getMinimumSize();
        }
        if (what == 1) {
            return comp.getMaximumSize();
        }
        return comp.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Dimension calcSize(Container target, int what) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int addedHeight;
            Component my_west;
            Component my_south;
            Component my_east;
            Component my_north;
            boolean left_to_right;
            Insets ins;
            block13: {
                block14: {
                    ins = target.getInsets();
                    ComponentOrientation orient = target.getComponentOrientation();
                    left_to_right = orient.isLeftToRight();
                    my_north = this.north;
                    my_east = this.east;
                    my_south = this.south;
                    my_west = this.west;
                    if (this.firstLine != null) {
                        my_north = this.firstLine;
                    }
                    if (this.lastLine != null) {
                        my_south = this.lastLine;
                    }
                    if (this.firstItem == null) break block13;
                    if (!left_to_right) break block14;
                    my_west = this.firstItem;
                    break block13;
                }
                my_east = this.firstItem;
            }
            if (this.lastItem != null) {
                if (left_to_right) {
                    my_east = this.lastItem;
                } else {
                    my_west = this.lastItem;
                }
            }
            Dimension ndim = this.calcCompSize(my_north, what);
            Dimension sdim = this.calcCompSize(my_south, what);
            Dimension edim = this.calcCompSize(my_east, what);
            Dimension wdim = this.calcCompSize(my_west, what);
            Dimension cdim = this.calcCompSize(this.center, what);
            int width = edim.width + cdim.width + wdim.width + this.hgap * 2;
            if (width < edim.width || width < cdim.width || width < cdim.width) {
                width = Integer.MAX_VALUE;
            }
            if (ndim.width > width) {
                width = ndim.width;
            }
            if (sdim.width > width) {
                width = sdim.width;
            }
            width += ins.left + ins.right;
            int height = edim.height;
            if (cdim.height > height) {
                height = cdim.height;
            }
            if (wdim.height > height) {
                height = wdim.height;
            }
            height = (addedHeight = height + (ndim.height + sdim.height + this.vgap * 2 + ins.top + ins.bottom)) < height ? Integer.MAX_VALUE : addedHeight;
            return new Dimension(width, height);
        }
    }

    public Component getLayoutComponent(Object constraints) {
        if (constraints == CENTER) {
            return this.center;
        }
        if (constraints == NORTH) {
            return this.north;
        }
        if (constraints == EAST) {
            return this.east;
        }
        if (constraints == SOUTH) {
            return this.south;
        }
        if (constraints == WEST) {
            return this.west;
        }
        if (constraints == "First") {
            return this.firstLine;
        }
        if (constraints == "Last") {
            return this.lastLine;
        }
        if (constraints == "Before") {
            return this.firstItem;
        }
        if (constraints == "After") {
            return this.lastItem;
        }
        throw new IllegalArgumentException("constraint " + constraints + " is not recognized");
    }

    public Component getLayoutComponent(Container container, Object constraints) {
        ComponentOrientation orient = container.getComponentOrientation();
        if (constraints == CENTER) {
            return this.center;
        }
        if (constraints == NORTH) {
            return this.north;
        }
        if (constraints == SOUTH) {
            return this.south;
        }
        if (constraints == WEST) {
            if (orient.isLeftToRight()) {
                return this.firstItem == null ? this.west : this.firstItem;
            }
            return this.lastItem == null ? this.west : this.lastItem;
        }
        if (constraints == EAST) {
            if (orient.isLeftToRight()) {
                return this.lastItem == null ? this.east : this.lastItem;
            }
            return this.firstItem == null ? this.east : this.firstItem;
        }
        throw new IllegalArgumentException("constraint " + constraints + " is not recognized");
    }

    public Object getConstraints(Component c) {
        if (c == null) {
            return null;
        }
        if (c == this.center) {
            return CENTER;
        }
        if (c == this.north) {
            return NORTH;
        }
        if (c == this.east) {
            return EAST;
        }
        if (c == this.south) {
            return SOUTH;
        }
        if (c == this.west) {
            return WEST;
        }
        if (c == this.firstLine) {
            return "First";
        }
        if (c == this.lastLine) {
            return "Last";
        }
        if (c == this.firstItem) {
            return "Before";
        }
        if (c == this.lastItem) {
            return "After";
        }
        return null;
    }

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }
}

