/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.BigDecimalHelper;
import gnu.CORBA.CDR.AbstractDataOutput;
import gnu.CORBA.CDR.BigEndianOutputStream;
import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.EncapsulationStream;
import gnu.CORBA.CDR.LittleEndianOutputStream;
import gnu.CORBA.CDR.gnuRuntime;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.IOR;
import gnu.CORBA.IorProvider;
import gnu.CORBA.TypeCodeHelper;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.CORBA.typecodes.PrimitiveTypeCode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractCdrOutput
extends org.omg.CORBA_2_3.portable.OutputStream
implements DataOutputStream {
    public transient gnuRuntime runtime;
    protected AbstractDataOutput b;
    protected ORB orb;
    protected Version giop;
    protected CodeSetServiceContext codeset;
    private String narrow_charset;
    private String wide_charset;
    private boolean narrow_native;
    private boolean wide_native;
    private boolean little_endian;
    private OutputStream actual_stream;

    public abstract void setOffset(int var1);

    public void cloneSettings(AbstractCdrOutput stream) {
        stream.setBigEndian(this.little_endian ^ true);
        stream.setCodeSet(this.getCodeSet());
        stream.setVersion(this.giop);
        stream.setOrb(this.orb);
    }

    public void setCodeSet(CodeSetServiceContext a_codeset) {
        this.codeset = a_codeset;
        this.narrow_charset = CharSets_OSF.getName(this.codeset.char_data);
        this.wide_charset = CharSets_OSF.getName(this.codeset.wide_char_data);
        boolean bl = false;
        if (65537 == this.codeset.char_data) {
            bl = true;
        }
        this.narrow_native = bl;
        boolean bl2 = false;
        if (65801 == this.codeset.wide_char_data) {
            bl2 = true;
        }
        this.wide_native = bl2;
    }

    public CodeSetServiceContext getCodeSet() {
        return this.codeset;
    }

    public void setOrb(ORB an_orb) {
        this.orb = an_orb;
    }

    public void setOutputStream(OutputStream writeTo) {
        this.b = this.little_endian ? new LittleEndianOutputStream(writeTo) : new BigEndianOutputStream(writeTo);
        this.actual_stream = writeTo;
    }

    public void setVersion(Version giop_version) {
        this.giop = giop_version;
    }

    public void setBigEndian(boolean use_big_endian) {
        this.little_endian = use_big_endian ^ true;
        this.setOutputStream(this.actual_stream);
    }

    public abstract void align(int var1);

    public AbstractCdrOutput createEncapsulation() {
        return new EncapsulationStream(this, this.little_endian ^ true);
    }

    public ORB orb() {
        return this.orb;
    }

    public void write(int n) {
        try {
            this.b.write(n);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write(byte[] x) throws IOException {
        this.b.write(x);
    }

    public void write(byte[] x, int ofs, int len) throws IOException {
        this.b.write(x, ofs, len);
    }

    public void write_Context(Context context, ContextList contexts) {
        throw new NO_IMPLEMENT();
    }

    public void write_Object(Object x) {
        ORB w_orb = this.orb;
        if (x instanceof IorProvider) {
            ((IorProvider)((java.lang.Object)x)).getIor()._write_no_endian(this);
            return;
        }
        if (x == null) {
            IOR.write_null(this);
            return;
        }
        if (x instanceof ObjectImpl) {
            Delegate d = ((ObjectImpl)x)._get_delegate();
            if (d instanceof IorProvider) {
                ((IorProvider)((java.lang.Object)d)).getIor()._write_no_endian(this);
                return;
            }
            ORB d_orb = d.orb(x);
            if (d_orb != null) {
                w_orb = d_orb;
            }
        }
        if (w_orb != null) {
            IOR ior = IOR.parse(w_orb.object_to_string(x));
            ior._write_no_endian(this);
            return;
        }
        throw new BAD_OPERATION("Please set the ORB for this stream, cannot write " + x.getClass().getName());
    }

    public void write_TypeCode(TypeCode x) {
        try {
            TypeCodeHelper.write(this, x);
        }
        catch (UserException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_any(Any x) {
        Streamable value = x.extract_Streamable();
        if (value != null) {
            this.write_TypeCode(x.type());
            value._write(this);
        } else {
            PrimitiveTypeCode p = new PrimitiveTypeCode(TCKind.tk_null);
            this.write_TypeCode(p);
        }
    }

    public void write_boolean(boolean x) {
        try {
            this.b.write(x ? 1 : 0);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_boolean_array(boolean[] x, int ofs, int len) {
        try {
            int i = ofs;
            while (i < ofs + len) {
                this.b.write(x[i]);
                ++i;
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_char(char x) {
        try {
            if (this.narrow_native) {
                this.b.write(x);
            } else {
                OutputStreamWriter ow = new OutputStreamWriter((OutputStream)((org.omg.CORBA.portable.OutputStream)((java.lang.Object)this.b)), this.narrow_charset);
                ow.write(x);
                ow.flush();
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_char_array(char[] chars, int offset, int length) {
        try {
            if (this.narrow_native) {
                int i = offset;
                while (i < offset + length) {
                    this.b.write(chars[i]);
                    ++i;
                }
            } else {
                OutputStreamWriter ow = new OutputStreamWriter((OutputStream)((org.omg.CORBA.portable.OutputStream)((java.lang.Object)this.b)), this.narrow_charset);
                ow.write(chars, offset, length);
                ow.flush();
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_double(double x) {
        try {
            this.align(8);
            this.b.writeDouble(x);
        }
        catch (Exception ex) {
            Unexpected.error(ex);
        }
    }

    public void write_double_array(double[] x, int ofs, int len) {
        try {
            this.align(8);
            int i = ofs;
            while (i < ofs + len) {
                this.b.writeDouble(x[i]);
                ++i;
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_fixed(BigDecimal fixed) {
        try {
            BigDecimalHelper.write(this, fixed);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
        catch (BadKind ex) {
            Unexpected.error(ex);
        }
    }

    public void write_float(float x) {
        try {
            this.align(4);
            this.b.writeFloat(x);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_float_array(float[] x, int ofs, int len) {
        try {
            this.align(4);
            int i = ofs;
            while (i < ofs + len) {
                this.b.writeFloat(x[i]);
                ++i;
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_long(int x) {
        try {
            this.align(4);
            this.b.writeInt(x);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_long_array(int[] x, int ofs, int len) {
        try {
            this.align(4);
            int i = ofs;
            while (i < ofs + len) {
                this.b.writeInt(x[i]);
                ++i;
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_longlong(long x) {
        try {
            this.align(8);
            this.b.writeLong(x);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_longlong_array(long[] x, int ofs, int len) {
        try {
            this.align(8);
            int i = ofs;
            while (i < ofs + len) {
                this.b.writeLong(x[i]);
                ++i;
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_octet(byte x) {
        try {
            this.b.writeByte(x);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_octet_array(byte[] x, int ofs, int len) {
        try {
            this.b.write(x, ofs, len);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_sequence(byte[] buf) {
        try {
            this.write_long(buf.length);
            this.write(buf);
        }
        catch (IOException ex) {
            MARSHAL t = new MARSHAL();
            t.minor = 1195573253;
            t.initCause(ex);
            throw t;
        }
    }

    public void write_sequence(BufferedCdrOutput from) {
        try {
            this.write_long(from.buffer.size());
            from.buffer.writeTo(this);
        }
        catch (IOException ex) {
            MARSHAL t = new MARSHAL();
            t.minor = 1195573253;
            t.initCause(ex);
            throw t;
        }
    }

    public void write_short(short x) {
        try {
            this.align(2);
            this.b.writeShort(x);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_short_array(short[] x, int ofs, int len) {
        try {
            this.align(2);
            int i = ofs;
            while (i < ofs + len) {
                this.b.writeShort(x[i]);
                ++i;
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_string(String x) {
        try {
            byte[] ab = x.getBytes(this.narrow_charset);
            this.write_long(ab.length + 1);
            this.write(ab);
            this.write(0);
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_ulong(int x) {
        this.write_long(x);
    }

    public void write_ulong_array(int[] x, int ofs, int len) {
        this.write_long_array(x, ofs, len);
    }

    public void write_ulonglong(long x) {
        this.write_longlong(x);
    }

    public void write_ulonglong_array(long[] x, int ofs, int len) {
        this.write_longlong_array(x, ofs, len);
    }

    public void write_ushort(short x) {
        this.write_short(x);
    }

    public void write_ushort_array(short[] x, int ofs, int len) {
        this.write_short_array(x, ofs, len);
    }

    public void write_wchar(char x) {
        try {
            if (this.giop.until_inclusive(1, 1)) {
                this.align(2);
                if (this.wide_native) {
                    this.b.writeShort(x);
                } else {
                    OutputStreamWriter ow = new OutputStreamWriter((OutputStream)((org.omg.CORBA.portable.OutputStream)((java.lang.Object)this.b)), this.wide_charset);
                    ow.write(x);
                    ow.flush();
                }
            } else if (this.wide_native) {
                this.b.writeByte(2);
                this.b.writeChar(x);
            } else {
                String encoded = new String(new char[]{x});
                byte[] bytes = encoded.getBytes(this.wide_charset);
                this.b.write(bytes.length + 2);
                this.b.write(bytes);
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_wchar_array(char[] chars, int offset, int length) {
        try {
            if (this.giop.until_inclusive(1, 1)) {
                this.align(2);
            }
            if (this.wide_native) {
                int i = offset;
                while (i < offset + length) {
                    this.b.writeShort(chars[i]);
                    ++i;
                }
            } else {
                OutputStreamWriter ow = new OutputStreamWriter((OutputStream)((org.omg.CORBA.portable.OutputStream)((java.lang.Object)this.b)), this.wide_charset);
                ow.write(chars, offset, length);
                ow.flush();
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_wstring(String x) {
        try {
            if (this.giop.since_inclusive(1, 2)) {
                byte[] bytes = x.getBytes(this.wide_charset);
                this.write_sequence(bytes);
            } else {
                this.write_long(2 * x.length() + 2);
                int i = 0;
                while (i < x.length()) {
                    this.b.writeShort(x.charAt(i));
                    ++i;
                }
                this.b.writeShort(0);
            }
        }
        catch (IOException ex) {
            Unexpected.error(ex);
        }
    }

    public void write_any_array(Any[] anys, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_any(anys[i]);
            ++i;
        }
    }

    public String[] _truncatable_ids() {
        throw new UnsupportedOperationException("Method _truncatable_ids() not yet implemented.");
    }

    public void write_Abstract(java.lang.Object value) {
        this.write_abstract_interface(value);
    }

    public void write_Value(Serializable value) {
        this.write_value(value);
    }

    private final /* synthetic */ void this() {
        this.giop = new Version(1, 2);
    }

    public AbstractCdrOutput(OutputStream writeTo) {
        this.this();
        this.setOutputStream(writeTo);
        this.setCodeSet(CodeSetServiceContext.STANDARD);
    }

    public AbstractCdrOutput() {
        this.this();
        this.setCodeSet(CodeSetServiceContext.STANDARD);
    }
}

