/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NamespaceTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Path;
import gnu.xml.xpath.Test;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Selector
extends Path {
    public static final int ANCESTOR = 0;
    public static final int ANCESTOR_OR_SELF = 1;
    public static final int ATTRIBUTE = 2;
    public static final int CHILD = 3;
    public static final int DESCENDANT = 4;
    public static final int DESCENDANT_OR_SELF = 5;
    public static final int FOLLOWING = 6;
    public static final int FOLLOWING_SIBLING = 7;
    public static final int NAMESPACE = 8;
    public static final int PARENT = 9;
    public static final int PRECEDING = 10;
    public static final int PRECEDING_SIBLING = 11;
    public static final int SELF = 12;
    final int axis;
    final Test[] tests;

    public final Test[] getTests() {
        return this.tests;
    }

    public final boolean matches(Node context) {
        int tlen;
        short nodeType = context.getNodeType();
        switch (this.axis) {
            case 3: {
                if (nodeType != 2) break;
                return false;
            }
            case 2: 
            case 8: {
                if (nodeType == 2) break;
                return false;
            }
            case 5: {
                return true;
            }
            default: {
                return false;
            }
        }
        if ((tlen = this.tests.length) > 0) {
            int pos = this.getContextPosition(context);
            int len = this.getContextSize(context);
            int j = 0;
            while (j < tlen && len > 0) {
                Test test = this.tests[j];
                if (!test.matches(context, pos, len)) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    private final int getContextPosition(Node ctx) {
        int pos = 1;
        ctx = ctx.getPreviousSibling();
        while (ctx != null) {
            ++pos;
            ctx = ctx.getPreviousSibling();
        }
        return pos;
    }

    private final int getContextSize(Node ctx) {
        if (ctx.getNodeType() == 2) {
            Element parent = ((Attr)ctx).getOwnerElement();
            return parent.getAttributes().getLength();
        }
        Node parent = ctx.getParentNode();
        if (parent != null) {
            return parent.getChildNodes().getLength();
        }
        return 1;
    }

    public final Object evaluate(Node context, int pos, int len) {
        LinkedHashSet acc = new LinkedHashSet();
        this.addCandidates(context, acc);
        ArrayList candidates = new ArrayList(acc);
        List ret = this.filterCandidates(candidates, false);
        return ret;
    }

    final Collection evaluate(Node context, Collection ns) {
        LinkedHashSet acc = new LinkedHashSet();
        Iterator i = ns.iterator();
        while (i.hasNext()) {
            this.addCandidates((Node)i.next(), acc);
        }
        ArrayList candidates = new ArrayList(acc);
        List ret = this.filterCandidates(candidates, true);
        return ret;
    }

    final List filterCandidates(List candidates, boolean cascade) {
        int len = candidates.size();
        int tlen = this.tests.length;
        if (tlen > 0 && len > 0) {
            int j = 0;
            while (j < tlen && len > 0) {
                Test test = this.tests[j];
                ArrayList successful = new ArrayList(len);
                int i = 0;
                while (i < len) {
                    short nodeType;
                    Node node2 = (Node)candidates.get(i);
                    if (cascade && ((nodeType = node2.getNodeType()) == 9 || nodeType == 11) && (this.axis == 5 || this.axis == 1 || this.axis == 12) && this.tests.length == 1 && this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                        successful.add(node2);
                    } else if (test.matches(node2, i + 1, len)) {
                        successful.add(node2);
                    }
                    ++i;
                }
                candidates = successful;
                len = candidates.size();
                ++j;
            }
        }
        return candidates;
    }

    final void addCandidates(Node context, Collection candidates) {
        switch (this.axis) {
            case 3: {
                this.addChildNodes(context, candidates, false);
                break;
            }
            case 4: {
                this.addChildNodes(context, candidates, true);
                break;
            }
            case 5: {
                candidates.add(context);
                this.addChildNodes(context, candidates, true);
                break;
            }
            case 9: {
                this.addParentNode(context, candidates, false);
                break;
            }
            case 0: {
                this.addParentNode(context, candidates, true);
                break;
            }
            case 1: {
                candidates.add(context);
                this.addParentNode(context, candidates, true);
                break;
            }
            case 7: {
                this.addFollowingNodes(context, candidates, false);
                break;
            }
            case 11: {
                this.addPrecedingNodes(context, candidates, false);
                break;
            }
            case 6: {
                this.addFollowingNodes(context, candidates, true);
                break;
            }
            case 10: {
                this.addPrecedingNodes(context, candidates, true);
                break;
            }
            case 2: {
                this.addAttributes(context, candidates);
                break;
            }
            case 8: {
                this.addNamespaceAttributes(context, candidates);
                break;
            }
            case 12: {
                candidates.add(context);
                break;
            }
        }
    }

    final void addChildNodes(Node context, Collection acc, boolean recurse) {
        Node child = context.getFirstChild();
        while (child != null) {
            acc.add(child);
            if (recurse) {
                this.addChildNodes(child, acc, recurse);
            }
            child = child.getNextSibling();
        }
    }

    final void addParentNode(Node context, Collection acc, boolean recurse) {
        Node parent;
        Node node2 = parent = context.getNodeType() == 2 ? ((Attr)context).getOwnerElement() : context.getParentNode();
        if (parent != null) {
            acc.add(parent);
            if (recurse) {
                this.addParentNode(parent, acc, recurse);
            }
        }
    }

    final void addFollowingNodes(Node context, Collection acc, boolean recurse) {
        Node cur = context.getNextSibling();
        while (cur != null) {
            acc.add(cur);
            if (recurse) {
                this.addChildNodes(cur, acc, true);
            }
            cur = cur.getNextSibling();
        }
        if (recurse) {
            Node node2 = context = context.getNodeType() == 2 ? ((Attr)context).getOwnerElement() : context.getParentNode();
            if (context != null) {
                this.addFollowingNodes(context, acc, recurse);
            }
        }
    }

    final void addPrecedingNodes(Node context, Collection acc, boolean recurse) {
        Node cur = context.getPreviousSibling();
        while (cur != null) {
            acc.add(cur);
            if (recurse) {
                this.addChildNodes(cur, acc, true);
            }
            cur = cur.getPreviousSibling();
        }
        if (recurse) {
            Node node2 = context = context.getNodeType() == 2 ? ((Attr)context).getOwnerElement() : context.getParentNode();
            if (context != null) {
                this.addPrecedingNodes(context, acc, recurse);
            }
        }
    }

    final void addAttributes(Node context, Collection acc) {
        NamedNodeMap attrs = context.getAttributes();
        if (attrs != null) {
            int attrLen = attrs.getLength();
            int i = 0;
            while (i < attrLen) {
                Node attr = attrs.item(i);
                if (!this.isNamespaceAttribute(attr)) {
                    acc.add(attr);
                }
                ++i;
            }
        }
    }

    final void addNamespaceAttributes(Node context, Collection acc) {
        NamedNodeMap attrs = context.getAttributes();
        if (attrs != null) {
            int attrLen = attrs.getLength();
            int i = 0;
            while (i < attrLen) {
                Node attr = attrs.item(i);
                if (this.isNamespaceAttribute(attr)) {
                    acc.add(attr);
                }
                ++i;
            }
        }
    }

    final boolean isNamespaceAttribute(Node node2) {
        String uri = node2.getNamespaceURI();
        boolean bl = false;
        if ("http://www.w3.org/2000/xmlns/".equals(uri) || "xmlns".equals(node2.getPrefix()) || "xmlns".equals(node2.getNodeName())) {
            bl = true;
        }
        return bl;
    }

    public final Expr clone(Object context) {
        int len = this.tests.length;
        ArrayList tests2 = new ArrayList(len);
        int i = 0;
        while (i < len) {
            tests2.add(this.tests[i].clone(context));
            ++i;
        }
        return new Selector(this.axis, tests2);
    }

    public final boolean references(QName var) {
        int i = 0;
        while (i < this.tests.length) {
            if (this.tests[i].references(var)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.axis) {
            case 0: {
                buf.append("ancestor::");
                break;
            }
            case 1: {
                buf.append("ancestor-or-self::");
                break;
            }
            case 2: {
                if (this.tests.length == 0 || this.tests[0] instanceof NameTest) {
                    buf.append('@');
                    break;
                }
                buf.append("attribute::");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                buf.append("descendant::");
                break;
            }
            case 5: {
                buf.append("descendant-or-self::");
                break;
            }
            case 6: {
                buf.append("following::");
                break;
            }
            case 7: {
                buf.append("following-sibling::");
                break;
            }
            case 8: {
                buf.append("namespace::");
                break;
            }
            case 9: {
                if (this.tests.length == 0 || this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                    return "..";
                }
                buf.append("parent::");
                break;
            }
            case 10: {
                buf.append("preceding::");
                break;
            }
            case 11: {
                buf.append("preceding-sibling::");
                break;
            }
            case 12: {
                if (this.tests.length == 0 || this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                    return ".";
                }
                buf.append("self::");
                break;
            }
        }
        if (this.tests.length == 0) {
            buf.append('*');
        } else {
            int i = 0;
            while (i < this.tests.length) {
                buf.append(this.tests[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    public Selector(int axis, List tests) {
        this.axis = axis;
        this.tests = new Test[tests.size()];
        tests.toArray(this.tests);
        if (axis == 8 && this.tests.length > 0 && this.tests[0] instanceof NameTest) {
            NameTest nt = (NameTest)this.tests[0];
            this.tests[0] = new NamespaceTest(nt.qName, nt.anyLocalName, nt.any);
        }
    }
}

